/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="test-implementation-path-to-execution-path", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class TestImplementationPathToExecutionPathIndex
implements IProjectIndex {
    private final ValueIndex<HashSet<String>> delegate;

    public TestImplementationPathToExecutionPathIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    private Map<String, HashSet<String>> loadPreviousValues(List<String> testImplementationPaths) throws StorageException {
        List nonNullTestImplementationPaths = testImplementationPaths.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List previousValues = this.delegate.getValues(nonNullTestImplementationPaths);
        HashMap<String, HashSet<String>> uniformPathsAndValuesWithPartition = new HashMap<String, HashSet<String>>();
        for (int i = 0; i < nonNullTestImplementationPaths.size(); ++i) {
            String testImplementationPath = (String)nonNullTestImplementationPaths.get(i);
            HashSet previousValuesForPartitionAndPath = (HashSet)previousValues.get(i);
            if (previousValuesForPartitionAndPath == null) {
                previousValuesForPartitionAndPath = new HashSet();
            }
            uniformPathsAndValuesWithPartition.put(testImplementationPath, previousValuesForPartitionAndPath);
        }
        return uniformPathsAndValuesWithPartition;
    }

    public void addTestExecutionPaths(Map<String, HashSet<String>> testImplementationPathToExecutionPaths) throws StorageException {
        this.delegate.setOrMergeValues(PairList.fromMap(testImplementationPathToExecutionPaths), (x$0, xva$1) -> CollectionUtils.unionSet((Collection)x$0, (Collection[])new Collection[]{xva$1}));
    }

    public Set<String> getExecutionPathsForImplementationPath(String testImplementationPath) throws StorageException {
        return (Set)this.delegate.getValue(testImplementationPath);
    }

    public List<HashSet<String>> getExecutionPathsForImplementationPaths(List<String> testImplementationPath) throws StorageException {
        return this.delegate.getValues(testImplementationPath);
    }

    public Set<String> getExecutionPathsForImplementationPathsFlat(List<String> testImplementationPaths) throws StorageException {
        return this.getExecutionPathsForImplementationPaths(testImplementationPaths).stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public void deleteTestExecutionPaths(PairList<String, @Nullable String> testExecutionDatas) throws StorageException {
        Map<String, HashSet<String>> uniformPathsAndValuesWithPartition = this.loadPreviousValues(testExecutionDatas.extractSecondList());
        for (Pair testExecutionData : testExecutionDatas) {
            String testImplementationPath = (String)testExecutionData.getSecond();
            String testExecutionPath = (String)testExecutionData.getFirst();
            if (testImplementationPath == null) continue;
            uniformPathsAndValuesWithPartition.get(testImplementationPath).remove(testExecutionPath);
        }
        PairList valuesToUpdate = new PairList();
        ArrayList<String> emptyPartitionAndPaths = new ArrayList<String>();
        for (Map.Entry<String, HashSet<String>> uniformPathAndValueWithPartition : uniformPathsAndValuesWithPartition.entrySet()) {
            String testImplementationPath = uniformPathAndValueWithPartition.getKey();
            HashSet<String> value = uniformPathAndValueWithPartition.getValue();
            if (value.isEmpty()) {
                emptyPartitionAndPaths.add(testImplementationPath);
                continue;
            }
            valuesToUpdate.add((Object)testImplementationPath, value);
        }
        this.delegate.setValues(valuesToUpdate);
        this.delegate.removeValues(emptyPartitionAndPaths);
    }

    public void deleteTestImplementationPaths(List<String> testImplementationPaths) throws StorageException {
        this.delegate.removeValues(testImplementationPaths);
    }

    public void setTestExecutionPaths(String testImplementationPath, HashSet<String> executionPaths) throws StorageException {
        this.delegate.setValue(testImplementationPath, executionPaths);
    }
}

