/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class MacroBasedFrameworkTestCaseExtractionStrategyBase
implements ITestCaseExtractionStrategy {
    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        PairList extractedTestCases = new PairList();
        List<IToken> testStartTokens = MacroBasedFrameworkTestCaseExtractionStrategyBase.findTestStartTokens(context, this.getTestCaseKeywords());
        PairList<IToken, Optional<ShallowEntity>> testEntities = this.findTestEntitiesCorrespondingToTestStartTokens(context, testStartTokens);
        for (int i = 0; i < testEntities.size(); ++i) {
            ShallowEntity rawEntity;
            Optional<Pair<String, String>> testSuiteAndCaseName;
            Optional optionalRawEntity = (Optional)testEntities.getSecond(i);
            if (optionalRawEntity.isEmpty() || (testSuiteAndCaseName = this.determineTestSuiteAndCaseName((List<IToken>)(rawEntity = (ShallowEntity)optionalRawEntity.get()).includedTokens(), context.getPreprocessedTokens(), context)).isEmpty()) continue;
            String testSuiteName = (String)testSuiteAndCaseName.get().getFirst();
            String testCaseName = (String)testSuiteAndCaseName.get().getSecond();
            UniformPath testUniformPath = TestCaseExtractionUtils.convertToTestImplementationUniformPath(context.getUniformPath(), testSuiteName, testCaseName);
            String testName = testSuiteName + UniformPathUtils.SEPARATOR + testCaseName;
            TestImplementation testImplementation = MacroBasedFrameworkTestCaseExtractionStrategyBase.determineTestImplementation(testName, context, rawEntity);
            extractedTestCases.add((Object)testUniformPath.toString(), (Object)testImplementation);
        }
        return extractedTestCases;
    }

    protected static @NonNull TestImplementation determineTestImplementation(String testName, TokenElementTransformContext context, ShallowEntity rawShallowEntity) {
        TextRegionLocation codeLocation = context.createLocationForRawShallowEntity(rawShallowEntity);
        TextRegionLocation codeLocationWithComment = TestCaseExtractionUtils.createCommentIncludingLocationForShallowEntity(context, rawShallowEntity, codeLocation, context::getNonRawOffset);
        return new TestImplementation(testName, TestCaseExtractionUtils.buildImplementationHash(rawShallowEntity), codeLocation, codeLocationWithComment);
    }

    protected abstract Set<String> getTestCaseKeywords();

    protected static List<IToken> findTestStartTokens(TokenElementTransformContext context, Set<String> testCaseKeywords) {
        ArrayList<IToken> testStartTokens = new ArrayList<IToken>();
        for (IToken token : context.getTokens()) {
            if (!testCaseKeywords.contains(token.getText())) continue;
            testStartTokens.add(token);
        }
        return testStartTokens;
    }

    protected PairList<IToken, Optional<ShallowEntity>> findTestEntitiesCorrespondingToTestStartTokens(TokenElementTransformContext context, List<IToken> testStartTokens) {
        PairList testEntities = new PairList();
        for (IToken testStartToken : testStartTokens) {
            int rawStartLine = context.getRawLineFromOffset(testStartToken.getOffset());
            Optional<ShallowEntity> shallowEntity = this.findEntity(context, rawStartLine);
            testEntities.add((Object)testStartToken, shallowEntity);
        }
        return testEntities;
    }

    protected abstract Optional<ShallowEntity> findEntity(TokenElementTransformContext var1, int var2);

    protected Optional<Pair<String, String>> determineTestSuiteAndCaseName(List<IToken> testCaseEntityTokens, List<IToken> preprocessedTokens, TokenElementTransformContext context) {
        String testSuiteName = testCaseEntityTokens.get(2).getText();
        String testCaseName = testCaseEntityTokens.get(4).getText();
        int rawTestSuiteTokenOffset = testCaseEntityTokens.get(2).getOffset();
        int rawTestNameTokenOffset = testCaseEntityTokens.get(4).getOffset();
        int filteredTestSuiteTokenOffset = context.getNonRawOffset(rawTestSuiteTokenOffset);
        int filteredTestNameTokenOffset = context.getNonRawOffset(rawTestNameTokenOffset);
        int preprocessedTestSuiteTokenIndex = TokenStreamUtils.indexOfByOffset(preprocessedTokens, (int)filteredTestSuiteTokenOffset);
        int preprocessedTestNameTokenIndex = TokenStreamUtils.indexOfByOffset(preprocessedTokens, (int)filteredTestNameTokenOffset);
        if (preprocessedTestSuiteTokenIndex != -1) {
            testSuiteName = preprocessedTokens.get(preprocessedTestSuiteTokenIndex).getText();
        }
        if (preprocessedTestNameTokenIndex != -1) {
            testCaseName = preprocessedTokens.get(preprocessedTestNameTokenIndex).getText();
        }
        return Optional.of(Pair.createPair((Object)testSuiteName, (Object)testCaseName));
    }
}

