/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionMap;

abstract class CollectionMapCollectorBase<T, K, V, R extends CollectionMap<K, V, ?>>
implements Collector<T, R, R> {
    private final Function<T, K> keyMapper;
    private final Function<T, V> valueMapper;

    protected CollectionMapCollectorBase(@NonNull Function<T, K> keyMapper, @NonNull Function<T, V> valueMapper) {
        CCSMAssert.isNotNull(keyMapper, () -> String.format("Expected \"%s\" to be not null", "keyMapper"));
        CCSMAssert.isNotNull(valueMapper, () -> String.format("Expected \"%s\" to be not null", "valueMapper"));
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    @Override
    public BiConsumer<R, T> accumulator() {
        return (collection, element) -> collection.add(this.keyMapper.apply(element), this.valueMapper.apply(element));
    }

    @Override
    public BinaryOperator<R> combiner() {
        return (collection1, collection2) -> {
            collection1.addAll(collection2);
            return collection1;
        };
    }

    @Override
    public Function<R, R> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
    }
}

