/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.datamining.IRecommender;
import org.conqat.lib.commons.datamining.IRecommenderUser;
import org.conqat.lib.commons.datamining.Recommendation;
import org.conqat.lib.commons.datamining.RecommenderRatingDatabase;

public class CFRatingRecommender<T>
implements IRecommender<T> {
    private RecommenderRatingDatabase<T> ratingDatabase;
    private int numNeighbors;
    private int maxRecommendations;

    public CFRatingRecommender(RecommenderRatingDatabase<T> ratingDatabase, int numNeighbors, int maxRecommendations) {
        this.ratingDatabase = ratingDatabase;
        this.numNeighbors = numNeighbors;
        this.maxRecommendations = maxRecommendations;
    }

    @Override
    public Set<Recommendation<T>> recommend(IRecommenderUser queryUser) {
        UnmodifiableSet<IRecommenderUser> users = this.ratingDatabase.getUsers();
        List neighbors = new ArrayList<Pair<Double, IRecommenderUser>>();
        for (IRecommenderUser user : users) {
            if (user.equals(queryUser)) continue;
            neighbors.add(new Pair<Double, IRecommenderUser>(user.similarity(queryUser), user));
        }
        Collections.sort(neighbors);
        Collections.reverse(neighbors);
        neighbors = neighbors.subList(0, this.numNeighbors);
        HashSet<Recommendation<T>> result = new HashSet<Recommendation<T>>();
        HashMap<T, Double> recommendedItems = new HashMap<T, Double>();
        double sumSimilarity = 0.0;
        Set<T> userItems = this.ratingDatabase.getLikedItems(queryUser);
        for (Pair neighbor : neighbors) {
            sumSimilarity += ((Double)neighbor.getFirst()).doubleValue();
            Set<T> neighborItems = this.ratingDatabase.getLikedItems((IRecommenderUser)neighbor.getSecond());
            for (T item : neighborItems) {
                if (userItems.contains(item)) continue;
                if (!recommendedItems.containsKey(item)) {
                    recommendedItems.put(item, 0.0);
                }
                recommendedItems.put(item, (Double)recommendedItems.get(item) + (Double)neighbor.getFirst());
            }
        }
        ArrayList sortedItems = new ArrayList(recommendedItems.keySet());
        sortedItems.sort(Comparator.comparing(recommendedItems::get).reversed());
        while (result.size() < this.maxRecommendations && !sortedItems.isEmpty()) {
            Object item = sortedItems.get(0);
            double confidence = 0.0;
            if (sumSimilarity > 0.0) {
                confidence = (Double)recommendedItems.get(item) / sumSimilarity;
            }
            result.add(new Recommendation(item, confidence));
            sortedItems.remove(0);
        }
        return result;
    }
}

