/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.datamining.IRecommenderUser;

public class ShoppingBasketUser<T>
implements IRecommenderUser {
    private Set<T> items;

    public ShoppingBasketUser(Set<T> items) {
        CCSMAssert.isFalse(items.isEmpty(), "Items must not be empty");
        this.items = items;
    }

    public Set<T> getItems() {
        return this.items;
    }

    @Override
    public double similarity(IRecommenderUser other) {
        if (!(other instanceof ShoppingBasketUser)) {
            throw new IllegalArgumentException();
        }
        ShoppingBasketUser user = (ShoppingBasketUser)other;
        return ShoppingBasketUser.similarity(this.items, user.items);
    }

    private static double similarity(Set<?> set1, Set<?> set2) {
        CCSMAssert.isFalse(set1.isEmpty() || set2.isEmpty(), "Sets must not be empty");
        HashSet intersection = new HashSet(set1);
        intersection.retainAll(set2);
        double numerator = intersection.size();
        double denominator = Math.sqrt(set1.size()) * Math.sqrt(set2.size());
        return numerator / denominator;
    }

    public String toString() {
        return this.items.toString();
    }
}

