/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.PlainClassFileFilter;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ClassPathUtils {
    public static final String CLASS_FILE_SUFFIX = ".class";

    public static List<String> getClassPathEntries() {
        String classpath = System.getProperty("java.class.path");
        return StringUtils.splitToList(classpath, File.pathSeparator);
    }

    public static String createClassPath(IURLResolver resolver, Class<?> anchorClass) throws IOException {
        String protocol;
        URL url = ClassPathUtils.obtainClassFileURL(anchorClass);
        if (url == null) {
            throw new AssertionError((Object)"Internal assumption violated.");
        }
        if (resolver != null) {
            url = resolver.resolve(url);
        }
        if ("file".equals(protocol = url.getProtocol())) {
            return ClassPathUtils.createFileClasspath(url, anchorClass);
        }
        if ("jar".equals(protocol)) {
            return FileSystemUtils.extractJarFileFromJarURL(url).getCanonicalPath();
        }
        throw new IOException("Unsupported protocol: " + protocol);
    }

    public static URL obtainClassFileURL(Class<?> clazz) {
        Object name = clazz.getSimpleName();
        while (clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
            name = clazz.getSimpleName() + "$" + (String)name;
        }
        return clazz.getResource((String)name + CLASS_FILE_SUFFIX);
    }

    private static String createFileClasspath(URL url, Class<?> clazz) throws IOException {
        String path = UrlUtils.decodeFromUtf8(url.getPath());
        path = path.substring(0, path.length() - 6 - clazz.getName().length());
        return new File(path).getCanonicalPath();
    }

    public static List<String> getClassNames(File directory) {
        ArrayList<String> classNames = new ArrayList<String>();
        List<File> classFiles = FileSystemUtils.listFilesRecursively(directory, new PlainClassFileFilter());
        String prefix = directory.getAbsolutePath() + File.separator;
        for (File classFile : classFiles) {
            String path = classFile.getAbsolutePath();
            path = StringUtils.stripPrefix(path, prefix);
            path = StringUtils.stripSuffix(path, CLASS_FILE_SUFFIX);
            classNames.add(path.replace(File.separator, "."));
        }
        return classNames;
    }

    public static interface IURLResolver {
        public URL resolve(URL var1) throws IOException;
    }
}

