/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IIdProvider;
import org.conqat.lib.commons.collections.IdManager;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.visitor.IMeshWalker;

public class GraphDebuggingUtils {
    private static final String[] EDGE_COLORS = new String[]{"black", "blue", "red", "green"};

    @SafeVarargs
    public static <NodeT, X extends Exception> String getString(NodeT root, IIdProvider<Integer, NodeT> optionalIdProvider, IMeshWalker<NodeT, X> ... walkers) throws X {
        return GraphDebuggingUtils.getString(root, optionalIdProvider, true, walkers);
    }

    @SafeVarargs
    public static <NodeT, X extends Exception> String getShortString(NodeT root, IIdProvider<Integer, NodeT> optionalIdProvider, IMeshWalker<NodeT, X> ... walkers) throws X {
        return GraphDebuggingUtils.getString(root, optionalIdProvider, false, walkers);
    }

    @SafeVarargs
    private static <NodeT, X extends Exception> String getString(NodeT root, IIdProvider<Integer, NodeT> optionalIdProvider, boolean detailed, IMeshWalker<NodeT, X> ... walkers) throws X {
        IIdProvider idProvider = GraphDebuggingUtils.getIdProvider(optionalIdProvider);
        INodeRenderer<Object> nodeRenderer = node -> {
            StringBuilder rendering = new StringBuilder();
            rendering.append(idProvider.obtainId(node));
            if (detailed) {
                rendering.append(": { ");
                rendering.append(node);
                rendering.append(" }");
            }
            return rendering.toString();
        };
        IEdgeRenderer<Object> edgeRenderer = (node, edgeClass, adjacentNodes) -> " --> " + StringUtils.concat(CollectionUtils.map(adjacentNodes, idProvider::obtainId), ", ") + "\n";
        return GraphDebuggingUtils.renderGraph(root, nodeRenderer, edgeRenderer, walkers);
    }

    @SafeVarargs
    public static <NodeT, X extends Exception> String getDotString(NodeT root, IIdProvider<Integer, NodeT> optionalIdProvider, IMeshWalker<NodeT, X> ... walkers) throws X {
        IIdProvider idProvider = GraphDebuggingUtils.getIdProvider(optionalIdProvider);
        INodeRenderer<Object> nodeRenderer = node -> String.valueOf(idProvider.obtainId(node)) + " [label = " + GraphDebuggingUtils.toQuotedString(node.toString()) + "];\n";
        IEdgeRenderer<Object> edgeRenderer = (node, edgeClass, adjacentNodes) -> String.valueOf(idProvider.obtainId(node)) + " -> { " + StringUtils.concat(CollectionUtils.map(adjacentNodes, idProvider::obtainId), " ") + " } [color=\"" + EDGE_COLORS[edgeClass] + "\"];\n";
        return "digraph {\n" + GraphDebuggingUtils.renderGraph(root, nodeRenderer, edgeRenderer, walkers) + "}\n";
    }

    private static <NodeT> IIdProvider<Integer, NodeT> getIdProvider(IIdProvider<Integer, NodeT> optionalIdProvider) {
        return Optional.ofNullable(optionalIdProvider).orElseGet(IdManager::new);
    }

    @SafeVarargs
    private static <NodeT, X extends Exception> String renderGraph(NodeT root, INodeRenderer<NodeT> nodeRenderer, IEdgeRenderer<NodeT> edgeRenderer, IMeshWalker<NodeT, X> ... walkers) throws X {
        StringBuilder graph = new StringBuilder();
        ArrayDeque<NodeT> todo = new ArrayDeque<NodeT>(Collections.singleton(root));
        HashSet addedNodes = new HashSet();
        while (!todo.isEmpty()) {
            Object nodeToAdd = todo.poll();
            if (addedNodes.contains(nodeToAdd)) continue;
            graph.append(nodeRenderer.render(nodeToAdd));
            for (int walkerIndex = 0; walkerIndex < walkers.length; ++walkerIndex) {
                IMeshWalker<NodeT, X> walker = walkers[walkerIndex];
                Collection<NodeT> adjacentElements = walker.getAdjacentElements(nodeToAdd);
                graph.append(edgeRenderer.render(nodeToAdd, walkerIndex, adjacentElements));
                todo.addAll(adjacentElements);
            }
            addedNodes.add(nodeToAdd);
        }
        return graph.toString();
    }

    private static String toQuotedString(String string) {
        return "\"" + string.replace("\"", "\\\"") + "\"";
    }

    @FunctionalInterface
    private static interface INodeRenderer<NodeT> {
        public String render(NodeT var1);
    }

    @FunctionalInterface
    private static interface IEdgeRenderer<NodeT> {
        public String render(NodeT var1, int var2, Collection<NodeT> var3);
    }
}

