/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.FilteredObjectStreams;

public class SerializationUtils {
    public static byte[] serializeToByteArray(Serializable object) throws IOException {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ObjectOutputStream out = FilteredObjectStreams.filteredOutputStream(outBuffer);
        try {
            out.writeObject(object);
        }
        catch (OutOfMemoryError e) {
            if (e.getMessage() != null && (e.getMessage().matches("Required array length \\d+ \\+ \\d+ is too large") || e.getMessage().equals("Requested array size exceeds VM limit"))) {
                OutOfMemoryError e1 = new OutOfMemoryError(String.format("Cannot serialize instance of type %s as it is too large to fit into a single byte[].", object.getClass()));
                e1.addSuppressed(e);
                throw e1;
            }
            throw e;
        }
        out.close();
        return outBuffer.toByteArray();
    }

    public static Serializable deserializeFromByteArray(byte @Nullable [] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream in = FilteredObjectStreams.filteredInputStream(new ByteArrayInputStream(bytes));
        try {
            Serializable serializable = (Serializable)in.readObject();
            return serializable;
        }
        finally {
            FileSystemUtils.close(in);
        }
    }

    public static <T extends Serializable> T cloneBySerialization(T t) {
        try {
            return (T)SerializationUtils.deserializeFromByteArray(SerializationUtils.serializeToByteArray(t));
        }
        catch (IOException e) {
            CCSMAssert.fail("This should be impossible as we are working in memory!");
            return null;
        }
        catch (ClassNotFoundException e) {
            CCSMAssert.fail("This should be impossible as we just had the object available!");
            return null;
        }
    }

    public static void insertInt(int i, byte[] bytes, int position) {
        bytes[position++] = (byte)(i >> 24 & 0xFF);
        bytes[position++] = (byte)(i >> 16 & 0xFF);
        bytes[position++] = (byte)(i >> 8 & 0xFF);
        bytes[position] = (byte)(i & 0xFF);
    }

    public static int extractInt(byte[] bytes, int position) {
        int result = bytes[position++] & 0xFF;
        result <<= 8;
        result |= bytes[position++] & 0xFF;
        result <<= 8;
        result |= bytes[position++] & 0xFF;
        result <<= 8;
        return result |= bytes[position++] & 0xFF;
    }

    public static void unsupportedWriteObject(@Nullable ObjectOutputStream ignoredStream) {
        SerializationUtils.unsupportedWriteObject(ignoredStream, "Attempt to serialize an object, which should never be serialized");
    }

    public static void unsupportedWriteObject(@Nullable ObjectOutputStream ignoredStream, String message) {
        CCSMAssert.fail(message);
    }

    public static void unsupportedReadObject(@Nullable ObjectInputStream ignoredStream) {
        SerializationUtils.unsupportedReadObject(ignoredStream, "Attempt to deserialize an object, which should never be deserialized");
    }

    public static void unsupportedReadObject(@Nullable ObjectInputStream ignoredStream, String message) {
        CCSMAssert.fail(message);
    }
}

