/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class CatchExceptionCheckBase
extends CheckImplementationBase {
    private static final Set<String> TARGET_SUBTYPES = CollectionUtils.asHashSet((Object[])new String[]{"catch", "@catch"});

    @Override
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.findNestedEntities(this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD, entity -> true, (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TARGET_SUBTYPES.contains(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        int endOfClassName;
        List<IToken> catchArgumentTokens = TokenStreamUtils.tokensBetween((List<IToken>)entity.ownStartTokens(), ETokenType.LPAREN, ETokenType.RPAREN);
        int numberOfTokens = catchArgumentTokens.size();
        if (numberOfTokens == 0) {
            if (this.createFindingForException(Optional.empty(), entity)) {
                this.buildFinding(this.getFindingMessage(Optional.empty()), this.buildLocation().forEntity(entity)).createAndStore();
            }
            return;
        }
        int currentIndex = 0;
        while ((endOfClassName = CatchExceptionCheckBase.findLastTokenIndexOfClassName(catchArgumentTokens, currentIndex)) != -1) {
            List<IToken> typeTokens = catchArgumentTokens.subList(currentIndex, endOfClassName + 1);
            String className = TokenStreamTextUtils.concatTokenTexts(typeTokens);
            if (this.createFindingForException(Optional.of(className), entity)) {
                this.buildFinding(this.getFindingMessage(Optional.of(className)), this.buildLocation().forEntity(entity)).createAndStore();
            }
            if (numberOfTokens > endOfClassName + 1 && catchArgumentTokens.get(endOfClassName + 1).getType() == ETokenType.OR && (currentIndex = endOfClassName + 2) < numberOfTokens) continue;
        }
    }

    public static int findLastTokenIndexOfClassName(List<IToken> tokens, int startIndex) {
        if (tokens.get(startIndex).getType() == ETokenType.ID) {
            return startIndex;
        }
        if (tokens.get(startIndex).getType() != ETokenType.IDENTIFIER) {
            return -1;
        }
        int currentIndex = startIndex;
        int numberOfTokens = tokens.size();
        while (numberOfTokens > currentIndex + 2 && tokens.get(currentIndex + 1).getType() == ETokenType.DOT && tokens.get(currentIndex + 2).getType() == ETokenType.IDENTIFIER) {
            currentIndex += 2;
        }
        return currentIndex;
    }

    protected abstract boolean createFindingForException(Optional<String> var1, ShallowEntity var2) throws CheckException;

    protected abstract String getFindingMessage(Optional<String> var1);
}

