/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.LocationBuilder;
import eu.cqse.check.framework.core.option.ICheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.xpath.CheckXPathUtils;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;

public abstract class CheckImplementationBase {
    protected ICheckContext context = null;

    public void setContext(ICheckContext context) {
        CCSMAssert.isTrue((this.context == null ? 1 : 0) != 0, (String)"The context has already been set.");
        this.context = context;
    }

    public void initialize() throws CheckException {
    }

    public abstract void execute() throws CheckException;

    public List<ICheckOption<?>> getAdditionalOptions(String readableCheckName) {
        return Collections.emptyList();
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED;
    }

    @Deprecated
    protected List<ShallowEntity> select(String xPathExpression) throws CheckException {
        return CheckImplementationBase.select(this.context.getRootEntity(this.getCodeViewOption()), xPathExpression);
    }

    @Deprecated
    public static List<ShallowEntity> select(ShallowEntity entity, String xPathExpression) throws CheckException {
        BaseXPath xPath = CheckXPathUtils.getXPath(xPathExpression);
        try {
            Object result = xPath.evaluate((Object)entity);
            if (result instanceof List) {
                return (List)result;
            }
            throw new CheckException("Evaluating the xPath expression '" + xPathExpression + "' returned unexpected result: " + String.valueOf(result));
        }
        catch (JaxenException e) {
            throw new CheckException((Exception)((Object)e));
        }
    }

    protected void createFindingForSiblings(String message, PairList<IToken, IToken> startAndEndTokens, List<FindingPropertyList> properties) throws CheckException {
        ArrayList<TextRegionLocation> validLocations = new ArrayList<TextRegionLocation>();
        ArrayList<FindingPropertyList> propertiesForValidLocations = new ArrayList<FindingPropertyList>();
        for (int i = 0; i < startAndEndTokens.size(); ++i) {
            Optional<TextRegionLocation> location = this.buildLocation().betweenTokens((IToken)startAndEndTokens.getFirst(i), (IToken)startAndEndTokens.getSecond(i), ECodeViewOption.ETextViewOption.FILTERED_CONTENT);
            if (location.isEmpty()) continue;
            validLocations.add(location.get());
            if (properties == null || properties.size() <= i) continue;
            propertiesForValidLocations.add(properties.get(i));
        }
        this.createFindingsAndLinkAsSiblings(message, validLocations, propertiesForValidLocations);
    }

    protected void createFindingForSiblingEntities(String message, List<ShallowEntity> associatedEntities) {
        ArrayList<TextRegionLocation> locations = new ArrayList<TextRegionLocation>();
        for (ShallowEntity entity : associatedEntities) {
            Optional<TextRegionLocation> location = this.buildLocation().forEntity(entity);
            location.ifPresent(locations::add);
        }
        this.createFindingsAndLinkAsSiblings(message, locations, null);
    }

    protected void createFindingsAndLinkAsSiblings(String message, List<TextRegionLocation> locations, List<FindingPropertyList> propertiesForLocations) {
        for (int i = 0; i < locations.size(); ++i) {
            TextRegionLocation location = locations.get(i);
            CCSMAssert.isTrue((boolean)location.getUniformPath().equals(this.context.getUniformPath()), (String)"Can't create findings for files other than the currently analyzed file.");
            FindingPropertyList currentProperties = new FindingPropertyList();
            if (propertiesForLocations != null && propertiesForLocations.size() > i) {
                currentProperties = propertiesForLocations.get(i);
            }
            currentProperties.addProperty("Instances", locations.size());
            currentProperties.addProperty("Character Length", location.getRawEndOffset() - location.getRawStartOffset());
            this.buildFinding(message, (ElementLocation)location).addSiblingLocations(locations).addFindingProperties(currentProperties).createAndStore();
        }
    }

    public static CheckImplementationBase createInstance(Class<?> checkClass) throws CheckException {
        CheckImplementationBase implementation;
        try {
            implementation = (CheckImplementationBase)checkClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | InstantiationException | NoSuchMethodException e) {
            throw new CheckException("Check class " + checkClass.getName() + " does not provide a default constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new CheckException("Check class " + checkClass.getName() + "'s default constructor is not visible.", e);
        }
        catch (ClassCastException e) {
            throw new CheckException("Check class " + checkClass.getName() + " does not implement CheckImplementationBase.", e);
        }
        catch (Exception e) {
            throw new CheckException("Check class" + checkClass.getName() + " could not be instantiated.", e);
        }
        return implementation;
    }

    public boolean isAbap() {
        return this.context.getUniformPath().endsWith(".abap");
    }

    protected LocationBuilder buildLocation() {
        return new LocationBuilder(this.context.buildLocation(), this.getCodeViewOption().textView);
    }

    protected CheckFindingBuilderBase buildFinding(String message, ElementLocation location) {
        return this.context.buildFinding(message, location);
    }

    protected CheckFindingBuilderBase buildFinding(String message, Optional<? extends ElementLocation> location) {
        return this.context.buildFinding(message, location.orElse(null));
    }

    protected UnmodifiableList<ShallowEntity> getRootChildren() throws CheckException {
        return this.context.getRootEntity(this.getCodeViewOption()).getChildren();
    }
}

