/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.preprocessor.c.CBoundsSafetyExtensionMacroSupplier;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CompilerDefinedMacroSupplier;
import eu.cqse.check.framework.preprocessor.c.IfDirectivePreprocessor;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.preprocessor.c.IncludeStatementMatcher;
import eu.cqse.check.framework.preprocessor.c.IncludedTokens;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.preprocessor.c.MacroExpansionStepsLogger;
import eu.cqse.check.framework.preprocessor.c.MacroInvocationPreprocessor;
import eu.cqse.check.framework.preprocessor.c.ParsedMacroProvider;
import eu.cqse.check.framework.preprocessor.c.PragmaDirectivePreprocessor;
import eu.cqse.check.framework.preprocessor.c.PreprocessorIncludeTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.preprocessor.objc.ObjectiveCPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class CPreprocessor
implements IPreprocessor {
    public static final Predicate<IToken> IS_MACRO_TOKEN = token -> "##macro##".equals(token.getOriginId());
    private static final String PREPROCESSOR_PARSE_LOG_ORIGIN_STEP = "PREPROCESSOR";
    private static final Pattern ERROR_PATTERN = Pattern.compile("#\\s*error\\s*(.*)");
    private static final Pattern WARNING_PATTERN = Pattern.compile("#\\s*warning\\s*(.*)");
    private static final Pattern LINE_PATTERN = Pattern.compile("#\\s*line\\s*(.*)");
    private static final int INCLUDE_NESTING_DEPTH_LIMIT = 20;
    private static final ITokenMatcher INTERESTING_TOKEN_TYPES_IN_HEADERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PREPROCESSOR_DIRECTIVE, ETokenType.PREPROCESSOR_INCLUDE});
    private static final Logger LOGGER = LogManager.getLogger();
    private final ParsedMacroProvider macroProvider;
    private MacroExpansionStepsLogger expansionStepsLogger = MacroExpansionStepsLogger.NO_OP;
    protected final boolean dropSourceCodeFromIncludedFiles;
    private final boolean disallowRepeatedIncludes;
    private static final EnumSet<ETokenType> IMPORT_MODIFIER_TOKENS = EnumSet.of(ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.LPAREN, ETokenType.RPAREN);

    public CPreprocessor(ParsedMacroProvider macroProvider, boolean dropSourceCodeFromIncludedFiles, boolean disallowRepeatedIncludes) {
        this.dropSourceCodeFromIncludedFiles = dropSourceCodeFromIncludedFiles;
        this.disallowRepeatedIncludes = disallowRepeatedIncludes;
        this.macroProvider = macroProvider;
    }

    @Override
    public List<IToken> preprocess(String uniformPath, List<IToken> tokens) {
        List<PreprocessorTokenReplacement> replacements = this.computeReplacementsForTranslationUnit(uniformPath, tokens);
        return CPreprocessingUtils.applyReplacements(replacements, tokens);
    }

    public void setExpansionStepsLogger(MacroExpansionStepsLogger expansionStepsLogger) {
        this.expansionStepsLogger = expansionStepsLogger;
    }

    public MacroExpansionStepsLogger getExpansionStepsLogger() {
        return this.expansionStepsLogger;
    }

    public List<PreprocessorTokenReplacement> computeReplacementsForTranslationUnit(String uniformPath, List<IToken> fileTokens) {
        IncludedFilesContext includedFiles = new IncludedFilesContext(uniformPath);
        ELanguage language = TokenStreamUtils.getLanguage(fileTokens);
        List<PreprocessorTokenReplacement> replacements = this.computeTopLevelReplacements(uniformPath, language, fileTokens, includedFiles);
        if (PreprocessedTokenStreamUtils.containsMacroExpandedContent(fileTokens)) {
            LOGGER.error("The preprocessor modified a token in the original token list (set the 'macro' origin) on file " + uniformPath + ". This could influence results of analyses based on \"entities without preprocessor-expansion tokens\". To debug this, we need the file and all relevant headers.");
        }
        return replacements;
    }

    private List<PreprocessorTokenReplacement> computeTopLevelReplacements(String uniformPath, @Nullable ELanguage language, List<IToken> fileTokens, IncludedFilesContext includedFiles) {
        MacroInvocationPreprocessor macroPreprocessor = new MacroInvocationPreprocessor(this.expansionStepsLogger);
        ArrayList<PreprocessorTokenReplacement> replacements = new ArrayList<PreprocessorTokenReplacement>();
        IfDirectivePreprocessor.ConditionalRegionStack conditionalRegionStack = new IfDirectivePreprocessor.ConditionalRegionStack();
        FilePreprocessorContext fileContext = null;
        if (!fileTokens.isEmpty()) {
            fileContext = new FilePreprocessorContext(this.macroProvider, uniformPath, 0, language);
        }
        for (int originalTokenIndex = 0; originalTokenIndex < fileTokens.size(); ++originalTokenIndex) {
            PreprocessorTokenReplacement tokenReplacement;
            if (!replacements.isEmpty() && Objects.requireNonNull((PreprocessorTokenReplacement)CollectionUtils.getLast(replacements)).replacesOriginalTokenIndex(originalTokenIndex) || (tokenReplacement = this.computeReplacementForPotentialExpansionAtTokenIndex(fileTokens, originalTokenIndex, includedFiles, macroPreprocessor, conditionalRegionStack, fileContext)) == null) continue;
            replacements.add(tokenReplacement);
        }
        replacements.sort(Comparator.comparingInt(replacement -> replacement.originalTokensStartIndex));
        if (language != null && language.isObjectiveCOrObjectiveCpp()) {
            return ObjectiveCPreprocessingUtils.generateNewAtTokensInReplacements(fileTokens, replacements);
        }
        return replacements;
    }

    private @Nullable PreprocessorTokenReplacement computeReplacementForPotentialExpansionAtTokenIndex(List<IToken> fileTokens, int originalTokenIndex, IncludedFilesContext includedFiles, MacroInvocationPreprocessor macroPreprocessor, IfDirectivePreprocessor.ConditionalRegionStack conditionalRegionStack, FilePreprocessorContext fileContext) {
        try {
            IToken token = fileTokens.get(originalTokenIndex);
            if (this.dropSourceCodeFromIncludedFiles && includedFiles.includeHierarchy.size() > 1 && !INTERESTING_TOKEN_TYPES_IN_HEADERS.matches(token)) {
                return CPreprocessor.createReplacementUntilNextPreprocessorDirective(fileTokens, originalTokenIndex);
            }
            fileContext.setLineNumber(token.getLineNumber());
            return this.computeReplacementForToken(originalTokenIndex, fileTokens, macroPreprocessor, fileContext, conditionalRegionStack, includedFiles);
        }
        catch (PreprocessorException e) {
            int oneBasedLineNumber = fileTokens.get(originalTokenIndex).getLineNumber() + 1;
            CPreprocessor.logParseLogMessage(e.getMessage() + "\n while preprocessing " + fileTokens.get(originalTokenIndex).getOriginId() + ":" + oneBasedLineNumber + "\ninclude hierarchy: " + String.valueOf(includedFiles.getCurrentIncludeHierarchy()), fileTokens.get(originalTokenIndex), fileContext);
            return new PreprocessorTokenReplacement(Collections.emptyList(), originalTokenIndex, originalTokenIndex, new PreprocessorUsageInformation(), e.getMessage());
        }
        catch (AssertionError | Exception | StackOverflowError e) {
            LOGGER.error("Exception while preprocessing " + fileTokens.get(originalTokenIndex).getOriginId() + ":" + fileTokens.get(originalTokenIndex).getLineNumber() + "\ninclude hierarchy: " + String.valueOf(includedFiles.getCurrentIncludeHierarchy()), (Throwable)e);
            return new PreprocessorTokenReplacement(Collections.emptyList(), originalTokenIndex, originalTokenIndex, new PreprocessorUsageInformation(), ((Throwable)e).getMessage());
        }
    }

    public static boolean isIncludeDirectiveToken(IToken token) {
        if (token.getType() == ETokenType.PREPROCESSOR_INCLUDE) {
            return true;
        }
        return token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE && new IncludeStatementMatcher(token).match();
    }

    private static PreprocessorTokenReplacement createReplacementUntilNextPreprocessorDirective(List<IToken> fileTokens, int originalTokenIndex) {
        int indexOfNextRelevantToken = TokenStreamUtils.firstTokenMatching(fileTokens, originalTokenIndex, fileTokens.size(), INTERESTING_TOKEN_TYPES_IN_HEADERS);
        if (indexOfNextRelevantToken == -1) {
            indexOfNextRelevantToken = fileTokens.size();
        }
        return new PreprocessorTokenReplacement(Collections.emptyList(), originalTokenIndex, indexOfNextRelevantToken, new PreprocessorUsageInformation());
    }

    private PreprocessorTokenReplacement computeReplacementForToken(int originalTokenIndex, List<IToken> fileTokens, MacroInvocationPreprocessor macroPreprocessor, FilePreprocessorContext fileContext, IfDirectivePreprocessor.ConditionalRegionStack conditionalRegionStack, IncludedFilesContext includedFiles) throws PreprocessorException {
        Optional<MacroDefinition> macro;
        IToken token = fileTokens.get(originalTokenIndex);
        if (CPreprocessor.isUnknownDirectiveSituation(originalTokenIndex, fileTokens, token)) {
            int nextToken = CPreprocessor.getIndexOfNextLineToken(originalTokenIndex, fileTokens);
            return new PreprocessorTokenReplacement((List<IToken>)CollectionUtils.emptyList(), originalTokenIndex, nextToken, new PreprocessorUsageInformation());
        }
        PreprocessorTokenReplacement result = null;
        if (CPreprocessor.isPragmaDirectiveToken(token)) {
            result = PragmaDirectivePreprocessor.expandPotentialMacroInvocationsInPragmaDirective(originalTokenIndex, token, fileContext, includedFiles, this.expansionStepsLogger);
        }
        if ((macro = fileContext.findMacroDefinition(token, includedFiles)).isPresent()) {
            result = macroPreprocessor.expandTopLevelMacroInvocation(originalTokenIndex, fileTokens, macro.get(), fileContext, includedFiles);
            if (result != null) {
                result.setTokensOriginAndOffset(fileTokens.get(originalTokenIndex));
            }
        } else if (CPreprocessor.isIncludeDirectiveToken(token)) {
            PreprocessorUsageInformation preprocessorUsageInInclude = new PreprocessorUsageInformation();
            result = this.handleInclude(fileContext.uniformPath, fileTokens, includedFiles, originalTokenIndex, preprocessorUsageInInclude, fileContext, macroPreprocessor);
        } else if (token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE) {
            result = this.computeReplacementForPreprocessorDirectives(originalTokenIndex, fileTokens, fileContext, conditionalRegionStack, includedFiles, token);
        }
        return result;
    }

    private PreprocessorTokenReplacement computeReplacementForPreprocessorDirectives(int originalTokenIndex, List<IToken> fileTokens, FilePreprocessorContext fileContext, IfDirectivePreprocessor.ConditionalRegionStack conditionalRegionStack, IncludedFilesContext includedFiles, IToken token) throws PreprocessorException {
        PreprocessorTokenReplacement result = null;
        if (CPreprocessor.isErrorDirective(token) || CPreprocessor.isWarningDirective(token) || CPreprocessor.isLineDirective(token)) {
            result = CPreprocessor.handleSimpleDirective(includedFiles, originalTokenIndex, token, fileContext);
        } else if (IfDirectivePreprocessor.isConditionalDirective(token)) {
            result = IfDirectivePreprocessor.processIfDirective(fileTokens, originalTokenIndex, conditionalRegionStack, fileContext, this, includedFiles);
        } else {
            this.handleIfMacroDefinitionDirective(token);
            result = PreprocessorTokenReplacement.createSingleTokenRemoval(originalTokenIndex);
        }
        return result;
    }

    private static int getIndexOfNextLineToken(int startIndex, List<IToken> tokens) {
        int end;
        IToken startToken = tokens.get(startIndex);
        for (end = startIndex + 1; end < tokens.size() && tokens.get(end).getLineNumber() == startToken.getLineNumber(); ++end) {
        }
        return end;
    }

    private static boolean isUnknownDirectiveSituation(int originalTokenIndex, List<IToken> fileTokens, IToken token) {
        return token.getType() == ETokenType.ILLEGAL_CHARACTER && token.getText().equals("#") && (originalTokenIndex == 0 || fileTokens.get(originalTokenIndex - 1).getLineNumber() < token.getLineNumber());
    }

    private static PreprocessorTokenReplacement handleSimpleDirective(IncludedFilesContext includedFiles, int originalTokenIndex, IToken token, FilePreprocessorContext context) {
        if (!CPreprocessor.isErrorDirective(token)) {
            return PreprocessorTokenReplacement.createSingleTokenRemoval(originalTokenIndex);
        }
        String locationAndErrorMessage = token.getOriginId() + ":" + token.getLineNumber() + ": " + token.getText();
        String preprocessorMessage = "hit error directive in " + locationAndErrorMessage;
        if (context.storeNewLoggedErrorDirective(locationAndErrorMessage)) {
            CPreprocessor.logParseLogMessage(preprocessorMessage + "\n(only first hit is logged)", token, context);
        }
        PreprocessorTokenReplacement replacementFromCurrentStep = PreprocessorTokenReplacement.createSingleTokenRemovalWithError(preprocessorMessage, originalTokenIndex, new PreprocessorUsageInformation());
        return replacementFromCurrentStep;
    }

    private static boolean isErrorDirective(IToken token) {
        return ERROR_PATTERN.matcher(token.getText()).matches();
    }

    private static boolean isWarningDirective(IToken token) {
        return WARNING_PATTERN.matcher(token.getText()).matches();
    }

    private static boolean isLineDirective(IToken token) {
        return LINE_PATTERN.matcher(token.getText()).matches();
    }

    private PreprocessorTokenReplacement handleInclude(String uniformPath, List<IToken> fileTokens, IncludedFilesContext includedFiles, int originalTokenIndex, PreprocessorUsageInformation preprocessorUsageInformation, FilePreprocessorContext fileContext, MacroInvocationPreprocessor macroPreprocessor) throws PreprocessorException {
        int endOfInclude = CPreprocessor.getEndOfInclude(fileTokens, originalTokenIndex);
        if (includedFiles.getCurrentIncludeHierarchy().size() > 20) {
            return CPreprocessor.createTokensRemovalWithError("hit include level limit of 20", originalTokenIndex, endOfInclude, includedFiles, preprocessorUsageInformation);
        }
        IToken token = fileTokens.get(originalTokenIndex);
        IncludeDirective includeDirective = CPreprocessor.extractIncludeDirectiveMaybeWithPreprocessing(token, includedFiles, fileContext, macroPreprocessor).orElse(null);
        if (includeDirective == null) {
            return CPreprocessor.createTokensRemovalWithError("could not parse include directive", originalTokenIndex, endOfInclude, includedFiles, preprocessorUsageInformation);
        }
        IncludedTokens pathAndTokens = this.resolveIncludedTokens(uniformPath, includeDirective);
        if (pathAndTokens.isEmpty()) {
            preprocessorUsageInformation.addUnresolvedIncludePath(includeDirective.getIncludedFilePath());
            return CPreprocessor.createTokensRemovalWithError("unresolved include", originalTokenIndex, endOfInclude, includedFiles, preprocessorUsageInformation);
        }
        String resolvedIncludePath = pathAndTokens.includedFileUniformPath;
        List<IToken> includedTokens = pathAndTokens.includedTokens;
        if (includedFiles.isAlreadyIncludedBefore(resolvedIncludePath)) {
            if (this.disallowRepeatedIncludes) {
                return CPreprocessor.createTokensRemovalWithError("repeated include", originalTokenIndex, endOfInclude, includedFiles, preprocessorUsageInformation);
            }
            if (includedFiles.includedFilesWithPragmaOnce.contains(resolvedIncludePath)) {
                return new PreprocessorIncludeTokenReplacement(List.of(), originalTokenIndex, endOfInclude, preprocessorUsageInformation, resolvedIncludePath, false);
            }
        } else if (!this.disallowRepeatedIncludes && CPreprocessor.hasPragmaOnce(includedTokens)) {
            includedFiles.includedFilesWithPragmaOnce.add(resolvedIncludePath);
        }
        return this.preprocessIncludedTokens(pathAndTokens, fileContext.translationUnitLanguage, fileTokens.get(originalTokenIndex), includedFiles, preprocessorUsageInformation, originalTokenIndex, endOfInclude);
    }

    private static Optional<IncludeDirective> extractIncludeDirectiveMaybeWithPreprocessing(IToken token, IncludedFilesContext includedFiles, FilePreprocessorContext fileContext, MacroInvocationPreprocessor macroPreprocessor) throws PreprocessorException {
        Optional<IncludeDirective> includeDirective = IncludeDirective.createFromToken(token);
        if (!includeDirective.isPresent()) {
            IncludeStatementMatcher matcher = new IncludeStatementMatcher(token);
            if (!matcher.match()) {
                return Optional.empty();
            }
            String includedFilePath = CPreprocessor.extractIncludedName(matcher.getIncludedFileExpression().trim(), includedFiles, fileContext, macroPreprocessor).orElse(null);
            if (includedFilePath == null) {
                return Optional.empty();
            }
            includeDirective = IncludeDirective.createFromTokenWithFilePath(token, includedFilePath);
        }
        return includeDirective;
    }

    private static int getEndOfInclude(List<IToken> tokens, int startIndex) {
        int line = tokens.get(startIndex).getLineNumber();
        for (int i = startIndex + 1; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            if (token.getLineNumber() != line) {
                return i;
            }
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.LITERAL || IMPORT_MODIFIER_TOKENS.contains(token.getType())) continue;
            return i;
        }
        return tokens.size();
    }

    private static @NonNull PreprocessorTokenReplacement createTokensRemovalWithError(String errorMessage, int originalTokenIndex, int endTokenIndex, IncludedFilesContext includedFiles, PreprocessorUsageInformation preprocessorUsageInformation) {
        return PreprocessorTokenReplacement.createTokensRemovalWithError(errorMessage, includedFiles.getCurrentIncludeHierarchy(), originalTokenIndex, endTokenIndex, preprocessorUsageInformation);
    }

    private static boolean hasPragmaOnce(List<IToken> tokens) {
        for (IToken token : tokens) {
            if (token.getType() != ETokenType.PRAGMA_DIRECTIVE) continue;
            String tokenText = token.getText();
            tokenText = tokenText.substring("#pragma ".length());
            if (!(tokenText = tokenText.trim()).equals("once")) continue;
            return true;
        }
        return false;
    }

    private static Optional<String> extractIncludedName(String includeDirectiveNamePart, IncludedFilesContext includedFiles, FilePreprocessorContext fileContext, MacroInvocationPreprocessor macroPreprocessor) throws PreprocessorException {
        List<IToken> includedNameTokens = CPreprocessingUtils.scanMacroContent(includeDirectiveNamePart, ELanguage.CPP);
        if (includedNameTokens.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> result = CPreprocessor.extractIncludedNameWithoutMacroExpansion(includedNameTokens);
        if (result.isPresent()) {
            return result;
        }
        List expandedTokens = (List)macroPreprocessor.expandMacrosInTokenList(includedNameTokens, Collections.emptyList(), fileContext, new MacroInvocationPreprocessor.TokenDisablingContext(), new PreprocessorUsageInformation(), includedFiles).getFirst();
        expandedTokens.removeIf(MacroInvocationPreprocessor::isBlockerToken);
        result = CPreprocessor.extractIncludedNameWithoutMacroExpansion(expandedTokens);
        return result.map(s -> s.replace(" ", ""));
    }

    public static Optional<String> extractIncludedNameWithoutMacroExpansion(List<IToken> includedNameTokens) {
        if (includedNameTokens.isEmpty()) {
            return Optional.empty();
        }
        IToken firstToken = (IToken)(includedNameTokens = CollectionUtils.filter(includedNameTokens, token -> token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT)).get(0);
        if (firstToken.getType() == ETokenType.STRING_LITERAL && firstToken.getText().length() > 2) {
            return Optional.of(firstToken.getText().substring(1, firstToken.getText().length() - 1));
        }
        if (includedNameTokens.size() > 2 && TokenStreamUtils.startsWith(includedNameTokens, ETokenType.LT) && TokenStreamUtils.endsWith(includedNameTokens, ETokenType.GT)) {
            return Optional.of(TokenStreamTextUtils.concatTokenTexts(includedNameTokens.subList(1, includedNameTokens.size() - 1)));
        }
        return Optional.empty();
    }

    private PreprocessorTokenReplacement preprocessIncludedTokens(IncludedTokens includedTokens, ELanguage compilationUnitLanguage, IToken includeDirectiveToken, IncludedFilesContext includedFiles, PreprocessorUsageInformation preprocessorUsageInformation, int originalTokenIndex, int endOfInclude) {
        String resolvedIncludePath = includedTokens.includedFileUniformPath;
        preprocessorUsageInformation.addIncludedPath(resolvedIncludePath);
        includedFiles.pushIncludedPath(resolvedIncludePath);
        List<PreprocessorTokenReplacement> replacements = this.computeTopLevelReplacements(resolvedIncludePath, compilationUnitLanguage, includedTokens.includedTokens, includedFiles);
        includedFiles.popIncludedPath();
        List<IToken> resultTokens = CPreprocessingUtils.applyReplacements(replacements, includedTokens.includedTokens);
        for (int i = 0; i < resultTokens.size(); ++i) {
            IToken resultToken = resultTokens.get(i);
            resultTokens.set(i, resultToken.newToken(resultToken.getType(), includeDirectiveToken.getOffset(), includeDirectiveToken.getLineNumber(), resultToken.getText(), "##macro##"));
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (PreprocessorTokenReplacement replacement : replacements) {
            preprocessorUsageInformation.addFrom(replacement.preprocessorUsageInformation);
            if (replacement.errorMessage == null) continue;
            errors.add(replacement.errorMessage);
        }
        if (!errors.isEmpty()) {
            return new PreprocessorIncludeTokenReplacement(resultTokens, originalTokenIndex, endOfInclude, preprocessorUsageInformation, StringUtils.concat(errors, (String)"\n"), resolvedIncludePath, includedTokens.includedFileIsVisible);
        }
        return new PreprocessorIncludeTokenReplacement(resultTokens, originalTokenIndex, endOfInclude, preprocessorUsageInformation, resolvedIncludePath, includedTokens.includedFileIsVisible);
    }

    public static boolean isPragmaDirectiveToken(IToken token) {
        return token.getType() == ETokenType.PRAGMA_DIRECTIVE;
    }

    private void handleIfMacroDefinitionDirective(IToken token) {
        String macroText = CPreprocessor.stripHashAndBackslash(token.getText());
        if (CPreprocessor.handleIfMacroDefinitionDirective(macroText, "define", s -> this.macroProvider.define((String)s, CPreprocessingUtils.locationFromToken(token), token.getLanguage(), false))) {
            return;
        }
        if (CPreprocessor.handleIfMacroDefinitionDirective(macroText, "undef", this.macroProvider::undefine)) {
            return;
        }
        CPreprocessor.handleIfMacroDefinitionDirective(macroText, "immutable_define", s -> this.macroProvider.define((String)s, CPreprocessingUtils.locationFromToken(token), token.getLanguage(), true));
    }

    private static @NonNull String stripHashAndBackslash(String tokenText) {
        String macro = tokenText.trim();
        if (macro.startsWith("#")) {
            macro = macro.substring(1).trim();
        }
        if (macro.endsWith("\\")) {
            macro = macro.substring(0, macro.length() - 1).trim();
        }
        return macro;
    }

    private static boolean handleIfMacroDefinitionDirective(String content, String command, Consumer<String> definer) {
        if (!content.startsWith(command) || content.length() <= command.length()) {
            return false;
        }
        definer.accept(content.substring(command.length()).trim());
        return true;
    }

    public ParsedMacroProvider getCurrentDefines() {
        return this.macroProvider;
    }

    protected Optional<String> resolveInclude(String includingUniformPath, IncludeDirective includeDirective) {
        return Optional.empty();
    }

    protected IncludedTokens resolveIncludedTokens(String includingUniformPath, IncludeDirective includeDirective) {
        return IncludedTokens.empty();
    }

    static void logParseLogMessage(String message, IToken token, FilePreprocessorContext fileContext) {
        LOGGER.info(ShallowParsingUtils.PARSE_LOG_ENTRY_MARKER, (Message)new ParseLogMessage(PREPROCESSOR_PARSE_LOG_ORIGIN_STEP, message, fileContext.uniformPath, token.getLineNumber() + 1));
    }

    static class IncludedFilesContext {
        private final Set<String> allIncludedPaths = new HashSet<String>();
        private final Deque<String> includeHierarchy = new ArrayDeque<String>();
        private final Set<String> includedFilesWithPragmaOnce = new HashSet<String>();

        @VisibleForTesting
        IncludedFilesContext(String sourceFileUniformPath) {
            this.pushIncludedPath(sourceFileUniformPath);
        }

        private void pushIncludedPath(String uniformPath) {
            this.allIncludedPaths.add(uniformPath);
            this.includeHierarchy.push(uniformPath);
        }

        private void popIncludedPath() {
            this.includeHierarchy.pop();
        }

        private boolean isAlreadyIncludedBefore(String uniformPath) {
            return this.allIncludedPaths.contains(uniformPath);
        }

        public UnmodifiableList<String> getCurrentIncludeHierarchy() {
            return CollectionUtils.asUnmodifiable(new ArrayList<String>(this.includeHierarchy));
        }
    }

    static class FilePreprocessorContext {
        private final ParsedMacroProvider macroProvider;
        final String uniformPath;
        int lineNumber;
        private final HashSet<String> loggedErrorDirectiveHits = new HashSet();
        public final ELanguage translationUnitLanguage;

        @VisibleForTesting
        FilePreprocessorContext(ParsedMacroProvider macroProvider, String uniformPath, int lineNumber, ELanguage translationUnitLanguage) {
            CCSMAssert.isNotNull((Object)uniformPath);
            this.macroProvider = macroProvider;
            this.uniformPath = uniformPath;
            this.lineNumber = lineNumber;
            this.translationUnitLanguage = translationUnitLanguage;
        }

        private boolean storeNewLoggedErrorDirective(String locationAndErrorMessage) {
            return this.loggedErrorDirectiveHits.add(locationAndErrorMessage);
        }

        void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        Optional<MacroDefinition> findMacroDefinition(IToken currentToken, IncludedFilesContext includedFiles) {
            String currentMacroName = currentToken.getText();
            Optional<MacroDefinition> macro = Optional.ofNullable(this.macroProvider.getDefinition(currentMacroName));
            if (macro.isPresent() || this.macroProvider.isExplicitlyUndefined(currentMacroName)) {
                return macro;
            }
            macro = CompilerDefinedMacroSupplier.getMacroForName(currentMacroName, includedFiles, this);
            if (macro.isPresent()) {
                return macro;
            }
            return CBoundsSafetyExtensionMacroSupplier.getMacroForName(currentMacroName);
        }
    }

    static class PreprocessorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PreprocessorException(String message) {
            super(message);
        }
    }

    public static class PreprocessorUsageInformation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Set<MacroDefinition> contentDependencyMacros = null;
        private Set<MacroDefinition> definitionDependencyMacros = null;
        private Set<String> includedUniformPaths = null;
        private Set<String> unresolvedIncludePaths = null;

        private void initializeIfNecessary() {
            if (this.contentDependencyMacros == null || this.definitionDependencyMacros == null || this.includedUniformPaths == null || this.unresolvedIncludePaths == null) {
                this.contentDependencyMacros = new HashSet<MacroDefinition>();
                this.definitionDependencyMacros = new HashSet<MacroDefinition>();
                this.includedUniformPaths = new HashSet<String>();
                this.unresolvedIncludePaths = new HashSet<String>();
            }
        }

        void addMacroContentDependencyOn(MacroDefinition macro) {
            this.initializeIfNecessary();
            this.contentDependencyMacros.add(macro);
        }

        void addMacroDefinitionDependencyOn(MacroDefinition macro) {
            this.initializeIfNecessary();
            this.definitionDependencyMacros.add(macro);
        }

        public Set<MacroDefinition> getDefinitionDependencyMacros() {
            if (this.definitionDependencyMacros == null) {
                return Collections.emptySet();
            }
            return this.definitionDependencyMacros;
        }

        public Set<MacroDefinition> getContentDependencyMacros() {
            if (this.contentDependencyMacros == null) {
                return Collections.emptySet();
            }
            return this.contentDependencyMacros;
        }

        public Set<String> getIncludedUniformPaths() {
            if (this.includedUniformPaths == null) {
                return Collections.emptySet();
            }
            return this.includedUniformPaths;
        }

        private void addIncludedPath(String uniformPath) {
            this.initializeIfNecessary();
            this.includedUniformPaths.add(uniformPath);
        }

        public void addFrom(PreprocessorUsageInformation preprocessorUsageInformation) {
            this.initializeIfNecessary();
            this.contentDependencyMacros.addAll(preprocessorUsageInformation.getContentDependencyMacros());
            this.definitionDependencyMacros.addAll(preprocessorUsageInformation.getDefinitionDependencyMacros());
            this.addIncludeInfoFrom(preprocessorUsageInformation);
        }

        public void addIncludeInfoFrom(PreprocessorUsageInformation preprocessorUsageInformation) {
            this.initializeIfNecessary();
            this.includedUniformPaths.addAll(preprocessorUsageInformation.getIncludedUniformPaths());
            this.unresolvedIncludePaths.addAll(preprocessorUsageInformation.getUnresolvedIncludePaths());
        }

        private void addUnresolvedIncludePath(String includedName) {
            this.initializeIfNecessary();
            this.unresolvedIncludePaths.add(includedName);
        }

        public Set<String> getUnresolvedIncludePaths() {
            if (this.unresolvedIncludePaths == null) {
                return Collections.emptySet();
            }
            return this.unresolvedIncludePaths;
        }
    }
}

