/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.IfDirectivePreprocessor;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.preprocessor.c.MacroExpansionStepsLogger;
import eu.cqse.check.framework.preprocessor.c.NonStandardSemanticsMacroInvocationProcessor;
import eu.cqse.check.framework.preprocessor.c.PreprocessorMacroExpansionTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class MacroInvocationPreprocessor {
    private final MacroExpansionStepsLogger expansionStepsLogger;
    private static final Logger LOGGER = LogManager.getLogger();

    public MacroInvocationPreprocessor(MacroExpansionStepsLogger expansionStepsLogger) {
        this.expansionStepsLogger = expansionStepsLogger;
    }

    PreprocessorTokenReplacement expandTopLevelMacroInvocation(int tokenIndex, List<IToken> fileTokens, MacroDefinition definition, CPreprocessor.FilePreprocessorContext fileContext, CPreprocessor.IncludedFilesContext includedFiles) throws CPreprocessor.PreprocessorException {
        ArrayList<IToken> macroCallTokens = MacroInvocationPreprocessor.determineMacroCallTokens(tokenIndex, fileTokens, definition.isFunctionMacro, Collections.emptyList());
        if (!macroCallTokens.isEmpty()) {
            fileContext.setLineNumber(((IToken)CollectionUtils.getLast(macroCallTokens)).getLineNumber());
        }
        return this.expandMacro(tokenIndex, fileTokens, Collections.emptyList(), definition, fileContext, new TokenDisablingContext(), includedFiles);
    }

    private PreprocessorTokenReplacement expandMacro(int tokenIndex, List<IToken> tokens, List<IToken> successorTokens, MacroDefinition currentMacro, CPreprocessor.FilePreprocessorContext context, TokenDisablingContext tokenDisablingContext, CPreprocessor.IncludedFilesContext includedFiles) throws CPreprocessor.PreprocessorException {
        CCSMAssert.isTrue((boolean)currentMacro.macroName.equals(tokens.get(tokenIndex).getText()), () -> "macro name " + currentMacro.macroName + " must match current token " + ((IToken)tokens.get(tokenIndex)).getText());
        ArrayList<IToken> macroCallTokens = MacroInvocationPreprocessor.determineMacroCallTokens(tokenIndex, tokens, currentMacro.isFunctionMacro, successorTokens);
        if (currentMacro.isFunctionMacro && macroCallTokens.size() == 1) {
            return null;
        }
        int numUsedSuccessorTokens = 0;
        if (tokens.size() > tokenIndex + macroCallTokens.size()) {
            successorTokens = CPreprocessingUtils.concat(tokens.subList(tokenIndex + macroCallTokens.size(), tokens.size()), successorTokens);
        } else {
            numUsedSuccessorTokens = macroCallTokens.size() - (tokens.size() - tokenIndex);
        }
        CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation = new CPreprocessor.PreprocessorUsageInformation();
        preprocessorUsageInformation.addMacroContentDependencyOn(currentMacro);
        List<IToken> remainingSuccessorTokens = successorTokens.subList(numUsedSuccessorTokens, successorTokens.size());
        this.expansionStepsLogger.logStatusMessage(macroCallTokens, remainingSuccessorTokens, "[begin] macro invocation", tokenDisablingContext);
        this.expansionStepsLogger.logStatusMessage(Collections.emptyList(), () -> "Disabling Context: " + StringUtils.concat(tokenDisablingContext.expandingMacroNameStack, (String)", "), tokenDisablingContext);
        if (macroCallTokens.isEmpty()) {
            return null;
        }
        this.expansionStepsLogger.logStatusMessage("macro definition", currentMacro::toString);
        PairList<String, List<IToken>> originalArguments = MacroInvocationPreprocessor.extractArgumentsFromCall(currentMacro, macroCallTokens);
        PairList<String, List<IToken>> expandedArguments = this.expandArguments(currentMacro, context, tokenDisablingContext, includedFiles, preprocessorUsageInformation, originalArguments);
        List<IToken> macroExpansion = new ArrayList<IToken>(currentMacro.replacementList);
        MacroInvocationPreprocessor.stringifyParametersInPlace(macroExpansion, originalArguments);
        this.expansionStepsLogger.logStatusMessage(macroExpansion, "1. after stringification", tokenDisablingContext);
        macroExpansion = MacroInvocationPreprocessor.replaceParameterNamesWithArguments(macroExpansion, originalArguments, expandedArguments, currentMacro);
        this.expansionStepsLogger.logStatusMessage(macroExpansion, "2. after parameter insertion", tokenDisablingContext);
        MacroInvocationPreprocessor.concatenateTokensInPlace(macroExpansion);
        macroExpansion.removeIf(MacroInvocationPreprocessor::isEmptyMacroArgumentToken);
        this.expansionStepsLogger.logStatusMessage(macroExpansion, "3. after concatenation", tokenDisablingContext);
        macroExpansion = MacroInvocationPreprocessor.evaluateSpecialMacros(macroExpansion, expandedArguments, currentMacro, context);
        tokenDisablingContext.pushDisabledMacroName(currentMacro.macroName);
        Pair<List<IToken>, Integer> result = this.expandMacrosInTokenList(macroExpansion, remainingSuccessorTokens, context, tokenDisablingContext, preprocessorUsageInformation, includedFiles);
        if (currentMacro.macroName.equals(tokenDisablingContext.expandingMacroNameStack.peek())) {
            tokenDisablingContext.popDisabledMacroName();
        }
        ((List)result.getFirst()).removeIf(MacroInvocationPreprocessor::isBlockerToken);
        this.expansionStepsLogger.logStatusMessage((List<IToken>)((List)result.getFirst()), "4. after rescan ", tokenDisablingContext);
        return new PreprocessorMacroExpansionTokenReplacement((List<IToken>)((List)result.getFirst()), tokenIndex, tokenIndex + macroCallTokens.size() + (Integer)result.getSecond(), preprocessorUsageInformation, currentMacro.macroDeclarationLocation);
    }

    private static List<IToken> evaluateSpecialMacros(List<IToken> macroExpansion, PairList<String, List<IToken>> expandedArguments, MacroDefinition currentMacro, CPreprocessor.FilePreprocessorContext context) {
        if (NonStandardSemanticsMacroInvocationProcessor.isNonStandardSemanticsMacro(currentMacro)) {
            return NonStandardSemanticsMacroInvocationProcessor.evaluateNonStandardSemanticsMacro(macroExpansion, expandedArguments, currentMacro, context);
        }
        return macroExpansion;
    }

    private PairList<String, List<IToken>> expandArguments(MacroDefinition currentMacro, CPreprocessor.FilePreprocessorContext context, TokenDisablingContext tokenDisablingContext, CPreprocessor.IncludedFilesContext includedFiles, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, PairList<String, List<IToken>> arguments) throws CPreprocessor.PreprocessorException {
        PairList expandedParameterValues = new PairList(arguments.size());
        for (String parameterName : currentMacro.getParametersThatRequireExpansion()) {
            List argument = (List)arguments.getSecond(((Integer)arguments.indexOfFirst((Object)parameterName).get()).intValue());
            this.expansionStepsLogger.incrementNestingDepth();
            List expandedParameter = (List)this.expandMacrosInTokenList(argument, Collections.emptyList(), context, tokenDisablingContext, preprocessorUsageInformation, includedFiles).getFirst();
            expandedParameter.removeIf(MacroInvocationPreprocessor::isBlockerToken);
            expandedParameterValues.add((Object)parameterName, (Object)expandedParameter);
            this.expansionStepsLogger.decrementNestingDepth();
        }
        return expandedParameterValues;
    }

    public Pair<List<IToken>, Integer> expandMacrosInTokenList(List<IToken> tokens, List<IToken> successorTokens, CPreprocessor.FilePreprocessorContext context, TokenDisablingContext tokenDisablingContext, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, CPreprocessor.IncludedFilesContext includedFiles) throws CPreprocessor.PreprocessorException {
        if (tokens.isEmpty()) {
            return Pair.createPair(Collections.emptyList(), (Object)0);
        }
        ArrayList<IToken> result = new ArrayList<IToken>();
        int numUsedSuccessorTokens = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            IToken currentToken = tokens.get(i);
            if (CPreprocessor.isPragmaDirectiveToken(currentToken)) {
                result.add(currentToken);
                continue;
            }
            PreprocessorTokenReplacement replacement = this.computeReplacementForCurrentToken(tokens, i, successorTokens, context, tokenDisablingContext, includedFiles);
            if (replacement == null || replacement.countReplacedTokens() == 0) {
                result.add(tokens.get(i));
                continue;
            }
            if (replacement.getReplacementTokens().isEmpty()) {
                result.add(MacroInvocationPreprocessor.generateBlockerToken(tokens.get(0)));
            }
            preprocessorUsageInformation.addFrom(replacement.preprocessorUsageInformation);
            numUsedSuccessorTokens = Math.max(replacement.countReplacedTokens() - (tokens.size() - i), 0);
            result.addAll(replacement.replacementTokens);
            i += replacement.countReplacedTokens() - 1;
        }
        return Pair.createPair(result, (Object)numUsedSuccessorTokens);
    }

    private static IToken generateEmptyMacroArgumentToken(IToken inputToken) {
        return inputToken.newToken(ETokenType.G, inputToken.getOffset(), inputToken.getLineNumber(), "", "MacroInternal");
    }

    private static boolean isEmptyMacroArgumentToken(IToken token) {
        return token.getType() == ETokenType.G;
    }

    private static IToken generateBlockerToken(IToken inputToken) {
        return inputToken.newToken(ETokenType.M, inputToken.getOffset(), inputToken.getLineNumber(), "*!*", "MacroInternal");
    }

    static boolean isBlockerToken(IToken token) {
        return token.getType() == ETokenType.M;
    }

    private PreprocessorTokenReplacement computeReplacementForCurrentToken(List<IToken> tokens, int currentIndex, List<IToken> successorTokens, CPreprocessor.FilePreprocessorContext context, TokenDisablingContext tokenDisablingContext, CPreprocessor.IncludedFilesContext includedFiles) throws CPreprocessor.PreprocessorException {
        IToken currentToken = tokens.get(currentIndex);
        Optional<MacroDefinition> macro = context.findMacroDefinition(currentToken, includedFiles);
        if (!macro.isPresent()) {
            return null;
        }
        if (tokenDisablingContext.isPaintedBlue(currentToken)) {
            return null;
        }
        if (tokenDisablingContext.isInCurrentStack(currentToken)) {
            IToken newToken = currentToken.newToken(currentToken.getType(), currentToken.getOffset(), currentToken.getLineNumber(), currentToken.getText(), currentToken.getOriginId());
            this.expansionStepsLogger.logStatusMessage(tokens, "Painting blue: " + newToken.getText(), tokenDisablingContext);
            tokenDisablingContext.paintBlue(newToken);
            return new PreprocessorTokenReplacement(Collections.singletonList(newToken), currentIndex, currentIndex + 1, new CPreprocessor.PreprocessorUsageInformation());
        }
        if (macro.get().isFunctionMacro && currentIndex == tokens.size() - 1) {
            if (!TokenStreamUtils.startsWith(successorTokens, ETokenType.LPAREN)) {
                return null;
            }
            tokenDisablingContext.expandingMacroNameStack.clear();
        }
        this.expansionStepsLogger.incrementNestingDepth();
        PreprocessorTokenReplacement replacement = this.expandMacro(currentIndex, tokens, successorTokens, macro.get(), context, tokenDisablingContext, includedFiles);
        this.expansionStepsLogger.decrementNestingDepth();
        return replacement;
    }

    private static void concatenateTokensInPlace(List<IToken> macroContent) {
        for (int i = 0; i < macroContent.size(); ++i) {
            if (i + 1 >= macroContent.size() || macroContent.get(i + 1).getType() != ETokenType.CONCATENATION) continue;
            IToken current = macroContent.get(i);
            if (MacroInvocationPreprocessor.hasTypeAndText(macroContent.get(i), ETokenType.ILLEGAL_CHARACTER, "#") && i + 2 < macroContent.size() && MacroInvocationPreprocessor.hasTypeAndText(macroContent.get(i + 2), ETokenType.ILLEGAL_CHARACTER, "#")) {
                macroContent.remove(i + 2);
                macroContent.remove(i + 1);
                macroContent.set(i, current.newToken(ETokenType.IDENTIFIER, current.getOffset(), current.getLineNumber(), "##", current.getOriginId()));
                continue;
            }
            if (MacroInvocationPreprocessor.canConcatenateToken(macroContent.get(i)) && i + 2 < macroContent.size()) {
                if (macroContent.get(i + 2).getType() == ETokenType.CONCATENATION) {
                    macroContent.remove(i + 1);
                    --i;
                    continue;
                }
                String concatenatedTokenText = macroContent.get(i).getText() + macroContent.get(i + 2).getText();
                macroContent.remove(i + 2);
                macroContent.remove(i + 1);
                List<IToken> scanned = CPreprocessingUtils.scanMacroContent(concatenatedTokenText, macroContent.get(i).getLanguage());
                if (scanned.size() > 1 || scanned.get(0).getType() == ETokenType.CONCATENATION) {
                    macroContent.set(i, current.newToken(ETokenType.IDENTIFIER, current.getOffset(), current.getLineNumber(), concatenatedTokenText, current.getOriginId()));
                } else {
                    macroContent.set(i, scanned.get(0));
                }
                --i;
                continue;
            }
            macroContent.remove(i + 1);
        }
        macroContent.removeIf(token -> token.getType() == ETokenType.CONCATENATION);
    }

    private static boolean canConcatenateToken(IToken concatenationStartToken) {
        return concatenationStartToken.getType() == ETokenType.IDENTIFIER || concatenationStartToken.getType() == ETokenType.INTEGER_LITERAL;
    }

    private static boolean hasTypeAndText(List<IToken> tokens, int index, ETokenType type, String text) {
        if (index < tokens.size()) {
            IToken token = tokens.get(index);
            return token.getType() == type && token.getText().equals(text);
        }
        return false;
    }

    private static boolean hasTypeAndText(IToken token, ETokenType type, String text) {
        return token.getType() == type && token.getText().equals(text);
    }

    private static List<IToken> replaceParameterNamesWithArguments(List<IToken> macroContent, PairList<String, List<IToken>> originalArguments, PairList<String, List<IToken>> expandedArguments, MacroDefinition currentMacro) {
        Map originalArgumentsMap = originalArguments.toMap();
        Map expandedArgumentsMap = expandedArguments.toMap();
        List<Object> result = new ArrayList<IToken>();
        for (int i = 0; i < macroContent.size(); ++i) {
            IToken currentToken = macroContent.get(i);
            if (!expandedArgumentsMap.containsKey(currentToken.getText())) {
                result.add(currentToken);
                continue;
            }
            if (currentMacro.hasVariadicParameter && MacroInvocationPreprocessor.previousTokenIs(i, macroContent, ETokenType.CONCATENATION) && MacroInvocationPreprocessor.previousTokenIs(i - 1, macroContent, ETokenType.COMMA) && ((String)CollectionUtils.getLast(currentMacro.parameterNames)).equals(currentToken.getText()) && ((List)expandedArgumentsMap.get(currentToken.getText())).isEmpty()) {
                result = result.subList(0, result.size() - 2);
                continue;
            }
            if (MacroInvocationPreprocessor.nextTokenTypeIsConcatenation(i, macroContent) || MacroInvocationPreprocessor.previousTokenIs(i, macroContent, ETokenType.CONCATENATION)) {
                List argument = (List)originalArgumentsMap.get(currentToken.getText());
                if (argument.isEmpty()) {
                    result.add(MacroInvocationPreprocessor.generateEmptyMacroArgumentToken(currentToken));
                    continue;
                }
                result.addAll(argument);
                continue;
            }
            result.addAll((Collection)expandedArgumentsMap.get(currentToken.getText()));
        }
        return result;
    }

    private static boolean previousTokenIs(int currentIndex, List<IToken> tokens, ETokenType type) {
        return currentIndex > 0 && tokens.get(currentIndex - 1).getType() == type;
    }

    private static boolean nextTokenTypeIsConcatenation(int currentIndex, List<IToken> tokens) {
        return currentIndex + 1 < tokens.size() && tokens.get(currentIndex + 1).getType() == ETokenType.CONCATENATION;
    }

    private static void stringifyParametersInPlace(List<IToken> macroContent, PairList<String, List<IToken>> parameters) {
        UnmodifiableList parameterNames = parameters.getFirstList();
        for (int i = 0; i < macroContent.size(); ++i) {
            String parameterName;
            Optional argumentIndex;
            IToken currentToken = macroContent.get(i);
            if (!MacroDefinition.isStringificationToken(currentToken, (List<String>)parameterNames) || !(argumentIndex = parameters.indexOfFirst((Object)(parameterName = StringUtils.stripPrefix((String)currentToken.getText(), (String)"#").trim()))).isPresent()) continue;
            List argumentTokens = (List)parameters.getSecond(((Integer)argumentIndex.get()).intValue());
            if (argumentTokens.isEmpty()) {
                macroContent.set(i, CPreprocessingUtils.scanMacroContent("\"\"", currentToken.getLanguage()).get(0));
                break;
            }
            String stringifiedArgument = "\"" + MacroInvocationPreprocessor.stringifyArgumentTokens(argumentTokens) + "\"";
            macroContent.set(i, CPreprocessingUtils.scanMacroContent(stringifiedArgument, currentToken.getLanguage()).get(0));
        }
    }

    private static String stringifyArgumentTokens(List<IToken> argumentTokens) {
        ArrayList<String> stringifiedParts = new ArrayList<String>();
        for (int j = 0; j < argumentTokens.size(); ++j) {
            IToken token = argumentTokens.get(j);
            if (CPreprocessor.isPragmaDirectiveToken(token)) continue;
            if (MacroInvocationPreprocessor.hasTypeAndText(token, ETokenType.ILLEGAL_CHARACTER, "\\")) {
                if (MacroInvocationPreprocessor.hasTypeAndText(argumentTokens, j + 1, ETokenType.ILLEGAL_CHARACTER, "\\")) {
                    stringifiedParts.add("\\\\");
                    ++j;
                    continue;
                }
                if (!MacroInvocationPreprocessor.hasTypeAndText(argumentTokens, j + 1, ETokenType.IDENTIFIER, "n")) continue;
                stringifiedParts.add("\\n");
                ++j;
                continue;
            }
            if (token.getType().isLiteral()) {
                stringifiedParts.add(StringUtils.escapeChars((String)token.getText(), (Map)CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"\\", (Object)"\\\\"), Pair.createPair((Object)"\"", (Object)"\\\"")})));
                continue;
            }
            stringifiedParts.add(token.getText());
        }
        return StringUtils.concat(stringifiedParts, (String)" ");
    }

    private static PairList<String, List<IToken>> extractArgumentsFromCall(MacroDefinition macro, List<IToken> macroCallTokens) throws CPreprocessor.PreprocessorException {
        List<IToken> argumentList = TokenStreamUtils.tokensBetweenWithNesting(macroCallTokens, ETokenType.LPAREN, ETokenType.RPAREN);
        List<List<IToken>> arguments = MacroInvocationPreprocessor.splitArgumentList(argumentList, macro);
        PairList mappedArguments = new PairList();
        if (!macro.hasVariadicParameter && arguments.size() > macro.parameterNames.size()) {
            throw new CPreprocessor.PreprocessorException("macro \"" + macro.macroName + "\" passed " + arguments.size() + " arguments, but takes just " + macro.parameterNames.size());
        }
        for (int i = 0; i < macro.parameterNames.size(); ++i) {
            List<IToken> argument;
            String parameterName = (String)macro.parameterNames.get(i);
            if (macro.hasVariadicParameter && i == macro.parameterNames.size() - 1) {
                if (i < arguments.size()) {
                    argument = arguments.get(i);
                    mappedArguments.add((Object)parameterName, argument);
                    continue;
                }
                mappedArguments.add((Object)parameterName, Collections.emptyList());
                continue;
            }
            if (i < arguments.size()) {
                argument = arguments.get(i);
                mappedArguments.add((Object)parameterName, argument);
                continue;
            }
            throw new CPreprocessor.PreprocessorException("macro \"" + macro.macroName + "\" requires " + macro.parameterNames.size() + " arguments, but only " + arguments.size() + " given");
        }
        return mappedArguments;
    }

    private static List<List<IToken>> splitArgumentList(List<IToken> argumentList, MacroDefinition macro) {
        List<List<Object>> arguments = Collections.emptyList();
        if (!macro.parameterNames.isEmpty()) {
            arguments = macro.hasVariadicParameter ? TokenStreamUtils.splitWithNesting(argumentList, EnumSet.of(ETokenType.COMMA), Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN), macro.parameterNames.size()) : TokenStreamUtils.splitWithNesting(argumentList, ETokenType.COMMA, ETokenType.LPAREN, ETokenType.RPAREN);
        }
        if (arguments.isEmpty() && !macro.parameterNames.isEmpty()) {
            arguments = Collections.singletonList(Collections.emptyList());
        }
        return arguments;
    }

    private static ArrayList<IToken> determineMacroCallTokens(int originalTokenIndex, List<IToken> fileTokens, boolean isFunctionMacro, List<IToken> successorTokens) {
        if (!isFunctionMacro) {
            return new ArrayList<IToken>(Collections.singletonList(fileTokens.get(originalTokenIndex)));
        }
        ArrayList<IToken> functionCallTokens = MacroInvocationPreprocessor.determineFunctionMacroCallTokens(originalTokenIndex, fileTokens);
        if ((functionCallTokens.isEmpty() || functionCallTokens.size() == 1) && !successorTokens.isEmpty()) {
            ArrayList<IToken> tokensWithSuccessors = new ArrayList<IToken>();
            tokensWithSuccessors.addAll(fileTokens);
            tokensWithSuccessors.addAll(successorTokens);
            functionCallTokens = MacroInvocationPreprocessor.determineFunctionMacroCallTokens(originalTokenIndex, tokensWithSuccessors);
            if (functionCallTokens.isEmpty()) {
                return new ArrayList<IToken>(Collections.singletonList(fileTokens.get(originalTokenIndex)));
            }
        }
        if (functionCallTokens.stream().anyMatch(IfDirectivePreprocessor::isIfDirective)) {
            LOGGER.warn("Found #if directive in macro arguments. We don't implement this GCC extension.");
            return new ArrayList<IToken>(Collections.singletonList(fileTokens.get(originalTokenIndex)));
        }
        return functionCallTokens;
    }

    private static ArrayList<IToken> determineFunctionMacroCallTokens(int tokenIndex, List<IToken> fileTokens) {
        if (fileTokens.size() < tokenIndex + 1 || !TokenStreamUtils.hasTokenTypeSequence(fileTokens, tokenIndex + 1, ETokenType.LPAREN)) {
            return new ArrayList<IToken>(Collections.singletonList(fileTokens.get(tokenIndex)));
        }
        int endIndex = TokenStreamUtils.findMatchingClosingToken(fileTokens, tokenIndex + 2, ETokenType.LPAREN, ETokenType.RPAREN);
        if (endIndex == -1) {
            return new ArrayList<IToken>();
        }
        return new ArrayList<IToken>(fileTokens.subList(tokenIndex, endIndex + 1));
    }

    static class TokenDisablingContext {
        private final ArrayDeque<String> expandingMacroNameStack = new ArrayDeque();
        private final IdentityHashSet<IToken> bluePaintedTokens = new IdentityHashSet();

        TokenDisablingContext() {
        }

        private void pushDisabledMacroName(String currentMacroName) {
            this.expandingMacroNameStack.push(currentMacroName);
        }

        private boolean isInCurrentStack(IToken iToken) {
            return this.expandingMacroNameStack.contains(iToken.getText());
        }

        private void popDisabledMacroName() {
            this.expandingMacroNameStack.pop();
        }

        public boolean isPaintedBlue(IToken token) {
            return this.bluePaintedTokens.contains((Object)token);
        }

        private void paintBlue(IToken token) {
            this.bluePaintedTokens.add((Object)token);
        }

        public String toString() {
            return "(" + StringUtils.concat(this.expandingMacroNameStack, (String)", ") + ") (" + this.bluePaintedTokens.stream().map(token -> token.getText() + "\u00b0").collect(Collectors.joining(", ")) + ")";
        }
    }
}

