/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.MacroExpansionStepsLogger;
import eu.cqse.check.framework.preprocessor.c.MacroInvocationPreprocessor;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.Pair;

public class PragmaDirectivePreprocessor {
    private static final Pattern PRAGMA_DIRECTIVE_PREFIX = Pattern.compile("^#\\s*pragma[\\s\\\\]");

    static PreprocessorTokenReplacement expandPotentialMacroInvocationsInPragmaDirective(int originalPragmaTokenIndex, IToken originalPragmaToken, CPreprocessor.FilePreprocessorContext fileContext, CPreprocessor.IncludedFilesContext includedFiles, MacroExpansionStepsLogger expansionStepsLogger) {
        Pair<String, String> pragmaParts = PragmaDirectivePreprocessor.splitPragma(originalPragmaToken.getText());
        if (pragmaParts == null) {
            CPreprocessor.logParseLogMessage("Found malformed pragma directive. Continuing without expansion of this pragma.", originalPragmaToken, fileContext);
            return null;
        }
        List<IToken> pragmaArgument = ScannerUtils.getTokens((String)pragmaParts.getSecond(), originalPragmaToken.getLanguage(), originalPragmaToken.getOriginId());
        CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation = new CPreprocessor.PreprocessorUsageInformation();
        try {
            List expandedTokens = (List)new MacroInvocationPreprocessor(expansionStepsLogger).expandMacrosInTokenList(pragmaArgument, Collections.emptyList(), fileContext, new MacroInvocationPreprocessor.TokenDisablingContext(), preprocessorUsageInformation, includedFiles).getFirst();
            if (expandedTokens.equals(pragmaArgument)) {
                return null;
            }
            String newPragmaTokenText = (String)pragmaParts.getFirst() + TokenStreamTextUtils.concatTokenTexts(expandedTokens, " ");
            IToken replacementPragmaToken = originalPragmaToken.newToken(originalPragmaToken.getType(), originalPragmaToken.getOffset(), originalPragmaToken.getLineNumber(), newPragmaTokenText, "##macro##");
            return new PreprocessorTokenReplacement(Collections.singletonList(replacementPragmaToken), originalPragmaTokenIndex, originalPragmaTokenIndex + 1, preprocessorUsageInformation);
        }
        catch (CPreprocessor.PreprocessorException e) {
            CPreprocessor.logParseLogMessage("Exception during expansion of pragma: " + e.getMessage() + ". Continuing without expansion of this pragma.", originalPragmaToken, fileContext);
            return null;
        }
    }

    private static @Nullable Pair<String, String> splitPragma(String pragmaTokenText) {
        if (pragmaTokenText.equals("#pragma")) {
            return new Pair((Object)"#pragma", (Object)"");
        }
        Matcher matcher = PRAGMA_DIRECTIVE_PREFIX.matcher(pragmaTokenText);
        if (!matcher.find()) {
            return null;
        }
        String pragmaPrefix = pragmaTokenText.substring(0, matcher.end());
        String pragmaSuffix = "";
        if (!matcher.hitEnd()) {
            pragmaSuffix = pragmaTokenText.substring(matcher.end());
        }
        return new Pair((Object)pragmaPrefix, (Object)pragmaSuffix);
    }
}

