/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.IShallowParser;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.RecognizerUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.PairList;

public abstract class ShallowParserBase<STATE extends Enum<STATE>>
implements IShallowParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<STATE> stateClass;
    private final STATE initialState;
    private final PairList<Set<STATE>, RecognizerBase<STATE>> recognizers = new PairList();

    protected ShallowParserBase(Class<STATE> stateClass, STATE initialState) {
        this.stateClass = stateClass;
        this.initialState = initialState;
    }

    protected RecognizerBase<STATE> inState(STATE ... states) {
        RecognizerBase recognizer = RecognizerUtils.emptyRecognizer();
        EnumSet<STATE> stateSet = EnumSet.noneOf(this.stateClass);
        stateSet.addAll(Arrays.asList(states));
        this.recognizers.add(stateSet, recognizer);
        return recognizer;
    }

    protected RecognizerBase<STATE> createRecognizer(RecognizerUtils.RecognizerBuilder<STATE> builder) {
        return RecognizerUtils.createRecognizer(builder);
    }

    protected RecognizerBase<STATE> inAnyState() {
        return this.inState((Enum[])this.stateClass.getEnumConstants());
    }

    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        return TokenUtils.isCommentToken(token);
    }

    @Override
    public List<ShallowEntity> parseTopLevelWithErrors(List<IToken> tokens) throws ShallowParserException {
        tokens = this.filterTokens(tokens);
        return this.parse(this.initialState, tokens);
    }

    @Override
    public List<ShallowEntity> parseFragmentWithErrors(List<IToken> tokens) throws ShallowParserException {
        tokens = this.filterTokens(tokens);
        List<ShallowEntity> best = new ArrayList<ShallowEntity>();
        int bestCount = 0;
        int bestStart = Integer.MAX_VALUE;
        for (Enum state : (Enum[])this.stateClass.getEnumConstants()) {
            List<ShallowEntity> list = this.parse(state, tokens);
            int count = ShallowParserBase.countCompleteEntities(list);
            int start = Integer.MAX_VALUE;
            if (!list.isEmpty()) {
                start = list.getFirst().getStartTokenIndex();
            }
            if (count <= bestCount && (count != bestCount || start >= bestStart)) continue;
            best = list;
            bestCount = count;
            bestStart = start;
        }
        return best;
    }

    private static int countCompleteEntities(List<ShallowEntity> list) {
        int result = 0;
        for (ShallowEntity entity : list) {
            result += entity.getCompleteEntityCount();
        }
        return result;
    }

    protected List<IToken> filterTokens(List<IToken> tokens) {
        return ShallowParserBase.filterTokens(tokens, (previousToken, token) -> this.isFilteredToken((IToken)token, (IToken)previousToken));
    }

    protected static List<IToken> filterTokens(List<IToken> tokens, BiPredicate<@Nullable IToken, IToken> filter) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        IToken previousToken = null;
        for (IToken token : tokens) {
            if (filter.test(previousToken, token)) continue;
            result.add(token);
            previousToken = token;
        }
        return result;
    }

    private List<ShallowEntity> parse(STATE startState, List<IToken> tokens) throws ShallowParserException {
        ParserState<STATE> parserState = new ParserState<STATE>(this.recognizers);
        try {
            int offset = 0;
            while (offset < tokens.size()) {
                int match = parserState.parse(startState, tokens, offset);
                if (match == -1) {
                    ++offset;
                    continue;
                }
                if (match <= offset) {
                    throw new ShallowParserException("Parser stopped making progress at offset " + offset + " with match " + match + " for tokens: " + String.valueOf(tokens));
                }
                offset = match;
            }
            return parserState.result;
        }
        catch (StackOverflowError e) {
            LOGGER.debug("Tokens: {}\nShallowEntities: {}", tokens, parserState.result);
            throw new ShallowParserException("Stack overflow while parsing occurred. This indicates a parser bug.", e);
        }
    }

    public void endWithPossibleContinuation(RecognizerBase<STATE> recognizer, @Nullable ITokenMatcher continuationMatcher) {
        if (continuationMatcher != null) {
            recognizer.sequenceBefore(continuationMatcher).endNodeWithContinuation();
        }
        recognizer.endNode();
    }
}

