/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker;

import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CaseInsensitiveMap;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;

public class ScopedTypeLookup {
    private static final String DEFAULT_PACKAGE_SEPARATOR = ".";
    private Set<String> importedNamespaces;
    private Map<String, TypedVariable> variableTypeInfos;
    private final Set<ScopedTypeLookup> parents = new LinkedHashSet<ScopedTypeLookup>();
    private String packageSeparator;
    private boolean isCaseSensitive;

    public ScopedTypeLookup() {
        this(DEFAULT_PACKAGE_SEPARATOR, true);
    }

    public ScopedTypeLookup(boolean isCaseSensitive) {
        this(DEFAULT_PACKAGE_SEPARATOR, isCaseSensitive);
    }

    public ScopedTypeLookup(String packageSeparator, boolean isCaseSensitive) {
        this(null, packageSeparator, isCaseSensitive);
    }

    private ScopedTypeLookup(ScopedTypeLookup parent) {
        this(parent, parent.getPackageSeparator(), parent.isCaseSensitive());
    }

    private ScopedTypeLookup(ScopedTypeLookup parent, String packageSeparator, boolean isCaseSensitive) {
        if (parent != null) {
            this.parents.add(parent);
        }
        this.packageSeparator = packageSeparator;
        this.isCaseSensitive = isCaseSensitive;
        if (isCaseSensitive) {
            this.importedNamespaces = new HashSet<String>();
            this.variableTypeInfos = new HashMap<String, TypedVariable>();
        } else {
            this.importedNamespaces = new CaseInsensitiveStringSet();
            this.variableTypeInfos = new CaseInsensitiveMap();
        }
    }

    public void addAddtitionalParent(ScopedTypeLookup parent) {
        if (parent == null || parent == this) {
            return;
        }
        CCSMAssert.isFalse((boolean)parent.getAncestors().contains(this), (String)"Parent to add must not be a descendant already.");
        this.parents.add(parent);
    }

    private Set<ScopedTypeLookup> getAncestors() {
        HashSet<ScopedTypeLookup> ancestors = new HashSet<ScopedTypeLookup>(this.parents);
        this.parents.forEach(parent -> ancestors.addAll(parent.getAncestors()));
        return ancestors;
    }

    public String getPackageSeparator() {
        return this.packageSeparator;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public ScopedTypeLookup createChildScope() {
        return new ScopedTypeLookup(this);
    }

    public Set<String> getAllVariables() {
        HashSet<String> variableSet = new HashSet<String>(this.variableTypeInfos.keySet());
        for (ScopedTypeLookup parent : this.parents) {
            variableSet.addAll(parent.getAllVariables());
        }
        return variableSet;
    }

    public TypedVariable putTypeInfo(String variableName, TypedVariable typeInfo) {
        return this.variableTypeInfos.put(variableName, typeInfo);
    }

    public TypedVariable getTypeInfo(String variableName) {
        TypedVariable value = this.variableTypeInfos.get(variableName);
        if (value != null) {
            return value;
        }
        for (ScopedTypeLookup parent : this.parents) {
            value = parent.getTypeInfo(variableName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public boolean addImportedNamespace(String namespace) {
        return this.importedNamespaces.add(namespace);
    }

    public Set<String> getImportedNamespaces() {
        HashSet<String> namespaces = new HashSet<String>(this.importedNamespaces);
        for (ScopedTypeLookup parent : this.parents) {
            namespaces.addAll(parent.getImportedNamespaces());
        }
        return namespaces;
    }

    public boolean containsVariable(String variableName) {
        return this.getTypeInfo(variableName) != null;
    }

    public boolean containsVariableWithEntity(String variableName, ShallowEntity definitionEntity) {
        TypedVariable typeInfo = this.variableTypeInfos.get(variableName);
        if (typeInfo != null && typeInfo.getDeclaringEntity().equals(definitionEntity)) {
            return true;
        }
        for (ScopedTypeLookup parent : this.parents) {
            if (!parent.containsVariableWithEntity(variableName, definitionEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean isShadowingVariable(String variableName, ShallowEntity variableEntity) {
        if (this.parents.isEmpty()) {
            return false;
        }
        if (this.variableTypeInfos.containsKey(variableName)) {
            return this.parents.stream().anyMatch(parent -> parent.containsVariableWithEntity(variableName, variableEntity));
        }
        return this.parents.stream().anyMatch(parent -> parent.isShadowingVariable(variableName, variableEntity));
    }

    public boolean hasFullyQualifiedTypeName(String variableName, String fullyQualifiedTypeName) {
        TypedVariable info = this.getTypeInfo(variableName);
        if (info == null) {
            throw new IllegalArgumentException("Type information for the given variableName does not exist.");
        }
        String typeName = info.getTypeNameWithoutGenericTypeParameter();
        if (this.equalsRespectingCaseSensitivity(typeName, fullyQualifiedTypeName)) {
            return true;
        }
        Set<String> namespaces = this.getImportedNamespaces();
        for (String namespace : namespaces) {
            String potentialFullyQualifiedTypeName = namespace + this.packageSeparator + typeName;
            if (!this.equalsRespectingCaseSensitivity(potentialFullyQualifiedTypeName, fullyQualifiedTypeName)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsRespectingCaseSensitivity(String first, String second) {
        if (this.isCaseSensitive) {
            return first.equals(second);
        }
        return first.equalsIgnoreCase(second);
    }
}

