/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.clike.CLikeCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

class JavaMethodCallFinder {
    JavaMethodCallFinder() {
    }

    static List<JavaMethodCallMatcher.MethodCall> findConstructorCalls(ShallowEntity root, JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher matcher) {
        ArrayList<JavaMethodCallMatcher.MethodCall> methodCalls = new ArrayList<JavaMethodCallMatcher.MethodCall>();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(root), (EShallowEntityType)EShallowEntityType.STATEMENT);
        TokenPattern standardEncoderConstructor = new TokenPattern().sequence(ETokenType.NEW).sequence(ETokenType.IDENTIFIER).group(0).sequence(ETokenType.LPAREN);
        TokenPattern lambdaConstructorPattern = new TokenPattern().sequence(ETokenType.IDENTIFIER).group(0).sequence(ETokenType.DOUBLE_COLON, ETokenType.NEW);
        TokenPattern getInstancePattern = new TokenPattern().sequence(ETokenType.IDENTIFIER).group(0).sequence(ETokenType.DOT).regex("getInstance|INSTANCE|Instance");
        for (ShallowEntity statement : statements) {
            ArrayList<TokenPatternMatch> matchesForPatterns = new ArrayList<TokenPatternMatch>(Stream.concat(standardEncoderConstructor.findNonOverlappingMatches((List<IToken>)statement.ownStartTokens()).stream(), lambdaConstructorPattern.findNonOverlappingMatches((List<IToken>)statement.ownStartTokens()).stream()).toList());
            if (matcher.alsoAddGetInstanceCalls()) {
                matchesForPatterns.addAll(getInstancePattern.findNonOverlappingMatches((List<IToken>)statement.ownStartTokens()));
            }
            for (TokenPatternMatch constructorMatch : matchesForPatterns) {
                List<List<IToken>> parameters;
                IToken callToken = constructorMatch.groupTokens(0).getFirst();
                String fullType = typeResolver.getFullyQualifiedTypeName(callToken.getText());
                if (!matcher.getFullTypeNames().contains(fullType) || !JavaMethodCallFinder.hasMatchingParameters(parameters = CLikeCheckUtils.getMethodArguments(statement, callToken.getOffset()), matcher)) continue;
                methodCalls.add(new JavaMethodCallMatcher.MethodCall(statement, callToken, parameters, matcher.getTag()));
            }
        }
        return methodCalls;
    }

    static List<JavaMethodCallMatcher.MethodCall> findCallsOnType(ShallowEntity root, JavaImportSensitiveTypeResolver typeResolver, ITypeResolution typeResolution, JavaMethodCallMatcher methodMatcher) {
        ArrayList<JavaMethodCallMatcher.MethodCall> methodCalls = new ArrayList<JavaMethodCallMatcher.MethodCall>();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)root.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            UnmodifiableList tokens = statement.ownStartTokens();
            List<PotentialMatch> potentialMatches = JavaMethodCallFinder.collectCallsOnVariables(methodMatcher, (List<IToken>)tokens);
            JavaMethodCallFinder.collectCallsWithNewKeyword((List<IToken>)tokens, potentialMatches);
            List<JavaMethodCallMatcher.MethodCall> staticCalls = JavaMethodCallFinder.collectCallsOfStaticallyImportedMethods(statement, (List<IToken>)tokens, typeResolver, methodMatcher);
            methodCalls.addAll(staticCalls);
            ScopedTypeLookup lookup = typeResolution.getTypeLookup(statement);
            for (PotentialMatch candidate : potentialMatches) {
                List<List<IToken>> parameters;
                IToken tokenWithCalledMethodName = candidate.callStartingWithMethodName.getFirst();
                if (methodMatcher.getKnownMethodReturningSameType().contains(tokenWithCalledMethodName.getText())) {
                    Optional<IToken> methodCallLaterInTokenStream = candidate.callStartingWithMethodName.stream().filter(token -> token.getType().isIdentifier() && methodMatcher.getTargetMethodNames().contains(token.getText())).findFirst();
                    if (methodCallLaterInTokenStream.isEmpty()) continue;
                    tokenWithCalledMethodName = methodCallLaterInTokenStream.get();
                }
                if (!methodMatcher.getTargetMethodNames().contains(tokenWithCalledMethodName.getText()) || !JavaMethodCallFinder.hasMatchingParameters(parameters = CLikeCheckUtils.getMethodArguments(statement, tokenWithCalledMethodName.getOffset()), methodMatcher) || !JavaMethodCallFinder.methodInvocationHasRightType(typeResolver, methodMatcher, candidate.tokensUntilMethodCall, lookup)) continue;
                methodCalls.add(new JavaMethodCallMatcher.MethodCall(statement, tokenWithCalledMethodName, parameters, methodMatcher.getTag()));
            }
        }
        return methodCalls;
    }

    private static void collectCallsWithNewKeyword(List<IToken> tokens, List<PotentialMatch> result) {
        for (Integer indexOfNewKeyword : TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.DOT)) {
            int offsetToLeftConstructorBrace = TokenStreamUtils.firstTokenMatching(tokens, indexOfNewKeyword, (ITokenMatcher)ETokenType.LPAREN) - indexOfNewKeyword;
            if (offsetToLeftConstructorBrace < 0) continue;
            List<IToken> constructorTokens = TokenStreamUtils.tokensBetweenWithNesting(tokens, indexOfNewKeyword + offsetToLeftConstructorBrace, ETokenType.LPAREN, ETokenType.RPAREN);
            int afterConstructorIndex = indexOfNewKeyword + offsetToLeftConstructorBrace + constructorTokens.size() + 2;
            if (!TokenStreamUtils.hasTokenTypeSequence(tokens, afterConstructorIndex, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN)) continue;
            int methodCallIndex = afterConstructorIndex + 1;
            List<IToken> callStartingWithMethodName = tokens.subList(methodCallIndex, tokens.size());
            List<IToken> tokensUntilMethodCall = tokens.subList(indexOfNewKeyword + 1, indexOfNewKeyword + offsetToLeftConstructorBrace);
            result.add(new PotentialMatch(callStartingWithMethodName, tokensUntilMethodCall));
        }
    }

    private static List<JavaMethodCallMatcher.MethodCall> collectCallsOfStaticallyImportedMethods(ShallowEntity statement, List<IToken> tokens, JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher) {
        List<Integer> callIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ETokenType.IDENTIFIER, ETokenType.LPAREN);
        ArrayList<JavaMethodCallMatcher.MethodCall> staticCalls = new ArrayList<JavaMethodCallMatcher.MethodCall>();
        UnmodifiableSet<String> staticImports = typeResolver.getStaticImports();
        for (Integer tokenIndex : callIndices) {
            if (!JavaMethodCallFinder.isPotentialCallOfStaticallyImportedMethod(tokens, tokenIndex)) continue;
            IToken methodCallToken = tokens.get(tokenIndex);
            if (!methodMatcher.getTargetMethodNames().contains(methodCallToken.getText())) continue;
            for (String staticImport : staticImports) {
                Optional<JavaMethodCallMatcher.MethodCall> optionalStaticCall = JavaMethodCallFinder.extractStaticallyImportedMethodCall(statement, methodMatcher, staticImport, methodCallToken);
                optionalStaticCall.ifPresent(staticCalls::add);
            }
        }
        return staticCalls;
    }

    private static Optional<JavaMethodCallMatcher.MethodCall> extractStaticallyImportedMethodCall(ShallowEntity statement, JavaMethodCallMatcher methodMatcher, String staticImport, IToken method) {
        for (String typeName : methodMatcher.getFullTypeNames()) {
            List<List<IToken>> parameters;
            if (!staticImport.equals(typeName + "." + method.getText()) || !JavaMethodCallFinder.hasMatchingParameters(parameters = CLikeCheckUtils.getMethodArguments(statement, method.getOffset()), methodMatcher)) continue;
            return Optional.of(new JavaMethodCallMatcher.MethodCall(statement, method, parameters, methodMatcher.getTag()));
        }
        return Optional.empty();
    }

    private static boolean isPotentialCallOfStaticallyImportedMethod(List<IToken> tokens, int index) {
        if (index == 0) {
            return true;
        }
        return tokens.get(index - 1).getType() != ETokenType.DOT;
    }

    private static List<PotentialMatch> collectCallsOnVariables(JavaMethodCallMatcher methodMatcher, List<IToken> tokens) {
        return new ArrayList<PotentialMatch>(TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN).stream().map(tokenIndex -> {
            List<IToken> tokensUntilMethodCall = tokens.subList(0, Math.max(0, tokenIndex));
            List<IToken> tokensFromMethodName = tokens.subList(tokenIndex + 1, tokens.size());
            if (methodMatcher.getTargetMethodNames().contains(((IToken)tokensFromMethodName.getFirst()).getText())) {
                return new PotentialMatch(tokensFromMethodName, tokensUntilMethodCall);
            }
            return null;
        }).filter(Objects::nonNull).toList());
    }

    private static boolean methodInvocationHasRightType(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher, List<IToken> tokensUntilMethodCall, ScopedTypeLookup lookup) {
        String maybeTypeName;
        Set<String> fullTypeNames = methodMatcher.getFullTypeNames();
        Optional<Boolean> isOfType = typeResolver.isOfType(tokensUntilMethodCall, fullTypeNames, lookup, CollectionUtils.emptyIfNull(methodMatcher.getKnownMethodReturningSameType()));
        if (isOfType.isPresent() && isOfType.get().booleanValue()) {
            return true;
        }
        if (tokensUntilMethodCall.stream().allMatch(token -> token.getType() == ETokenType.IDENTIFIER || token.getType() == ETokenType.DOT) && fullTypeNames.contains(maybeTypeName = TokenStreamTextUtils.concatTokenTexts(tokensUntilMethodCall))) {
            return true;
        }
        if (!(methodMatcher.allowChaining() || tokensUntilMethodCall.size() != 1 && tokensUntilMethodCall.get(tokensUntilMethodCall.size() - 2).getType() == ETokenType.DOT)) {
            return tokensUntilMethodCall.getLast().getType() == ETokenType.IDENTIFIER && fullTypeNames.contains(typeResolver.getFullyQualifiedTypeName(tokensUntilMethodCall.getLast().getText()));
        }
        return JavaMethodCallFinder.handlePotentialInnerClass(typeResolver, methodMatcher, tokensUntilMethodCall);
    }

    private static boolean handlePotentialInnerClass(JavaImportSensitiveTypeResolver typeResolver, JavaMethodCallMatcher methodMatcher, List<IToken> tokensUntilMethodCall) {
        String innerClassAwareType = StringUtils.stripSuffix((String)tokensUntilMethodCall.stream().takeWhile(token -> !methodMatcher.allowChaining() || token.getType() == ETokenType.IDENTIFIER || token.getType() == ETokenType.DOT).map(token -> {
            if (token.getType() == ETokenType.DOT) {
                return "$";
            }
            return token.getText();
        }).collect(Collectors.joining()), (String)"$");
        String[] typeParts = innerClassAwareType.split("\\$", 2);
        Set<String> fullTypeNames = methodMatcher.getFullTypeNames();
        if (fullTypeNames.contains(typeResolver.getFullyQualifiedTypeName(typeParts[0]))) {
            return true;
        }
        if (typeParts.length < 2) {
            return false;
        }
        String parentType = typeParts[0];
        return fullTypeNames.contains(typeResolver.getFullyQualifiedTypeName(parentType) + "$" + typeParts[1]);
    }

    private static boolean hasMatchingParameters(List<List<IToken>> parameters, JavaMethodCallMatcher methodMatcher) {
        int parameterCount = parameters.size();
        if (methodMatcher.getMinParameters() != null && parameterCount < methodMatcher.getMinParameters()) {
            return false;
        }
        if (methodMatcher.getMaxParameters() != null && parameterCount > methodMatcher.getMaxParameters()) {
            return false;
        }
        return methodMatcher.getParameterPredicates().stream().allMatch(parameterCondition -> parameterCondition.test(parameters));
    }

    private record PotentialMatch(List<IToken> callStartingWithMethodName, List<IToken> tokensUntilMethodCall) {
    }
}

