/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.javascript;

import com.google.common.collect.Iterables;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.javascript.JavascriptDependencyUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ES6DependencyUtils {
    public static final String ES6_IMPORT_SEPARATOR = ":#from#:";
    public static final String DEFAULT_EXPORT_SUFFIX = "defaultExport";
    public static final String OBJECT_EXPORT_SUFFIX = "objectExport";

    public static List<String> extractExportedTypes(List<ShallowEntity> entities, String uniformPath) {
        String typePrefix = JavascriptDependencyUtils.convertUniformPathToTypeFormat(uniformPath);
        return entities.stream().flatMap(entity -> ES6DependencyUtils.extractExportedTypes(entity).stream()).map(typeSuffix -> JavascriptDependencyUtils.joinTypeSuffix(typePrefix, typeSuffix)).collect(Collectors.toList());
    }

    private static List<String> extractExportedTypes(ShallowEntity entity) {
        if ("object export".equals(entity.getSubtype())) {
            return Collections.singletonList(OBJECT_EXPORT_SUFFIX);
        }
        if (ES6DependencyUtils.isDefaultExportStatement(entity)) {
            return Collections.singletonList(DEFAULT_EXPORT_SUFFIX);
        }
        if ("exported variable".equals(entity.getSubtype())) {
            return ES6DependencyUtils.extractFromExportedVariables(entity);
        }
        if ("export".equals(entity.getSubtype())) {
            return ES6DependencyUtils.extractFromMemberExport(entity);
        }
        if ("re-export".equals(entity.getSubtype())) {
            return Collections.emptyList();
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        if (((IToken)tokens.get(0)).getType() == ETokenType.EXPORT) {
            if (tokens.size() > 1 && ((IToken)tokens.get(1)).getType() == ETokenType.EQ) {
                return Collections.singletonList(OBJECT_EXPORT_SUFFIX);
            }
            return Collections.singletonList(entity.getName());
        }
        return Collections.emptyList();
    }

    private static List<String> extractFromMemberExport(ShallowEntity entity) {
        List<List<IToken>> exportAsSequences = TokenStreamUtils.splitUntilToken(ETokenType.RBRACE, (List<IToken>)entity.ownStartTokens().subList(2, entity.ownStartTokens().size()), ETokenType.COMMA);
        if (((List)Iterables.getLast(exportAsSequences)).isEmpty()) {
            exportAsSequences = exportAsSequences.subList(0, exportAsSequences.size() - 1);
        }
        return CollectionUtils.map(exportAsSequences, exportAsSequence -> ES6DependencyUtils.ifTokenIsDefaultThenDefaultSuffixElseTokenText((IToken)Iterables.getLast((Iterable)exportAsSequence)));
    }

    private static List<String> extractFromExportedVariables(ShallowEntity entity) {
        Object tokens = entity.includedTokens();
        if (tokens.size() <= 2) {
            return Collections.emptyList();
        }
        if (((IToken)(tokens = tokens.subList(2, tokens.size())).get(0)).getType() == ETokenType.LBRACE) {
            tokens = tokens.subList(1, tokens.size());
        }
        List<List<IToken>> declarationPossibleAssignmentSequences = TokenStreamUtils.splitWithNesting((List<IToken>)tokens, ETokenType.COMMA, ETokenType.LPAREN, ETokenType.RPAREN);
        return declarationPossibleAssignmentSequences.stream().filter(sequence -> !sequence.isEmpty()).map(sequence -> (IToken)sequence.get(0)).filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).collect(Collectors.toList());
    }

    private static String ifTokenIsDefaultThenDefaultSuffixElseTokenText(IToken exportToken) {
        if (exportToken.getType() == ETokenType.DEFAULT) {
            return DEFAULT_EXPORT_SUFFIX;
        }
        return exportToken.getText();
    }

    private static boolean isDefaultExportStatement(ShallowEntity entity) {
        UnmodifiableList entityTokens = entity.ownStartTokens();
        if (entityTokens.size() < 2) {
            return false;
        }
        ETokenType startToken = ((IToken)entityTokens.get(0)).getType();
        ETokenType nextToken = ((IToken)entityTokens.get(1)).getType();
        return startToken == ETokenType.EXPORT && nextToken == ETokenType.DEFAULT;
    }
}

