/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class TokenUtils {
    public static final UnmodifiableSet<ETokenType> ALWAYS_CASE_SENSITIVE_TOKEN_TYPES = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.STRING_LITERAL, ETokenType.CHARACTER_LITERAL, ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.UNTERMINATED_CHARACTER_LITERAL));
    private static final UnmodifiableSet<ETokenType.ETokenClass> NON_COMMENT_TOKEN_CLASSES = CollectionUtils.asUnmodifiable(EnumSet.complementOf(EnumSet.of(ETokenType.ETokenClass.COMMENT, ETokenType.ETokenClass.SYNTHETIC, ETokenType.ETokenClass.WHITESPACE)));

    public static int estimateEndLineByLookahead(IToken token, IToken nextToken) {
        int tokenEndLine = nextToken.getLineNumber() - 1;
        return Math.max(tokenEndLine, token.getLineNumber());
    }

    public static int calculateEndLineByCountingLines(IToken token) {
        int tokenEndLine = token.getLineNumber() + StringUtils.countLines((String)token.getText()) - 1;
        return Math.max(tokenEndLine, token.getLineNumber());
    }

    public static boolean isEqualTypeAndText(IToken t1, IToken t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.getType() == t2.getType() && Objects.equals(t1.getText(), t2.getText());
    }

    public static Pair<TokenPattern, TokenPatternMatch> getMatchingPattern(Collection<TokenPattern> patterns, List<IToken> tokens) {
        for (TokenPattern pattern : patterns) {
            TokenPatternMatch match = pattern.findFirstMatch(tokens);
            if (match == null) continue;
            return new Pair((Object)pattern, (Object)match);
        }
        return null;
    }

    public static boolean isCommentToken(IToken token) {
        return ETokenType.ETokenClass.COMMENT.matches(token);
    }

    public static int getTokenLineCount(Set<ETokenType.ETokenClass> tokenClassesToPreserve, List<IToken> tokens, Set<Integer> coveredLines) {
        int count = 0;
        for (IToken token : tokens) {
            if (!tokenClassesToPreserve.contains(token.getType().getTokenClass())) continue;
            int startLine = token.getLineNumber();
            int endLine = token.getLineNumber() + StringUtils.countLines((String)token.getText());
            for (int line = startLine; line < endLine; ++line) {
                if (!coveredLines.add(line)) continue;
                ++count;
            }
        }
        return count;
    }

    public static int countSloc(List<IToken> tokens, Set<Integer> coveredLines) {
        return TokenUtils.getTokenLineCount(NON_COMMENT_TOKEN_CLASSES, tokens, coveredLines);
    }

    public static boolean isMacroGenerated(IToken token) {
        return "##macro##".equals(token.getOriginId());
    }
}

