/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow_data_typing;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class StateflowVariableTypeExtractor {
    public static final String INHERIT_SAME_AS_SIMULINK = "Inherit: Same as Simulink";
    public static final String INHERIT_FROM_DEFINITION_IN_CHART = "Inherit: From definition in chart";
    private final SimulinkResolvedDataTypes resolvedTypesForModel;

    public StateflowVariableTypeExtractor(SimulinkResolvedDataTypes resolvedTypesForModel) {
        this.resolvedTypesForModel = resolvedTypesForModel;
    }

    public String determineType(String variableName, StateflowDeclContainerBase<?> node) {
        return this.determineTypeRecursive(variableName, node, new HashSet<String>());
    }

    private String determineTypeRecursive(String variableName, StateflowDeclContainerBase<?> node, Set<String> ignoreVarNames) {
        while (node != null) {
            UnmodifiableSet data = node.getData();
            if (data == null) {
                node = (StateflowDeclContainerBase)node.getParent();
                continue;
            }
            Optional<StateflowData> variableEntry = data.stream().filter(dataEntry -> dataEntry.getName().equals(variableName)).findAny();
            if (variableEntry.isPresent()) {
                String type = variableEntry.get().getParameter("dataType");
                if (type.equals(INHERIT_SAME_AS_SIMULINK) && node instanceof StateflowChart) {
                    return this.determineTypeFromSimulink(variableName, variableEntry.get(), (StateflowChart)node);
                }
                if (type.startsWith("type(") && type.endsWith(")")) {
                    String referenceVarName = type.substring("type(".length(), type.length() - 1).trim();
                    if (ignoreVarNames.contains(referenceVarName)) {
                        return "Unknown";
                    }
                    HashSet<String> ignoredVariables = new HashSet<String>(ignoreVarNames);
                    ignoredVariables.add(variableName);
                    return this.determineTypeRecursive(referenceVarName, node, ignoredVariables);
                }
                if (type.startsWith("fixdt")) {
                    return SimulinkDataTypeUtils.getRealDataTypeOfFixedDataType((String)type, (boolean)true);
                }
                return type;
            }
            node = (StateflowDeclContainerBase)node.getParent();
        }
        return null;
    }

    private String determineTypeFromSimulink(String variableName, StateflowData stateflowData, StateflowChart chart) {
        String scope = stateflowData.getParameter("scope");
        if (scope.equals("DATA_STORE_MEMORY_DATA")) {
            return StateflowVariableTypeExtractor.determineTypeFromSimulinkDataStore(variableName, chart);
        }
        if (scope.equals("OUTPUT_DATA")) {
            String type = this.determineTypeFromSimulinkOutport(variableName, chart);
            if (type == null) {
                return "Unknown";
            }
            return type;
        }
        if (scope.equals("INPUT_DATA")) {
            return this.determineTypeFromSimulinkInport(variableName, chart);
        }
        return "Unknown";
    }

    private static String determineTypeFromSimulinkDataStore(String variableName, StateflowChart chart) {
        for (SimulinkBlock parent = chart.getStateflowBlock().getParent(); parent != null; parent = parent.getParent()) {
            for (SimulinkBlock block2 : CollectionUtils.filter((Collection)parent.getSubBlocks(), block -> block.getType().equals("DataStoreMemory"))) {
                if (!variableName.equals(block2.getParameter("DataStoreName"))) continue;
                String type = SimulinkDataTypeUtils.normalizeDataType((String)block2.getParameter("OutDataTypeStr"));
                if (type != null) {
                    return type;
                }
                return "Unknown";
            }
        }
        return "Unknown";
    }

    private String determineTypeFromSimulinkInport(String variableName, StateflowChart chart) {
        StateflowBlock stateflowBlock = chart.getStateflowBlock();
        if (stateflowBlock == null) {
            return "Unknown";
        }
        List inportBlocks = SimulinkUtils.getAllInportPortBlocks((SimulinkBlock)stateflowBlock);
        Optional<SimulinkBlock> variableInportBlock = inportBlocks.stream().filter(block -> variableName.equals(block.getParameter("Name"))).findAny();
        if (variableInportBlock.isPresent()) {
            SimulinkInPort chartSubsystemInport = SimulinkUtils.resolveInportOfSubsystemInportBlock((SimulinkBlock)variableInportBlock.get());
            String portId = chartSubsystemInport.getIndex();
            return this.resolvedTypesForModel.getInputDataType((SimulinkBlock)chart.getStateflowBlock(), portId);
        }
        return "Unknown";
    }

    private String determineTypeFromSimulinkOutport(String variableName, StateflowChart chart) {
        StateflowBlock stateflowBlock = chart.getStateflowBlock();
        if (stateflowBlock == null) {
            return "Unknown";
        }
        List outports = SimulinkUtils.getAllOutportPortBlocks((SimulinkBlock)stateflowBlock);
        Optional<SimulinkBlock> variableOutportBlock = outports.stream().filter(block -> variableName.equals(block.getParameter("Name"))).findAny();
        if (variableOutportBlock.isPresent()) {
            SimulinkOutPort chartSubsystemOutport = SimulinkUtils.resolveOutportOfSubsystemOutportBlock((SimulinkBlock)variableOutportBlock.get());
            String portId = chartSubsystemOutport.getIndex();
            return this.resolvedTypesForModel.getResolvedOutputDataTypesForBlock((SimulinkBlock)chart.getStateflowBlock(), portId);
        }
        return "Unknown";
    }

    public String determineType(String variableName, StateflowTransition transition) {
        IStateflowNodeContainer<?> parentContainer = StateflowVariableTypeExtractor.determineParentContainer(transition);
        if (parentContainer == null) {
            return "Unknown";
        }
        if (parentContainer instanceof StateflowDeclContainerBase) {
            return this.determineType(variableName, (StateflowDeclContainerBase)parentContainer);
        }
        return "Unknown";
    }

    private static IStateflowNodeContainer<?> determineParentContainer(StateflowTransition transition) {
        StateflowNodeBase src = transition.getSrc();
        StateflowNodeBase dst = transition.getDst();
        if (src == null && dst == null) {
            return null;
        }
        if (src == null) {
            return (IStateflowNodeContainer)dst.getParent();
        }
        if (dst == null) {
            return (IStateflowNodeContainer)src.getParent();
        }
        return StateflowVariableTypeExtractor.determineLeastCommonAncestors(src, dst);
    }

    private static IStateflowNodeContainer<?> determineLeastCommonAncestors(StateflowNodeBase src, StateflowNodeBase dst) {
        if (src.getParent() == dst.getParent()) {
            return (IStateflowNodeContainer)src.getParent();
        }
        HashSet<IStateflowNodeContainer> srcAncestors = new HashSet<IStateflowNodeContainer>();
        for (IStateflowNodeContainer srcParent = (IStateflowNodeContainer)src.getParent(); srcParent != null; srcParent = (IStateflowNodeContainer)srcParent.getParent()) {
            srcAncestors.add(srcParent);
            if (!(srcParent.getParent() instanceof IStateflowNodeContainer)) break;
        }
        for (IStateflowNodeContainer dstParent = (IStateflowNodeContainer)dst.getParent(); dstParent != null; dstParent = (IStateflowNodeContainer)dstParent.getParent()) {
            if (srcAncestors.contains(dstParent)) {
                return dstParent;
            }
            if (!(dstParent.getParent() instanceof IStateflowNodeContainer)) break;
        }
        return null;
    }
}

