/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.util;

import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.framework.util.ResponseUtils;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvServiceUtils {
    public static final String CSV_FILE_EXTENSION = "csv";

    public static Response createCsvResponse(String csvFileName, ConsumerWithTwoExceptions<CsvListWriter, IOException, StorageException> csvWritingCallback) throws InternalServerErrorException, StorageException {
        String entity = CsvServiceUtils.createCsvString(csvWritingCallback);
        return ResponseUtils.getFileDownloadResponse(entity, MoreMediaTypes.TEXT_CSV_TYPE, csvFileName + ".csv");
    }

    public static String createCsvString(ConsumerWithTwoExceptions<CsvListWriter, IOException, StorageException> csvWritingCallback) throws InternalServerErrorException, StorageException {
        String string;
        StringWriter stringWriter = new StringWriter();
        try {
            try (CsvListWriter csvListWriter = new CsvListWriter((Writer)stringWriter, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);){
                csvWritingCallback.accept((Object)csvListWriter);
            }
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InternalServerErrorException("Error creating CSV string.", (Throwable)e);
            }
        }
        stringWriter.close();
        return string;
    }
}

