/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.common;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.commons.Language;

@Immutable
public abstract class AbstractAnalysisConfiguration {
    private final List<ClientInputFile> inputFiles;
    private final Map<String, String> extraProperties;
    private final Path baseDir;
    private final Object moduleKey;

    protected AbstractAnalysisConfiguration(AbstractBuilder<?> builder) {
        this.baseDir = builder.baseDir;
        this.inputFiles = builder.inputFiles;
        this.extraProperties = builder.extraProperties;
        this.moduleKey = builder.moduleKey;
    }

    public Map<String, String> extraProperties() {
        return this.extraProperties;
    }

    public Path baseDir() {
        return this.baseDir;
    }

    @CheckForNull
    public Object moduleKey() {
        return this.moduleKey;
    }

    public List<ClientInputFile> inputFiles() {
        return this.inputFiles;
    }

    protected void generateToStringCommon(StringBuilder sb) {
        sb.append("  baseDir: ").append(this.baseDir()).append("\n");
        sb.append("  extraProperties: ").append(this.extraProperties()).append("\n");
        sb.append("  moduleKey: ").append(this.moduleKey()).append("\n");
    }

    protected void generateToStringInputFiles(StringBuilder sb) {
        sb.append("  inputFiles: [\n");
        for (ClientInputFile inputFile : this.inputFiles()) {
            Language language;
            sb.append("    ").append(inputFile.uri());
            sb.append(" (").append(AbstractAnalysisConfiguration.getCharsetLabel(inputFile)).append(")");
            if (inputFile.isTest()) {
                sb.append(" [test]");
            }
            if ((language = inputFile.language()) != null) {
                sb.append(" [" + language.getLanguageKey() + "]");
            }
            sb.append("\n");
        }
        sb.append("  ]\n");
    }

    private static String getCharsetLabel(ClientInputFile inputFile) {
        Charset charset = inputFile.getCharset();
        return charset != null ? charset.displayName() : "default";
    }

    public static abstract class AbstractBuilder<G extends AbstractBuilder<G>> {
        private final List<ClientInputFile> inputFiles = new ArrayList<ClientInputFile>();
        private final Map<String, String> extraProperties = new HashMap<String, String>();
        private Path baseDir;
        private Object moduleKey;

        public G addInputFiles(ClientInputFile ... inputFiles) {
            Collections.addAll(this.inputFiles, inputFiles);
            return (G)this;
        }

        public G addInputFiles(Collection<? extends ClientInputFile> inputFiles) {
            this.inputFiles.addAll(inputFiles);
            return (G)this;
        }

        public G addInputFile(ClientInputFile inputFile) {
            this.inputFiles.add(inputFile);
            return (G)this;
        }

        public G putAllExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties.putAll(extraProperties);
            return (G)this;
        }

        public G putExtraProperty(String key, String value) {
            this.extraProperties.put(key, value);
            return (G)this;
        }

        public G setBaseDir(Path baseDir) {
            this.baseDir = baseDir;
            return (G)this;
        }

        public G setModuleKey(@Nullable Object moduleKey) {
            this.moduleKey = moduleKey;
            return (G)this;
        }
    }
}

