/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rules;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.IOUtils;

class CleanCodePrinciples {
    @CheckForNull
    public static String getContent(String key) {
        InputStream fileStream = CleanCodePrinciples.class.getResourceAsStream("/clean-code-principles/" + key + ".html");
        if (fileStream == null) {
            SonarLintLogger.get().info("Unsupported clean code principle key: " + key);
            return null;
        }
        try {
            return IOUtils.toString(fileStream, StandardCharsets.UTF_8).trim().replaceAll("\\r\\n?", "\n");
        }
        catch (IOException e) {
            SonarLintLogger.get().error("Could not read content for clean code principle key: " + key, e);
            return null;
        }
    }

    private CleanCodePrinciples() {
    }
}

