/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.architecture.ArchitectureEditorUtils;
import com.teamscale.index.architecture.ArchitectureInfo;
import com.teamscale.index.architecture.ArchitectureInfoUtils;
import com.teamscale.index.architecture.external.ArchitectureUploadAnalysisStateIndex;
import com.teamscale.index.architecture.external.ArchitectureUploadInfo;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadChangeRetriever;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.retrievers.BranchesRetrieverFactory;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.architecture.ArchitectureConverter;
import com.teamscale.service.architecture.ArchitectureExternalUploadInfoService;
import com.teamscale.service.architecture.IArchitectureUploadServiceApi;
import com.teamscale.service.upload.base.ExternalUploadServiceBase;
import com.teamscale.service.upload.base.ExternalUploadServiceQueryOptions;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

@Path(value="api/projects/{project}/architectures")
public class ArchitectureUploadService
extends ExternalUploadServiceBase<ExternalUploadServiceQueryOptions>
implements IArchitectureUploadServiceApi {
    private static final Pattern XML_COMMENT_PATTERN = Pattern.compile("(?s)<!--.*?-->");
    private static final Pattern CREATION_DATE_ATTRIBUTE_PATTERN = Pattern.compile("creation-date=\"\\d*\"");
    static final String COMMIT_MESSAGE_PARAMETER = "message";
    public static final String SAVE_TO_ALL_IMPORTANT_PARAMETER = "save-to-all-important-branches";
    static final String COMMIT_MESSAGE_PARAMETER_DESCRIPTION = "The commit message describing the changes made by the upload.";
    static final String SAVE_TO_ALL_IMPORTANT_PARAMETER_DESCRIPTION = "If true, the architecture will be saved to all important branches and default branch in addition to the current branch";
    static final String DEFAULT_COMMIT_MESSAGE = "Imported new architecture";
    private static final String LOCK_PREFIX = "architecture-upload-lock-";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadArchitectureAsJson(ExternalUploadServiceQueryOptions parameters, String commitMessage, ArchitectureInfoWithUniformPath architectureInfo, boolean saveToAllImportantBranches) throws ConQATException {
        ArchitectureInfoUtils.validate((ArchitectureInfo)architectureInfo.architecture);
        Lock lock = this.serviceInfo.getLockProvider().obtainLock(LOCK_PREFIX + String.valueOf(this.serviceInfo.getInternalId()));
        lock.lock();
        try {
            this.processRequestContent(architectureInfo, commitMessage, this.getUploadCommit(parameters), saveToAllImportantBranches);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void uploadArchitecture(ExternalUploadServiceQueryOptions parameters, String commitMessage, ArchitectureConverter.EArchitectureFormat format, String templatePath, FormDataMultiPart multiPart, boolean saveToAllImportantBranches) throws StorageException, BadRequestException {
        CommitDescriptor commit = this.getUploadCommit(parameters);
        this.processMultiPartData(multiPart, commit.toUnresolvedCommitDescriptor(), format, templatePath, commitMessage, commit, saveToAllImportantBranches);
    }

    @Override
    public void deleteAllArchitectureCommits(UniformPath uniformPath, String commitMessage) throws StorageException {
        for (ArchitectureExternalUploadInfoService.ArchitectureCommitUploadInfo uploadInfo : ArchitectureExternalUploadInfoService.extractArchitectureUploadInfoListForPath(uniformPath, this.openExternalResultBranchingLayer())) {
            this.deleteArchitecture(uniformPath, commitMessage, uploadInfo.commit);
        }
    }

    @Override
    public void deleteArchitecture(ExternalUploadServiceQueryOptions parameters, UniformPath uniformPath, String commitMessage) throws StorageException {
        CommitDescriptor artificialUploadCommit = this.getUploadCommit(parameters);
        this.deleteArchitecture(uniformPath, commitMessage, artificialUploadCommit);
    }

    private void processMultiPartData(FormDataMultiPart multiPart, UnresolvedCommitDescriptor commit, ArchitectureConverter.EArchitectureFormat format, String templatePath, String commitMessage, CommitDescriptor proposedUploadCommit, boolean saveToAllImportantBranches) throws BadRequestException, StorageException {
        List bodyParts = multiPart.getBodyParts();
        ArrayList<String> architecturesAsXml = new ArrayList<String>(bodyParts.size());
        ArrayList<String> paths = new ArrayList<String>(bodyParts.size());
        try {
            for (BodyPart part2 : bodyParts.stream().filter(part -> part.getMediaType().isCompatible(MediaType.APPLICATION_OCTET_STREAM_TYPE) || part.getMediaType().isCompatible(MediaType.TEXT_PLAIN_TYPE)).toList()) {
                FormDataContentDisposition contentDisposition = (FormDataContentDisposition)part2.getContentDisposition();
                String inputArchitecturePath = contentDisposition.getName();
                if (inputArchitecturePath.equals("file")) {
                    inputArchitecturePath = contentDisposition.getFileName();
                }
                String architecturePath = ArchitectureUploadService.sanitizeArchitecturePath(inputArchitecturePath);
                paths.add(architecturePath);
                architecturesAsXml.add(new ArchitectureConverter(this.serviceInfo, templatePath, architecturePath, this.determineHistoryOption(commit), this.getParallelTaskExecutor()).convertArchitecture(ArchitectureUploadService.readBodyPart(part2), format));
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        this.processUpload(architecturesAsXml, paths, commitMessage, proposedUploadCommit, true, saveToAllImportantBranches);
    }

    private static String sanitizeArchitecturePath(String uniformPath) throws BadRequestException {
        Preconditions.checkArgument((!uniformPath.isEmpty() ? 1 : 0) != 0, (Object)"Architecture file must have a name.");
        if (!UniformPathUtils.isArchitectureFile((String)uniformPath)) {
            throw new BadRequestException("Architecture path must have extension .architecture");
        }
        return StringUtils.stripPrefix((String)uniformPath.trim(), (String)"/");
    }

    private void deleteArchitecture(UniformPath uniformPath, String commitMessage, CommitDescriptor artificialUploadCommit) throws StorageException, BadRequestException {
        IBranchCommitInfo branchCommitInfo = this.openExternalResultBranchingLayer().getNewestCommitBeforeOrAt(artificialUploadCommit.getBranchName(), artificialUploadCommit.getTimestamp());
        if (branchCommitInfo == null) {
            throw new BadRequestException("Can't perform architecture delete for project with no architecture commit.");
        }
        List<String> deletedPaths = Collections.singletonList(uniformPath.toString());
        ArchitectureUploadInfo uploadInfo = Objects.equals(branchCommitInfo.getBranchName(), artificialUploadCommit.getBranchName()) && branchCommitInfo.getTimestamp() == artificialUploadCommit.getTimestamp() ? null : new ArchitectureUploadInfo(this.serviceInfo.getUser().getUsername(), commitMessage, (List)CollectionUtils.emptyList(), (List)CollectionUtils.emptyList(), deletedPaths);
        this.insertArchitectureUpload(artificialUploadCommit, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType.DELETE, uploadInfo, deletedPaths);
    }

    private void processRequestContent(ArchitectureInfoWithUniformPath architectureInfo, String commitMessage, CommitDescriptor proposedUploadCommit, boolean saveToAllImportantBranches) throws ConQATException {
        ArchitectureDefinition architecture = ArchitectureEditorUtils.writeArchitectureDefinition((ArchitectureInfo)architectureInfo.architecture);
        List<String> architecturesAsXml = Collections.singletonList(ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architecture, (PublicProjectId)this.serviceInfo.getPrimaryPublicId()));
        List<String> paths = Collections.singletonList(architectureInfo.uniformPath);
        this.processUpload(architecturesAsXml, paths, commitMessage, proposedUploadCommit, false, saveToAllImportantBranches);
    }

    private void processUpload(List<String> architecturesAsXml, List<String> paths, String commitMessage, CommitDescriptor proposedUploadCommit, boolean isImport, boolean saveToAllImportantBranches) throws StorageException {
        Set<String> branchesToUpdate = this.findBranchesToUpdate(proposedUploadCommit, saveToAllImportantBranches);
        for (String branchName : branchesToUpdate) {
            CommitDescriptor artificialUploadCommit = this.getCorrectedCommit(new CommitDescriptor(branchName, proposedUploadCommit.getTimestamp()), false);
            Map<String, String> pathToArchitecture = this.buildCurrentPathToArchitectureMapping(paths, artificialUploadCommit);
            ArrayList<String> newPaths = new ArrayList<String>();
            ArrayList<String> newArchitectureData = new ArrayList<String>();
            for (int i = 0; i < paths.size(); ++i) {
                if (!ArchitectureUploadService.areArchitecturesEqual(architecturesAsXml.get(i), pathToArchitecture.get(paths.get(i)))) {
                    newPaths.add(paths.get(i));
                    newArchitectureData.add(architecturesAsXml.get(i));
                    continue;
                }
                LOGGER.warn("Ignoring architecture upload with identical content as already existing architecture");
            }
            if (newPaths.isEmpty()) continue;
            this.storeArchitectures(newArchitectureData, newPaths, commitMessage, artificialUploadCommit, isImport);
        }
    }

    private Set<String> findBranchesToUpdate(CommitDescriptor proposedUploadCommit, boolean saveToAllImportantBranches) throws StorageException {
        String originalBranch = proposedUploadCommit.getBranchName();
        if (!saveToAllImportantBranches) {
            return Set.of(originalBranch);
        }
        MetaIndex metaIndex = (MetaIndex)this.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration config = ProjectConfigurationUtils.getProjectConfiguration((MetaIndex)metaIndex, (boolean)true);
        if (config == null) {
            throw new StorageException("Could not retrieve project config");
        }
        HashSet<String> importantBranches = new HashSet<String>();
        for (ConnectorConfiguration connector : config.getConnectors()) {
            List<String> importantBranchesFromConnector = this.getImportantBranchesFromConnector(connector);
            importantBranches.addAll(importantBranchesFromConnector);
        }
        String defaultBranch = this.openProjectIndex(MetaIndex.class, null).getDefaultBranchName();
        return CollectionUtils.unionSet(Set.of(originalBranch), (Collection[])new Collection[]{Set.of(defaultBranch), importantBranches});
    }

    private List<String> getImportantBranchesFromConnector(ConnectorConfiguration connector) throws StorageException {
        PatternList importantBranchPatterns;
        String importantBranchesOptionValue = connector.getOptionValue("Important Branches");
        if (StringUtils.isEmpty((String)importantBranchesOptionValue)) {
            return Collections.emptyList();
        }
        List patternStrings = CollectionUtils.parseMultiValueStringToList((String)importantBranchesOptionValue, (boolean)true);
        try {
            importantBranchPatterns = GitRepositoryConnectorDescriptor.compileImportantBranchPatterns((List)patternStrings);
        }
        catch (ConnectorValidationException e) {
            throw new IllegalStateException(e);
        }
        Set<String> branches = this.getBranchesFromConnector(connector);
        return branches.stream().filter(arg_0 -> ((PatternList)importantBranchPatterns).matchesAny(arg_0)).toList();
    }

    private Set<String> getBranchesFromConnector(ConnectorConfiguration connector) throws StorageException {
        StringTransformation branchRenamer;
        Set branches;
        ERepositoryConnector repositoryConnector = ERepositoryConnector.findByReadableName((String)connector.getType());
        IBranchRetriever branchRetriever = BranchesRetrieverFactory.getBranchRetriever((ConnectorConfiguration)connector, (ERepositoryConnector)repositoryConnector, (GlobalStorageSystem)this.getGlobalStorageSystem(), (Logger)LOGGER);
        if (branchRetriever == null) {
            return Collections.emptySet();
        }
        ExternalCredentialsIndex index = this.openGlobalIndex(ExternalCredentialsIndex.class);
        String accountName = connector.getOptionValue("Account");
        ExternalCredentials credentials = null;
        if (accountName != null) {
            credentials = index.getExternalCredentials(accountName);
        }
        try {
            branches = branchRetriever.fetchBranches(true, this.serviceInfo.getUser().getUsername(), credentials, connector);
        }
        catch (ProjectConfigurationException | RepositoryException e) {
            throw new StorageException("Failed to retrieve branches", e);
        }
        try {
            String branchTransformationOptionValue = connector.getOptionValue("Branch transformation");
            PairList branchTransformationPatterns = StringValuePairListOptionDescriptor.parseFromString((String)branchTransformationOptionValue);
            branchRenamer = StringTransformation.fromStringPairs((PairList)branchTransformationPatterns);
        }
        catch (ProjectConfigurationException | ConQATException e) {
            throw new StorageException("Failed to transform branch names", e);
        }
        return branches.stream().map(arg_0 -> ((StringTransformation)branchRenamer).apply(arg_0)).collect(Collectors.toSet());
    }

    private static boolean areArchitecturesEqual(String architecture1, String architecture2) {
        return ArchitectureUploadService.normalizeArchitectureXml(architecture1).equals(ArchitectureUploadService.normalizeArchitectureXml(architecture2));
    }

    private static String normalizeArchitectureXml(String architectureXml) {
        if (architectureXml == null) {
            return null;
        }
        return CREATION_DATE_ATTRIBUTE_PATTERN.matcher(XML_COMMENT_PATTERN.matcher(architectureXml).replaceAll("")).replaceAll("");
    }

    private void storeArchitectures(List<String> architecturesAsXml, List<String> paths, String commitMessage, CommitDescriptor artificialUploadCommit, boolean isImport) throws StorageException {
        this.validateArchitectureContent(paths, architecturesAsXml);
        if (isImport) {
            this.setCreatorAndCreationDate(paths, architecturesAsXml, artificialUploadCommit);
        }
        ArchitectureUploadInfo uploadInfo = new ArchitectureUploadInfo(this.serviceInfo.getUser().getUsername(), commitMessage, paths, architecturesAsXml, (List)CollectionUtils.emptyList());
        this.insertArchitectureUpload(artificialUploadCommit, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType.ADD, uploadInfo, paths);
    }

    private void validateArchitectureContent(List<String> paths, List<String> architectureData) {
        for (int i = 0; i < paths.size(); ++i) {
            architectureData.set(i, this.ensureArchitectureInXMLFormat(architectureData.get(i)));
            try {
                ArchitectureDefinition architectureDefinition = ArchitectureDefinitionReader.read((String)paths.get(i), (String)architectureData.get(i));
                architectureData.set(i, ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architectureDefinition, (PublicProjectId)this.serviceInfo.getPrimaryPublicId()));
                continue;
            }
            catch (ConQATException e) {
                LOGGER.error((Object)e);
                throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build(), (Throwable)e);
            }
        }
    }

    private void setCreatorAndCreationDate(List<String> paths, List<String> architectureData, CommitDescriptor artificialUploadCommit) {
        CollectionUtils.forEachWithException(paths, architectureData, (path, architecture) -> {
            try {
                ArchitectureDefinition architectureDefinition = ArchitectureDefinitionReader.read((String)path, (String)architecture);
                architectureDefinition.setCreationAndModificationInfo(ArchitectureCreationModificationInfo.created((String)this.serviceInfo.getUser().getUsername(), (Long)artificialUploadCommit.getTimestamp()));
                architectureData.set(architectureData.indexOf(architecture), ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architectureDefinition, (PublicProjectId)this.serviceInfo.getPrimaryPublicId()));
            }
            catch (ConQATException e) {
                throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build(), (Throwable)e);
            }
        });
    }

    private String ensureArchitectureInXMLFormat(String architectureData) {
        try {
            ArchitectureInfo architectureInfo = (ArchitectureInfo)JsonUtils.deserializeFromJson((String)architectureData, ArchitectureInfo.class);
            ArchitectureDefinition architecture = ArchitectureEditorUtils.writeArchitectureDefinition((ArchitectureInfo)architectureInfo);
            return ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architecture, (PublicProjectId)this.serviceInfo.getPrimaryPublicId());
        }
        catch (ConQATException e) {
            return architectureData;
        }
    }

    private Map<String, String> buildCurrentPathToArchitectureMapping(List<String> paths, CommitDescriptor artificialUploadCommit) throws StorageException {
        HashMap<String, String> pathToArchitecture = new HashMap<String, String>();
        long newestTimestampInContentIndex = this.loadArchitecturesFromContentIndex(paths, artificialUploadCommit, pathToArchitecture);
        List architectureCommits = HistoryUtils.extractCommitDescriptorsFromRawBranchedStore((IBranchingLayer)this.openExternalResultBranchingLayer(), (String)artificialUploadCommit.getBranchName());
        for (ParentedCommitDescriptor commit : architectureCommits) {
            if (commit.getTimestamp() <= newestTimestampInContentIndex || commit.getTimestamp() >= artificialUploadCommit.getTimestamp()) continue;
            ArchitectureUploadInfo commitInfo = (ArchitectureUploadInfo)this.openProjectIndex(ExternalArchitectureUploadIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp())).getCommitInfo();
            for (int i = 0; i < commitInfo.getUniformPaths().size(); ++i) {
                pathToArchitecture.put((String)commitInfo.getUniformPaths().get(i), (String)commitInfo.getArchitectures().get(i));
            }
        }
        return pathToArchitecture;
    }

    private long loadArchitecturesFromContentIndex(List<String> paths, CommitDescriptor uploadCommit, Map<String, String> pathToArchitecture) throws StorageException {
        String branchName = uploadCommit.getBranchName();
        IBranchingLayer branchingLayer = this.openBranchingLayerInProject("content", TokenElementIndex.class);
        IBranchCommitInfo newestCommitInContentIndex = branchingLayer.getNewestCommitBeforeOrAt(branchName, uploadCommit.getTimestamp());
        if (newestCommitInContentIndex == null) {
            return 0L;
        }
        TokenElementIndex contentIndex = new TokenElementIndex(branchingLayer.openStore(HistoryAccessOption.readTimestamp((String)newestCommitInContentIndex.getBranchName(), (long)newestCommitInContentIndex.getTimestamp())));
        pathToArchitecture.putAll(contentIndex.getTokenElements(paths).stream().filter(Objects::nonNull).collect(Collectors.toMap(BasicTokenElementInfo::getUniformPath, BasicTokenElementInfo::getText)));
        return newestCommitInContentIndex.getTimestamp();
    }

    private void insertArchitectureUpload(CommitDescriptor artificialUploadCommit, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType uploadType, ArchitectureUploadInfo uploadInfo, List<String> paths) throws StorageException {
        List<CommitDescriptor> rollbackedCommits;
        CommitDescriptor artificialRollbackCommit = artificialUploadCommit.cloneWithDecrementedTimestamp();
        CommitLayeringBranchingLayer uploadBranchingLayer = this.openExternalResultBranchingLayer();
        List<ArchitectureUploadInfo> rollbackedArchitectureUploadInfos = ArchitectureUploadService.extractArchitectureUploadInfos(uploadBranchingLayer, rollbackedCommits = ArchitectureUploadService.collectCommitsNewerThanCommit(uploadBranchingLayer, artificialRollbackCommit));
        boolean needsRollback = !rollbackedArchitectureUploadInfos.isEmpty();
        this.rollbackArchitectureIndexes(artificialRollbackCommit, uploadBranchingLayer, rollbackedCommits);
        if (uploadInfo != null) {
            this.openExternalArchitectureUploadIndex(artificialUploadCommit).setCommitInfo(uploadInfo);
            this.storeUploadInAnalysisStateIndex(paths, uploadType, artificialUploadCommit);
        }
        ArchitectureUploadService.updateRollbackedEntriesForReplay(artificialUploadCommit, rollbackedCommits, rollbackedArchitectureUploadInfos);
        this.restoreArchitectureUploadStoreData(rollbackedCommits, rollbackedArchitectureUploadInfos);
        this.scheduleArchitectureChangeRetriever(artificialUploadCommit, needsRollback);
    }

    private void storeUploadInAnalysisStateIndex(Collection<String> uniformPaths, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType changeInfo, CommitDescriptor uploadCommit) throws StorageException {
        ArchitectureUploadAnalysisStateIndex analysisStateIndex = this.openProjectIndex(ArchitectureUploadAnalysisStateIndex.class, null);
        for (String path : uniformPaths) {
            analysisStateIndex.setArchitectureUpload(path, uploadCommit, changeInfo);
        }
    }

    private void restoreArchitectureUploadStoreData(List<CommitDescriptor> commits, List<ArchitectureUploadInfo> infos) throws StorageException {
        for (int i = 0; i < commits.size(); ++i) {
            this.openExternalArchitectureUploadIndex(commits.get(i)).setCommitInfo(infos.get(i));
        }
    }

    private void scheduleArchitectureChangeRetriever(CommitDescriptor uploadCommit, boolean rollbackNeeded) throws StorageException {
        ISchedulerCommunicator schedulerCommunicator = ISchedulerCommunicator.getInstance();
        if (rollbackNeeded) {
            CommitDescriptor rollbackCommit = uploadCommit.cloneWithDecrementedTimestamp();
            JobDescriptor rollbackJob = new JobDescriptor(this.serviceInfo.getInternalId(), ForceRollbackTrigger.class, rollbackCommit, "Scheduled due to architecture upload to an older commit.", UUID.randomUUID());
            schedulerCommunicator.scheduleExternalJob(this.getIndexLayer(), rollbackJob);
        }
        schedulerCommunicator.scheduleExternallyStartedTrigger(this.getIndexLayer(), this.serviceInfo.getInternalId(), ExternalArchitectureUploadChangeRetriever.class);
    }

    private void rollbackArchitectureIndexes(CommitDescriptor rollbackCommit, CommitLayeringBranchingLayer uploadStoreBranchingLayer, List<CommitDescriptor> rollbackedCommits) throws StorageException {
        ArchitectureUploadAnalysisStateIndex architectureStateIndex = this.openProjectIndex(ArchitectureUploadAnalysisStateIndex.class, null);
        if (!rollbackedCommits.isEmpty()) {
            uploadStoreBranchingLayer.performRollback(Collections.singletonMap(rollbackCommit.getBranchName(), rollbackCommit.getTimestamp()));
        }
        architectureStateIndex.rollbackTo(rollbackCommit.getBranchName(), rollbackCommit.getTimestamp());
    }

    private ExternalArchitectureUploadIndex openExternalArchitectureUploadIndex(CommitDescriptor uploadCommit) throws StorageException {
        return this.openProjectIndex(ExternalArchitectureUploadIndex.class, HistoryAccessOption.readHeadWriteTimestamp((String)uploadCommit.getBranchName(), (long)uploadCommit.getTimestamp()));
    }

    private static List<ArchitectureUploadInfo> extractArchitectureUploadInfos(CommitLayeringBranchingLayer uploadStoreBranchingLayer, List<CommitDescriptor> newerCommits) throws StorageException {
        return CollectionUtils.mapWithException(newerCommits, commit -> {
            IStore branchedView = uploadStoreBranchingLayer.openStore(HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
            return (ArchitectureUploadInfo)new ExternalArchitectureUploadIndex(branchedView).getCommitInfo();
        });
    }

    @Override
    protected IStore openExternalResultRawStore() throws StorageException {
        return this.openStoreInProject("external-architecture-uploads", ExternalArchitectureUploadIndex.class);
    }

    record ArchitectureInfoWithUniformPath(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="architecture") ArchitectureInfo architecture) {
        private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
        private static final String ARCHITECTURE_PROPERTY = "architecture";
    }
}

