/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.architecture.incremental.FileDependencyCalculator;
import com.teamscale.index.architecture.incremental.TypeDependencyCalculator;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/architectures")
public class ProfileArchitecturePatternPerformanceService
extends ApiBase {
    @GET
    @Path(value="{architecture}/performance")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    @Produces(value={"text/plain"})
    @Operation(summary="Profile architecture pattern performance", description="Measures the performance of every include/exclude pattern of the provided architecture, by matching it against all available types.\nReports the 10 slowest patterns and their runtime.\nCan be used to detect slow patterns in the architecture analysis.\n", tags={"Architecture", "Debugging"})
    public String getArchitecturePerformanceStatistics(@PathParam(value="architecture") UniformPath architecturePath, @QueryParam(value="t") UnresolvedCommitDescriptor commitDescriptor) throws ConQATException {
        if (!architecturePath.isArchitecturePath()) {
            throw new BadRequestException("Provided path '%s' is not an architecture path".formatted(architecturePath));
        }
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)this.resolve(commitDescriptor));
        ArchitectureDefinition architectureDefinition = this.getArchitectureDefinition(architecturePath, historyAccessOption);
        Set<String> types = this.getTypes(architectureDefinition, historyAccessOption);
        PairList<Pattern, Duration> profilingResult = ProfileArchitecturePatternPerformanceService.performProfiling(architectureDefinition, types);
        List<Pair> mostExpensivePatterns = profilingResult.stream().sorted(Comparator.comparing(ImmutablePair::getSecond).reversed()).limit(10L).toList();
        return "List of most expensive patterns:\n" + mostExpensivePatterns.stream().map(p -> String.valueOf(p.getSecond()) + " -> " + String.valueOf(p.getFirst())).collect(Collectors.joining("\n"));
    }

    private ArchitectureDefinition getArchitectureDefinition(UniformPath architecturePath, HistoryAccessOption historyAccessOption) throws ConQATException {
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        TokenElementInfo architecture = contentIndex.getTokenElement(architecturePath.resolveToCodePath());
        if (architecture == null) {
            throw new NotFoundException("Could not find architecture for path '%s'".formatted(architecturePath));
        }
        return ArchitectureDefinitionReader.read((String)architecturePath.toString(), (String)architecture.getText());
    }

    private Set<String> getTypes(ArchitectureDefinition architectureDefinition, HistoryAccessOption historyAccessOption) throws StorageException {
        TypeDependencyIndex typeDependencyIndex = this.openProjectIndex(TypeDependencyIndex.class, historyAccessOption);
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyAccessOption);
        ProjectModuleIndex projectModuleIndex = this.openProjectIndex(ProjectModuleIndex.class, historyAccessOption);
        UnmodifiableList types = typeDependencyIndex.getAllTypeDependencies().getFirstList();
        if (architectureDefinition.isFileBased()) {
            FileDependencyCalculator calculator = new FileDependencyCalculator(typeDependencyIndex, typeIndex, projectModuleIndex);
            PairList typeDependencies = typeDependencyIndex.getTypeDependenciesPerUniformPath((List)types);
            return calculator.createDependencies(typeDependencies).keySet();
        }
        TypeDependencyCalculator calculator = new TypeDependencyCalculator(typeDependencyIndex, typeIndex);
        List typeDependencies = typeDependencyIndex.getTypeDependencies((List)types);
        return calculator.createDependencies(typeDependencies).keySet();
    }

    private static PairList<Pattern, Duration> performProfiling(ArchitectureDefinition architectureDefinition, Set<String> types) {
        PairList timePerPattern = new PairList();
        Iterator iter = architectureDefinition.getAllComponents().stream().flatMap(component -> Stream.concat(component.getIncludePatterns().stream(), component.getExcludePatterns().stream())).distinct().iterator();
        while (iter.hasNext()) {
            Pattern pattern = (Pattern)iter.next();
            Instant start = DateTimeUtils.now();
            for (String type : types) {
                Matcher matcher = pattern.matcher(type);
                matcher.matches();
            }
            Instant end = DateTimeUtils.now();
            timePerPattern.add((Object)pattern, (Object)Duration.between(start, end));
        }
        return timePerPattern;
    }
}

