/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.architecture.ArchitectureEditorUtils;
import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.commons.EPolicyType;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionParser;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/projects/{project}/automation-studio-architecture")
public class StructuredTextArchitectureService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Dimension GENERATED_COMPONENT_DIMENSION = new Dimension(300, 40);
    private static final int X_DISTANCE_BETWEEN_COMPONENTS = 10;
    private static final int Y_DISTANCE_BETWEEN_COMPONENTS = 60;
    private static final String PACKAGE_FILE_NAME = "Package.pkg";
    private static final String PATH_PARAM_DESCRIPTION = "A uniform path to (recursively) search for lby, prg, and pkg files. Defaults to the project root folder (\"\"). We consider only the topmost pkg files and packages that are (transitively) included by them.";
    private static final String TRANSITIVE_DEPENDENCY_PARAMETER_DESCRIPTION = "Whether this service should generate all transitive dependencies that are implied by dependencies in the lby files but that are not explicitly listed in lby files.";
    private static final String IGNORED_LIBRARIES_PARAMETER_DESCRIPTION = "Libraries that are ignored by this service (no components are generated for these libraries and no dependencies from the library are generated). The format of this parameter is a comma-separated list of java regex expressions. For example `LIB_GENERAL,LIB_PARSING_.*`.";
    private static final String INSERT_MISSING_COMPONENTS_PARAMETER_DESCRIPTION = "Whether the service should insert components for packages that are present in the code, but currently not represented in the given architecture. Default value is true.";
    private static final Pattern OBJECT_NAME_PATTERN = Pattern.compile(" ObjectName=\"([^\"]*)\"");

    private static ArchitectureDefinition cloneExistingArchitectureWithoutPolicies(ArchitectureDefinition inputArchitectureDefinition) throws ConQATException {
        ArchitectureDefinition architecture = new ArchitectureDefinition(inputArchitectureDefinition.getName(), inputArchitectureDefinition.isFileBased(), inputArchitectureDefinition.getFindingCreation(), inputArchitectureDefinition.getScopeIncludePattern(), inputArchitectureDefinition.getScopeExcludePattern(), ArchitectureCreationModificationInfo.created((String)"Teamscale", (Long)System.currentTimeMillis()), inputArchitectureDefinition.isLegacyCodeMapping(), inputArchitectureDefinition.isStructureOnly());
        architecture.addConstraints((Collection)inputArchitectureDefinition.getConstraints());
        for (ComponentNode componentData : inputArchitectureDefinition.getSubComponents()) {
            architecture.addSubComponent(StructuredTextArchitectureService.cloneComponent(componentData));
        }
        return architecture;
    }

    private static ComponentNode cloneComponent(ComponentNode inputNode) {
        ComponentNode component = new ComponentNode(inputNode.getName(), inputNode.getPosition(), inputNode.getDimension(), inputNode.getStereotype());
        component.setDescription(inputNode.getDescription());
        inputNode.getIncludePatterns().asStringList().forEach(arg_0 -> ((ComponentNode)component).addIncludePattern(arg_0));
        inputNode.getExcludePatterns().asStringList().forEach(arg_0 -> ((ComponentNode)component).addExcludePattern(arg_0));
        for (ComponentNode subComponent : inputNode.getSubComponents()) {
            component.addSubComponent(StructuredTextArchitectureService.cloneComponent(subComponent));
        }
        return component;
    }

    private static List<Pattern> buildIgnoredLibrariesPatterns(String ignoredLibraryRegexes) {
        String[] libraryRegexes = ignoredLibraryRegexes.split(",");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String regex : libraryRegexes) {
            try {
                patterns.add(Pattern.compile(regex));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Could not compile java regex " + regex, e);
            }
        }
        return patterns;
    }

    private static HashMap<String, ComponentNode> insertComponentsForPackageFiles(BasicTokenElementIndex basicTokenElementIndex, ArchitectureDefinition architectureWithoutPositioning, List<String> pkgPaths, List<Pattern> ignoredLibrariesPatterns) throws StorageException {
        HashMap<String, ComponentNode> componentsByPackageName = new HashMap<String, ComponentNode>();
        HashMap<String, String> createdComponentOrigins = new HashMap<String, String>();
        for (BasicTokenElementInfo element : basicTokenElementIndex.getTokenElements(pkgPaths)) {
            HashMap<String, ComponentNode> createdComponents = new HashMap<String, ComponentNode>();
            for (String libraryName : StructuredTextArchitectureService.extractDeclaredLibraryOrProgramNames(element)) {
                if (createdComponentOrigins.get(libraryName) != null) {
                    LOGGER.warn("found duplicate library name {} in {} and {}", (Object)libraryName, createdComponentOrigins.get(libraryName), (Object)element.getUniformPath());
                    continue;
                }
                if (ignoredLibrariesPatterns.stream().anyMatch(pattern -> pattern.matcher(libraryName).matches())) continue;
                createdComponentOrigins.put(libraryName, element.getUniformPath());
                ComponentNode component = StructuredTextArchitectureService.createComponentNode(element, architectureWithoutPositioning, libraryName, null);
                architectureWithoutPositioning.addSubComponent(component);
                createdComponents.put(libraryName, component);
            }
            componentsByPackageName.putAll(createdComponents);
        }
        return componentsByPackageName;
    }

    private static void insertComponentsForNewPackageFiles(BasicTokenElementIndex basicTokenElementIndex, ArchitectureDefinition architectureWithManualPositioning, List<String> pkgPaths, HashMap<String, ComponentNode> componentsByPackageName, List<Pattern> ignoredLibrariesPatterns) throws StorageException {
        ArrayList<String> newComponentPaths = new ArrayList<String>();
        int newRowY = StructuredTextArchitectureService.getNextEmptyRowYPosition(architectureWithManualPositioning);
        int createdNodesInNewRow = 0;
        for (BasicTokenElementInfo element : basicTokenElementIndex.getTokenElements(pkgPaths)) {
            for (String libraryName : StructuredTextArchitectureService.extractDeclaredLibraryOrProgramNames(element)) {
                if (componentsByPackageName.get(libraryName) != null || ignoredLibrariesPatterns.stream().anyMatch(pattern -> pattern.matcher(libraryName).matches())) continue;
                newComponentPaths.add(element.getUniformPath());
                Point position = new Point(createdNodesInNewRow * StructuredTextArchitectureService.GENERATED_COMPONENT_DIMENSION.width + 10, newRowY);
                ++createdNodesInNewRow;
                ComponentNode component = StructuredTextArchitectureService.createComponentNode(element, architectureWithManualPositioning, libraryName, position);
                architectureWithManualPositioning.addSubComponent(component);
                componentsByPackageName.put(libraryName, component);
            }
        }
        LOGGER.warn("Added new architecture components for these paths:\n{}", (Object)StringUtils.concat((Iterable)CollectionUtils.sort(newComponentPaths), (String)"\n"));
    }

    private static int getNextEmptyRowYPosition(ArchitectureDefinition architectureWithManualPositioning) {
        int maxY = 0;
        for (ComponentNode component : architectureWithManualPositioning.getAllComponents()) {
            int yPosition = component.getPosition().y;
            if (yPosition <= maxY) continue;
            maxY = yPosition;
        }
        return maxY + 60 + StructuredTextArchitectureService.GENERATED_COMPONENT_DIMENSION.height;
    }

    private static void addTransitiveDependencies(ArchitectureDefinition architectureWithoutPositioning) throws ConQATException {
        HashSet toBeProcessed = new HashSet(architectureWithoutPositioning.getAllComponents());
        int addedTransitiveDependencies = 0;
        while (!toBeProcessed.isEmpty()) {
            ComponentNode currentRoot = (ComponentNode)CollectionUtils.getAny(toBeProcessed);
            toBeProcessed.remove(currentRoot);
            for (ComponentNode successor : StructuredTextArchitectureService.getTransitiveSuccessors(currentRoot, architectureWithoutPositioning, new HashSet<ComponentNode>())) {
                if (currentRoot.hasPolicyTo(successor)) continue;
                currentRoot.addPolicy(new DependencyPolicy(currentRoot, successor, EPolicyType.ALLOW_EXPLICIT, null));
                ++addedTransitiveDependencies;
            }
        }
        LOGGER.warn("Added {} transitive dependencies", (Object)addedTransitiveDependencies);
    }

    private static Collection<ComponentNode> getDirectSuccessors(ComponentNode node, ArchitectureDefinition architecture) {
        return architecture.getAllPolicies().stream().filter(dependencyPolicy -> dependencyPolicy.getSource().getName().equals(node.getName())).map(Dependency::getTarget).collect(Collectors.toList());
    }

    private static Set<ComponentNode> getTransitiveSuccessors(ComponentNode currentNode, ArchitectureDefinition architecture, HashSet<ComponentNode> seenNodes) {
        seenNodes.add(currentNode);
        HashSet<ComponentNode> successors = new HashSet<ComponentNode>();
        for (ComponentNode successorNode : StructuredTextArchitectureService.getDirectSuccessors(currentNode, architecture)) {
            successors.add(successorNode);
            if (seenNodes.contains(successorNode)) continue;
            successors.addAll(StructuredTextArchitectureService.getTransitiveSuccessors(successorNode, architecture, seenNodes));
        }
        return successors;
    }

    private static ArchitectureDefinition generateComponentPositions(ArchitectureDefinition architectureWithoutPositioning) throws ConQATException {
        ArchitectureDefinition architecture = StructuredTextArchitectureService.createArchitectureDefinition(architectureWithoutPositioning.getCreationAndModificationInfo());
        Function<ComponentNode, Collection> getSuccessors = component -> StructuredTextArchitectureService.getDirectSuccessors(component, architectureWithoutPositioning);
        Function<ComponentNode, Collection<ComponentNode>> getPredecessors = component -> architectureWithoutPositioning.getAllPolicies().stream().filter(dependencyPolicy -> dependencyPolicy.getTarget().getName().equals(component.getName())).map(Dependency::getSource).collect(Collectors.toList());
        Pair topSortResult = CollectionUtils.topSort((Collection)architectureWithoutPositioning.getAllComponents(), getSuccessors);
        LOGGER.warn("Found dependency cycles involving these nodes: {}", (Object)((Set)topSortResult.getSecond()).stream().map(ComponentNode::getName).collect(Collectors.joining(", ")));
        ArrayDeque<ComponentNode> sortedComponents = new ArrayDeque<ComponentNode>((Collection)topSortResult.getFirst());
        HashSet<ComponentNode> addedComponents = new HashSet<ComponentNode>();
        int yPosition = 0;
        while (!sortedComponents.isEmpty()) {
            List<ComponentNode> toAddInThisRow = StructuredTextArchitectureService.getComponentsForNewRow(getPredecessors, sortedComponents, addedComponents);
            for (int i = 0; i < toAddInThisRow.size(); ++i) {
                Point position = new Point(i * StructuredTextArchitectureService.GENERATED_COMPONENT_DIMENSION.width + 10, yPosition);
                ComponentNode compWithoutPosition = toAddInThisRow.get(i);
                ComponentNode compWithPosition = new ComponentNode(compWithoutPosition.getName(), position, new Dimension(GENERATED_COMPONENT_DIMENSION), compWithoutPosition.getStereotype());
                for (String includeRegex : compWithoutPosition.getIncludePatterns().asStringList()) {
                    compWithPosition.addIncludePattern(includeRegex);
                }
                architecture.addSubComponent(compWithPosition);
                addedComponents.add(compWithoutPosition);
            }
            yPosition += 60 + StructuredTextArchitectureService.GENERATED_COMPONENT_DIMENSION.height;
        }
        for (DependencyPolicy policy : architectureWithoutPositioning.getSortedPolicies()) {
            architecture.getComponentByName(policy.getSource().getName()).addPolicy(new DependencyPolicy(architecture.getComponentByName(policy.getSource().getName()), architecture.getComponentByName(policy.getTarget().getName()), policy.getType(), (List)policy.getPoints()));
        }
        return architecture;
    }

    private static List<ComponentNode> getComponentsForNewRow(Function<ComponentNode, Collection<ComponentNode>> getPredecessors, Deque<ComponentNode> sortedComponents, Set<ComponentNode> addedComponents) {
        Collection<ComponentNode> predecessors;
        ArrayList<ComponentNode> componentsForNewRow = new ArrayList<ComponentNode>();
        while (!sortedComponents.isEmpty() && addedComponents.containsAll(predecessors = getPredecessors.apply(sortedComponents.peek()))) {
            componentsForNewRow.add(sortedComponents.pop());
        }
        return componentsForNewRow;
    }

    private static ArchitectureDefinition createEmptyArchitecture() throws ConQATException {
        ArchitectureCreationModificationInfo creationInfo = ArchitectureCreationModificationInfo.created((String)"Teamscale", (Long)System.currentTimeMillis());
        return StructuredTextArchitectureService.createArchitectureDefinition(creationInfo);
    }

    private static ArchitectureDefinition createArchitectureDefinition(ArchitectureCreationModificationInfo creationInfo) throws ConQATException {
        return new ArchitectureDefinition("lby_arch.architecture", true, EFindingCreationType.NONE, "", "", creationInfo);
    }

    private static List<String> collectRelevantLibraryPaths(BasicTokenElementIndex basicTokenElementIndex, List<String> pkgPaths, Set<String> allLbyPaths) throws StorageException {
        ArrayList<String> relevantLbyPaths = new ArrayList<String>();
        for (String pkgPath : pkgPaths) {
            BasicTokenElementInfo element = basicTokenElementIndex.getTokenElement(pkgPath);
            for (String line : StringUtils.splitLines((String)element.getText())) {
                Optional<String> declaredLibraryName = StructuredTextArchitectureService.extractDeclaredLibraryOrProgramNameFromLine(line);
                if (declaredLibraryName.isEmpty()) continue;
                String libraryName = declaredLibraryName.get();
                String potentialLbyPath = StringUtils.stripSuffix((String)pkgPath, (String)"/Package.pkg") + "/" + libraryName + "/IEC.lby";
                if (allLbyPaths.contains(potentialLbyPath)) {
                    relevantLbyPaths.add(potentialLbyPath);
                }
                if (!allLbyPaths.contains(potentialLbyPath = StringUtils.stripSuffix((String)pkgPath, (String)"/Package.pkg") + "/" + libraryName + "/Binary.lby")) continue;
                relevantLbyPaths.add(potentialLbyPath);
            }
        }
        return relevantLbyPaths;
    }

    private static List<String> collectRelevantPackagePaths(BasicTokenElementIndex basicTokenElementIndex, List<String> allPaths) throws StorageException {
        List pkgPaths = CollectionUtils.filter(allPaths, path -> path.endsWith(".pkg"));
        ArrayList<String> relevantPackagePaths = new ArrayList<String>();
        HashSet<String> pkgPathsSet = new HashSet<String>(pkgPaths);
        for (String rootPkgFilePath : StructuredTextArchitectureService.determineRootPkgPaths(pkgPaths)) {
            relevantPackagePaths.add(rootPkgFilePath);
            relevantPackagePaths.addAll(StructuredTextArchitectureService.collectRelevantSubPackageFilesInPackage(rootPkgFilePath, basicTokenElementIndex, pkgPathsSet));
        }
        return relevantPackagePaths;
    }

    private static List<String> collectRelevantSubPackageFilesInPackage(String rootPkgFilePath, BasicTokenElementIndex basicTokenElementIndex, Set<String> allPkgPaths) throws StorageException {
        ArrayList<String> relevantPaths = new ArrayList<String>();
        String pkgFileContents = basicTokenElementIndex.getTokenElement(rootPkgFilePath).getText();
        String pkgFolder = StringUtils.stripSuffix((String)rootPkgFilePath, (String)PACKAGE_FILE_NAME);
        for (String subPackageName : StructuredTextArchitectureService.extractSubPackageNames(pkgFileContents)) {
            String potentialSubPkgPath = pkgFolder + subPackageName + "/Package.pkg";
            if (!allPkgPaths.contains(potentialSubPkgPath)) continue;
            relevantPaths.add(potentialSubPkgPath);
            relevantPaths.addAll(StructuredTextArchitectureService.collectRelevantSubPackageFilesInPackage(potentialSubPkgPath, basicTokenElementIndex, allPkgPaths));
        }
        return relevantPaths;
    }

    private static List<String> determineRootPkgPaths(List<String> pkgPaths) {
        HashSet<String> rootPkgFolders = new HashSet<String>();
        ArrayList<String> rootPkgPaths = new ArrayList<String>();
        for (String pkgPath : CollectionUtils.sort(pkgPaths, Comparator.comparingInt(path -> StringUtils.countCharacter((String)path, (char)'/')))) {
            if (!pkgPath.endsWith("/Package.pkg")) continue;
            String pkgFolderPath = StringUtils.stripSuffix((String)pkgPath, (String)PACKAGE_FILE_NAME);
            List<String> parentPaths = StructuredTextArchitectureService.determineAllParentFolderPaths(pkgFolderPath);
            if (!CollectionUtils.intersectionSet(rootPkgFolders, (Collection[])new Collection[]{parentPaths}).isEmpty()) continue;
            rootPkgFolders.add(pkgFolderPath);
            rootPkgPaths.add(pkgPath);
        }
        return rootPkgPaths;
    }

    private static List<String> determineAllParentFolderPaths(String pkgFolderPath) {
        List<String> segments = Arrays.asList(FileSystemUtils.getPathSegments((String)pkgFolderPath));
        ArrayList<String> parentPaths = new ArrayList<String>();
        for (int i = 1; i < segments.size(); ++i) {
            String parentPath = StringUtils.concat(segments.subList(0, i), (String)"/");
            parentPaths.add(parentPath + "/");
        }
        return parentPaths;
    }

    private static void insertDependencyFromLibraryFile(BasicTokenElementInfo element, ArchitectureDefinition architecture, HashMap<String, ComponentNode> createdComponents, List<Pattern> ignoredLibrariesPatterns) throws ConQATException {
        String[] pathSegments = FileSystemUtils.getPathSegments((String)element.getUniformPath());
        String packageName = pathSegments[pathSegments.length - 2];
        ComponentNode currentComponent = createdComponents.get(packageName);
        if (currentComponent == null) {
            LOGGER.warn("ignoring dependencies from package {}", (Object)packageName);
            return;
        }
        String prefix = "<Dependency ObjectName=\"";
        String suffix = "\" />";
        int nextRowY = StructuredTextArchitectureService.getNextEmptyRowYPosition(architecture);
        for (String line : StringUtils.splitLines((String)element.getText())) {
            if (!(line = line.trim()).startsWith(prefix) || !line.endsWith(suffix)) continue;
            Matcher matcher = OBJECT_NAME_PATTERN.matcher(line);
            if (!matcher.find()) {
                LOGGER.error("Could not parse object name from line \"{}\" in {}", (Object)line, (Object)element.getUniformPath());
                continue;
            }
            String dependencyTargetName = matcher.group(1);
            ComponentNode targetComponent = createdComponents.get(dependencyTargetName);
            if (targetComponent == null && ignoredLibrariesPatterns.stream().anyMatch(pattern -> pattern.matcher(dependencyTargetName).matches())) continue;
            if (targetComponent == null) {
                Point position = new Point(10, nextRowY);
                targetComponent = new ComponentNode(dependencyTargetName, position, new Dimension(20, 40), EStereotype.NONE);
                architecture.addSubComponent(targetComponent);
                createdComponents.put(dependencyTargetName, targetComponent);
            }
            if (currentComponent.getPolicyTo(targetComponent) != null) {
                LOGGER.warn("Duplicate dependency to {} in {}", (Object)dependencyTargetName, (Object)element.getUniformPath());
                continue;
            }
            currentComponent.addPolicy(new DependencyPolicy(currentComponent, targetComponent, EPolicyType.ALLOW_EXPLICIT, null));
        }
    }

    private static List<String> extractDeclaredLibraryOrProgramNames(BasicTokenElementInfo element) {
        ArrayList<String> libraryNames = new ArrayList<String>();
        for (String line : StringUtils.splitLines((String)element.getText())) {
            Optional<String> declaredLibraryName = StructuredTextArchitectureService.extractDeclaredLibraryOrProgramNameFromLine(line);
            if (!declaredLibraryName.isPresent()) continue;
            libraryNames.add(declaredLibraryName.get());
        }
        return libraryNames;
    }

    private static Optional<String> extractDeclaredLibraryOrProgramNameFromLine(String line) {
        if ((line = line.trim()).startsWith("<Object Type=\"Library\"") && line.endsWith("</Object>")) {
            String libraryName = StringUtils.stripSuffix((String)line, (String)"</Object>");
            return Optional.of(libraryName.substring(libraryName.lastIndexOf(">") + 1));
        }
        if (line.startsWith("<Object Type=\"Program\"") && line.endsWith("</Object>")) {
            String programName = StringUtils.stripSuffix((String)line, (String)"</Object>");
            return Optional.of(programName.substring(programName.lastIndexOf(">") + 1));
        }
        return Optional.empty();
    }

    private static ComponentNode createComponentNode(BasicTokenElementInfo element, ArchitectureDefinition architecture, String libraryName, Point position) {
        if (position == null) {
            int numberOfComponents = architecture.getAllComponents().size();
            position = new Point(0, numberOfComponents * StructuredTextArchitectureService.GENERATED_COMPONENT_DIMENSION.width + 10);
        }
        ComponentNode component = new ComponentNode(libraryName, position, new Dimension(GENERATED_COMPONENT_DIMENSION), EStereotype.NONE);
        component.addIncludePattern(StringUtils.stripSuffix((String)element.getUniformPath(), (String)FileSystemUtils.getLastPathSegment((String)element.getUniformPath())) + libraryName + "/.*");
        return component;
    }

    private static List<String> extractSubPackageNames(String pkgFileContent) {
        ArrayList<String> subPackageNames = new ArrayList<String>();
        for (String line : StringUtils.splitLines((String)pkgFileContent)) {
            if (!(line = line.trim()).startsWith("<Object Type=\"Package\"") || !line.endsWith("</Object>")) continue;
            String subPackageName = StringUtils.stripSuffix((String)line, (String)"</Object>");
            subPackageName = subPackageName.substring(subPackageName.lastIndexOf(">") + 1);
            subPackageNames.add(subPackageName);
        }
        return subPackageNames;
    }

    @GET
    @Operation(summary="Generate a new architecture", description="Generates a Structured-Text-Code architecture from .lby, .prg, and .pkg files in an B&R Automation Studio project", tags={"Source Code"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Response generateNewArchitecture(@Parameter(description="A uniform path to (recursively) search for lby, prg, and pkg files. Defaults to the project root folder (\"\"). We consider only the topmost pkg files and packages that are (transitively) included by them.") @QueryParam(value="uniform-path") @DefaultValue(value="") UniformPath uniformPath, @Parameter(description="Whether this service should generate all transitive dependencies that are implied by dependencies in the lby files but that are not explicitly listed in lby files.") @QueryParam(value="generate-transitive-dependencies") @DefaultValue(value="true") boolean generateTransitiveDependencies, @Parameter(description="Libraries that are ignored by this service (no components are generated for these libraries and no dependencies from the library are generated). The format of this parameter is a comma-separated list of java regex expressions. For example `LIB_GENERAL,LIB_PARSING_.*`.") @QueryParam(value="ignored-libraries") @DefaultValue(value="") String ignoredLibraries, @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws ConQATException {
        BasicTokenElementIndex basicTokenElementIndex = this.openProjectIndex(BasicTokenElementIndex.class, this.determineHistoryOption(commit));
        List allPaths = basicTokenElementIndex.getUniformPathsStartingWith(uniformPath.toString());
        ArchitectureDefinition architectureWithoutPositioning = StructuredTextArchitectureService.createEmptyArchitecture();
        List<String> pkgPaths = StructuredTextArchitectureService.collectRelevantPackagePaths(basicTokenElementIndex, allPaths);
        List<Pattern> ignoredLibrariesPatterns = StructuredTextArchitectureService.buildIgnoredLibrariesPatterns(ignoredLibraries);
        LOGGER.info("Generation step considers these package files: \n{}", (Object)StringUtils.concat(pkgPaths, (String)"\n"));
        HashMap<String, ComponentNode> componentsByPackageName = StructuredTextArchitectureService.insertComponentsForPackageFiles(basicTokenElementIndex, architectureWithoutPositioning, pkgPaths, ignoredLibrariesPatterns);
        List<String> lbyPaths = StructuredTextArchitectureService.collectRelevantLibraryPaths(basicTokenElementIndex, pkgPaths, new HashSet<String>(CollectionUtils.filter((Collection)allPaths, path -> path.endsWith(".lby"))));
        LOGGER.info("Generation step considers these library files: \n{}", (Object)StringUtils.concat(lbyPaths, (String)"\n"));
        for (BasicTokenElementInfo element : basicTokenElementIndex.getTokenElements(lbyPaths)) {
            StructuredTextArchitectureService.insertDependencyFromLibraryFile(element, architectureWithoutPositioning, componentsByPackageName, ignoredLibrariesPatterns);
        }
        if (generateTransitiveDependencies) {
            StructuredTextArchitectureService.addTransitiveDependencies(architectureWithoutPositioning);
        }
        ArchitectureDefinition architecture = StructuredTextArchitectureService.generateComponentPositions(architectureWithoutPositioning);
        this.validateArchitecture(architecture);
        return this.wrapInResponse(architecture);
    }

    @POST
    @Operation(summary="Update dependencies in a given architecture", description="Updates dependencies in a given architecture (generated by the new-architecture service) with dependencies and (optionally) packages from the current repository state", tags={"Source Code"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"application/xml", "text/xml"})
    @Consumes(value={"multipart/form-data"})
    public Response updateArchitecture(@Parameter(description="A uniform path to (recursively) search for lby, prg, and pkg files. Defaults to the project root folder (\"\"). We consider only the topmost pkg files and packages that are (transitively) included by them.") @QueryParam(value="uniform-path") @DefaultValue(value="") UniformPath uniformPath, @Parameter(description="Whether this service should generate all transitive dependencies that are implied by dependencies in the lby files but that are not explicitly listed in lby files.") @QueryParam(value="generate-transitive-dependencies") @DefaultValue(value="true") boolean generateTransitiveDependencies, @Parameter(description="Libraries that are ignored by this service (no components are generated for these libraries and no dependencies from the library are generated). The format of this parameter is a comma-separated list of java regex expressions. For example `LIB_GENERAL,LIB_PARSING_.*`.") @QueryParam(value="ignored-libraries") @DefaultValue(value="") String ignoredLibraries, @Parameter(description="Whether the service should insert components for packages that are present in the code, but currently not represented in the given architecture. Default value is true.") @QueryParam(value="insert-missing-components") @DefaultValue(value="true") boolean insertMissingComponents, @Parameter(required=true, schema=@Schema(type="string", format="binary"), description="The existing architecture file that should be updated based on current pkg and lby files in the repository. We primarily reuse the component positions from this existing architecture.") @FormDataParam(value="data") FormDataBodyPart architecture, @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws ConQATException, IOException {
        String architectureInfoString = StructuredTextArchitectureService.readBodyPart((BodyPart)architecture);
        ArchitectureDefinition inputArchitectureDefinition = new ArchitectureDefinitionParser("updated architecture", architectureInfoString).parse();
        BasicTokenElementIndex basicTokenElementIndex = this.openProjectIndex(BasicTokenElementIndex.class, this.determineHistoryOption(commit));
        ArchitectureDefinition architectureWithManualPositioning = StructuredTextArchitectureService.cloneExistingArchitectureWithoutPolicies(inputArchitectureDefinition);
        List allPaths = basicTokenElementIndex.getUniformPathsStartingWith(uniformPath.toString());
        List<String> pkgPaths = StructuredTextArchitectureService.collectRelevantPackagePaths(basicTokenElementIndex, allPaths);
        List<Pattern> ignoredLibrariesPatterns = StructuredTextArchitectureService.buildIgnoredLibrariesPatterns(ignoredLibraries);
        LOGGER.info("Generation step considers these package files: \n{}", (Object)StringUtils.concat(pkgPaths, (String)"\n"));
        HashMap<String, ComponentNode> componentsByPackageName = new HashMap<String, ComponentNode>();
        for (ComponentNode component : architectureWithManualPositioning.getAllComponents()) {
            componentsByPackageName.put(StringUtils.getLastPart((String)component.getName(), (String)"/"), component);
        }
        if (insertMissingComponents) {
            StructuredTextArchitectureService.insertComponentsForNewPackageFiles(basicTokenElementIndex, architectureWithManualPositioning, pkgPaths, componentsByPackageName, ignoredLibrariesPatterns);
        }
        List<String> lbyPaths = StructuredTextArchitectureService.collectRelevantLibraryPaths(basicTokenElementIndex, pkgPaths, new HashSet<String>(CollectionUtils.filter((Collection)allPaths, path -> path.endsWith(".lby"))));
        LOGGER.info("Generation step considers these library files: \n{}", (Object)StringUtils.concat(lbyPaths, (String)"\n"));
        for (BasicTokenElementInfo element : basicTokenElementIndex.getTokenElements(lbyPaths)) {
            StructuredTextArchitectureService.insertDependencyFromLibraryFile(element, architectureWithManualPositioning, componentsByPackageName, ignoredLibrariesPatterns);
        }
        if (generateTransitiveDependencies) {
            StructuredTextArchitectureService.addTransitiveDependencies(architectureWithManualPositioning);
        }
        this.validateArchitecture(architectureWithManualPositioning);
        return this.wrapInResponse(architectureWithManualPositioning);
    }

    private void validateArchitecture(ArchitectureDefinition architecture) {
        try {
            String archXML = ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architecture, (PublicProjectId)this.serviceInfo.getPrimaryPublicId());
            ArchitectureDefinitionParser architectureParser = new ArchitectureDefinitionParser(architecture.getName(), archXML);
            architectureParser.parse();
        }
        catch (ConQATException e) {
            LOGGER.error("Could not validate generated architecture (parsing failed)", (Throwable)e);
        }
    }

    private Response wrapInResponse(ArchitectureDefinition architecture) {
        byte[] entity = StringUtils.stringToBytes((String)ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architecture, (PublicProjectId)this.serviceInfo.getPrimaryPublicId()));
        String fileName = architecture.getName() + ".architecture";
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MediaType.TEXT_XML_TYPE, (String)fileName);
    }
}

