/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.service.audit.EAuditExportTable;
import com.teamscale.service.audit.EAuditMessageKey;
import com.teamscale.service.audit.LatexTableExportServiceBase;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/audit/latex-table")
public class LatexTableSingleProjectExportService
extends LatexTableExportServiceBase {
    @GET
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    @Operation(summary="Export Latex metric table", description="Service for exporting Latex tables containing metrics for the project.", tags={"Audit"})
    public String getSingleProjectLatexTable(@BeanParam LatexTableExportServiceBase.LatexTableExportParameters parameters, @Parameter(description="The uniform path for which metrics should be returned.", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        StringBuilder stringBuilder = new StringBuilder();
        ProjectDataAccessor accessor = this.createProjectDataAccessor(this.serviceInfo.getPrimaryPublicId().toString(), parameters.language.getMessage(EAuditMessageKey.APPLICATION_PROJECT), uniformPath);
        for (EAuditExportTable metric : parameters.metrics) {
            stringBuilder.append(LatexTableSingleProjectExportService.getLatexTable(metric, parameters.language, accessor, new ProjectDataAccessor[0])).append("\n\n");
        }
        return stringBuilder.toString();
    }
}

