/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.audit.ExceptionsHierarchyServiceBase;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTree;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTreeEdge;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTreeManager;
import com.teamscale.service.audit.exceptions_hierarchy.ILanguageSpecificExceptionSupport;
import com.teamscale.service.audit.exceptions_hierarchy.LanguageSpecificExceptionSupportFactory;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/exceptions-hierarchy/object")
public class ObjectExceptionsHierarchyService
extends ExceptionsHierarchyServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get exception hierarchies", description="Retrieves hierarchies of custom exceptions represented as objects.", tags={"Audit"})
    public List<List<ExceptionsTree>> getExceptionsHierarchyTree(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        ArrayList<List<ExceptionsTree>> hierarchies = new ArrayList<List<ExceptionsTree>>();
        for (ELanguage language : this.getProjectLanguages(commit)) {
            List<ExceptionsTree> hierarchy = this.getExceptionsHierarchyTree(language);
            hierarchies.add(hierarchy);
        }
        return hierarchies;
    }

    private List<ExceptionsTree> getExceptionsHierarchyTree(ELanguage language) throws StorageException {
        Optional<ILanguageSpecificExceptionSupport> languageSupport = LanguageSpecificExceptionSupportFactory.getForLanguage(language);
        if (languageSupport.isEmpty()) {
            LOGGER.warn("Exception hierarchy analysis is not implemented for language {}", (Object)language.getReadableName());
            return Collections.emptyList();
        }
        List<ExceptionsTreeEdge> exceptionEdgesFromProject = this.getExceptionTreeEdgesFromProject(language);
        ExceptionsTreeManager exceptionsTreeManager = new ExceptionsTreeManager(languageSupport.get());
        return exceptionsTreeManager.createExceptionsTree(exceptionEdgesFromProject);
    }
}

