/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.latex;

import com.teamscale.service.audit.EAuditExportLanguage;
import com.teamscale.service.audit.EAuditMessageKey;
import com.teamscale.service.audit.latex.LatexTableCreatorBase;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class StructureMetricAssessmentTableCreator
extends LatexTableCreatorBase {
    private final String assessmentMetric;
    private final String analysisGroup;
    private final String findingTypeId;

    public StructureMetricAssessmentTableCreator(String assessmentMetric, String analysisGroup, String findingTypeId, EAuditExportLanguage language, ProjectDataAccessor mainAccessor, ProjectDataAccessor ... projectDataAccessors) {
        super(language, mainAccessor, projectDataAccessors);
        this.assessmentMetric = assessmentMetric;
        this.analysisGroup = analysisGroup;
        this.findingTypeId = findingTypeId;
    }

    @Override
    protected String getTableContent() throws StorageException {
        Object result = this.getColumnHeaders();
        result = (String)result + this.getTableContentGreen();
        result = (String)result + this.getTableContentYellow();
        result = (String)result + this.getTableContentRed();
        result = (String)result + this.getTableContentSum();
        return result;
    }

    protected String getAssessmentValuesInDoubleColumn(Assessment assessment, ETrafficLightColor color) {
        return this.formatDouble(assessment.getColorFrequency(color)) + " & " + this.getPercentageFromDouble((double)assessment.getColorFrequency(color) / (double)assessment.getSize());
    }

    protected String getSumValueAndIndicator(Assessment assessment) {
        double relativeValueRed = (double)assessment.getColorFrequency(ETrafficLightColor.RED) / (double)assessment.getSize();
        double relativeValueYellow = (double)assessment.getColorFrequency(ETrafficLightColor.YELLOW) / (double)assessment.getSize();
        return " & " + this.formatDouble(assessment.getSize()) + " & \\incellassessment{" + StructureMetricAssessmentTableCreator.formatDoubleForInCellAssessment(relativeValueRed) + "}{" + StructureMetricAssessmentTableCreator.formatDoubleForInCellAssessment(relativeValueYellow) + "}";
    }

    protected String getIntervalColumns(ETrafficLightColor color, ProjectDataAccessor projectIndizes) throws StorageException {
        Object result = "";
        int yellowThreshold = (Integer)projectIndizes.getAssessmentThresholds(this.assessmentMetric).getFirst();
        int redThreshold = (Integer)projectIndizes.getAssessmentThresholds(this.assessmentMetric).getSecond();
        switch (color) {
            case GREEN: {
                result = (String)result + "0 & -- & " + yellowThreshold + " & \\green";
                break;
            }
            case YELLOW: {
                result = (String)result + (yellowThreshold + 1) + " & -- & " + redThreshold + " & \\yellow";
                break;
            }
            case RED: {
                result = (String)result + (redThreshold + 1) + " & -- & " + projectIndizes.getMaxValue(this.findingTypeId, this.assessmentMetric) + " & \\red";
                break;
            }
            default: {
                CCSMAssert.fail((String)("Unknown color: " + String.valueOf(color)));
            }
        }
        return result;
    }

    @Override
    protected String getLabel() {
        switch (this.assessmentMetric) {
            case "File Size Assessment": {
                return "tab:file-size";
            }
            case "Method Length Assessment": {
                return "tab:method-length";
            }
            case "Nesting Depth Assessment": {
                return "tab:nesting-depth";
            }
        }
        StructureMetricAssessmentTableCreator.failWithUnsupportedMetricMessage(this.assessmentMetric);
        return null;
    }

    @Override
    protected String getName() {
        switch (this.assessmentMetric) {
            case "File Size Assessment": {
                return this.getMessage(EAuditMessageKey.FILE_SIZE_METRIC);
            }
            case "Method Length Assessment": {
                return this.getMessage(EAuditMessageKey.METHOD_LENGTH_METRIC);
            }
            case "Nesting Depth Assessment": {
                return this.getMessage(EAuditMessageKey.NESTING_DEPTH_METRIC);
            }
        }
        StructureMetricAssessmentTableCreator.failWithUnsupportedMetricMessage(this.assessmentMetric);
        return null;
    }

    private static void failWithUnsupportedMetricMessage(String assessmentMetric) {
        CCSMAssert.fail((String)("Unsupported assessment metric: " + assessmentMetric));
    }

    @Override
    protected String getColumnDefinition() {
        return "\\begin{tabular}{r>{\\hspace{-3pt}}c<{\\hspace{-3pt}}rr" + StringUtils.repeat((String)"rr", (int)this.projectDataAcessors.length) + "} \\toprule \n";
    }

    protected String getColumnHeaders() {
        StringBuilder builder = new StringBuilder();
        builder.append("\\multicolumn{4}{l}{{").append(this.getName()).append(" [SLOC]}} ").append(StringUtils.repeat((String)"& {SLOC} & {SLOC [\\%]} ", (int)this.projectDataAcessors.length)).append("\\\\ \\midrule \n");
        return builder.toString();
    }

    @Override
    protected String getTableColumns() {
        StringBuilder builder = new StringBuilder();
        builder.append(" & & &");
        for (ProjectDataAccessor accessor : this.projectDataAcessors) {
            builder.append(" & \\multicolumn{2}{c}{\\ctextbf{" + String.valueOf(accessor.getProjectAlias()) + "}}");
        }
        builder.append(" \\\\ \\midrule \n");
        return builder.toString();
    }

    protected String getTableContentRed() throws StorageException {
        return this.getTableContentLineForColor(ETrafficLightColor.RED);
    }

    protected String getTableContentYellow() throws StorageException {
        return this.getTableContentLineForColor(ETrafficLightColor.YELLOW);
    }

    private String getTableContentLineForColor(ETrafficLightColor color) throws StorageException {
        String[] assessments = new String[this.projectDataAcessors.length];
        for (int i = 0; i < this.projectDataAcessors.length; ++i) {
            this.setAssessmentText(color, assessments, i, this.projectDataAcessors[i]);
        }
        return StructureMetricAssessmentTableCreator.createTableRow(this.getLabel(color), assessments);
    }

    private String getLabel(ETrafficLightColor color) throws StorageException {
        if (this.isMetricEnabled(this.mainProjectAccessor)) {
            return this.getIntervalColumns(color, this.getProjectDataAccessorForLabel());
        }
        return " disabled & -- & disabled ";
    }

    private ProjectDataAccessor getProjectDataAccessorForLabel() {
        int indexForIntervalCalculation = 0;
        int redValueMax = 0;
        for (int i = 0; i < this.projectDataAcessors.length; ++i) {
            ProjectDataAccessor accessor = this.projectDataAcessors[i];
            int redValue = (Integer)accessor.getAssessmentThresholds(this.assessmentMetric).getSecond();
            if (redValue <= redValueMax) continue;
            redValueMax = redValue;
            indexForIntervalCalculation = i;
        }
        return this.projectDataAcessors[indexForIntervalCalculation];
    }

    private void setAssessmentText(ETrafficLightColor color, String[] assessments, int index, ProjectDataAccessor accessor) {
        if (this.isMetricEnabled(accessor)) {
            Assessment assessment = accessor.getAssessmentMetricValue(this.assessmentMetric);
            assessments[index] = this.getAssessmentValuesInDoubleColumn(assessment, color);
        } else {
            StructureMetricAssessmentTableCreator.logMetricDisabledWarning(accessor, this.assessmentMetric);
            assessments[index] = "disabled";
        }
    }

    private boolean isMetricEnabled(ProjectDataAccessor accessor) {
        return accessor.isMetricEnabled(this.analysisGroup, this.assessmentMetric);
    }

    private String getTableContentGreen() throws StorageException {
        return this.getTableContentLineForColor(ETrafficLightColor.GREEN);
    }

    private String getSumLabel() {
        return "\\ctextbf{" + this.getMessage(EAuditMessageKey.STRUCTURE_METRIC_SUM) + "}}";
    }

    private String getTableContentSum() {
        StringBuilder builder = new StringBuilder("\\midrule\n\\multicolumn{4}{l}{");
        builder.append(this.getSumLabel());
        for (ProjectDataAccessor accessor : this.projectDataAcessors) {
            if (this.isMetricEnabled(accessor)) {
                builder.append(this.getSumValueAndIndicator(accessor.getAssessmentMetricValue(this.assessmentMetric)));
                continue;
            }
            builder.append(" & disabled & disabled");
        }
        builder.append(" \\\\ \\bottomrule \n");
        return builder.toString();
    }

    @Override
    protected boolean shouldPrintTableColumns() {
        return this.projectDataAcessors.length > 1;
    }
}

