/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.openid.OpenIdAuthenticationOption;
import com.teamscale.core.authenticate.openid.OpenIdSessionIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="logout")
public class LogoutService
extends ApiBase {
    @Context
    private ContainerRequestContext requestContext;

    @GET
    @RequiresNoLogin
    @Operation(summary="Log out", description="Performs a logout of the currently logged in user by invalidating the current session.", responses={@ApiResponse(responseCode="303", description="Redirect to login page")})
    public Response logout() throws StorageException {
        User user = this.serviceInfo.getAuthenticationRequestHandler().authenticate(this.requestContext, null);
        Response.ResponseBuilder response = this.buildLogoutResponse(user);
        SessionIndex sessionIndex = this.openGlobalIndex(SessionIndex.class);
        this.serviceInfo.getAuthenticationRequestHandler().removeSessionCookie(this.requestContext, response, sessionIndex, this.serviceInfo.getMessageBroker(), this.serviceInfo.getRequestBaseUri());
        if (this.serviceInfo.getServerConfiguration().isServiceLogIncludeUsers()) {
            AuditLogs.userLogout((String)user.getUsername());
        }
        return response.build();
    }

    private Response.ResponseBuilder buildLogoutResponse(User user) throws StorageException {
        Response.ResponseBuilder defaultResponse = this.createRedirectResponseBuilder("login");
        if (user == null) {
            return defaultResponse;
        }
        OpenIdSessionIndex openIdSessionIndex = this.openGlobalIndex(OpenIdSessionIndex.class);
        Optional loginData = openIdSessionIndex.getLoginDataForUser(user.getUsername());
        if (loginData.isEmpty()) {
            return defaultResponse;
        }
        String authenticatorName = ((OpenIdSessionIndex.LoginData)loginData.get()).getAuthenticatorName();
        if (authenticatorName == null) {
            return defaultResponse;
        }
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        OpenIdAuthenticationOption connectOption = (OpenIdAuthenticationOption)AuthenticationToolUtils.determineConnectOption((String)ESsoAuthenticatorType.OPENID_CONNECT.getOptionId(), (String)authenticatorName, (ServerOptionIndex)optionIndex, OpenIdAuthenticationOption.class).getSecond();
        if (connectOption == null || !connectOption.getUseEndSessionEndpoint() || StringUtils.isEmpty((String)connectOption.getEndSessionEndpoint())) {
            return defaultResponse;
        }
        return Response.seeOther((URI)this.buildOpenIdConnectLogoutUri(connectOption, (OpenIdSessionIndex.LoginData)loginData.get()));
    }

    private URI buildOpenIdConnectLogoutUri(OpenIdAuthenticationOption connectOption, OpenIdSessionIndex.LoginData loginData) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)connectOption.getEndSessionEndpoint());
        if (loginData.getIdToken().isPresent()) {
            uriBuilder = uriBuilder.queryParam("id_token_hint", new Object[]{loginData.getIdToken().get()});
        }
        uriBuilder.queryParam("post_logout_redirect_uri", new Object[]{this.createRedirectUri("login")});
        return uriBuilder.build(new Object[0]);
    }
}

