/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.commit_alert.CommitAlert;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlertWithCommit;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.commits.CommitAlertsFilterOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/commit-alerts")
public class CommitAlertsService
extends ApiBase {
    @GET
    @Operation(summary="Get commit alerts", description="Provides access to the alerts for the given commits.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<@NonNull CommitAlertWithCommit> getCommitAlerts(@BeanParam CommitAlertsFilterOptions alertFilterOptions, @QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits) throws StorageException {
        List<CommitDescriptor> commitDescriptors = this.resolveCommits(commits);
        List alertsByCommit = this.openProjectIndex(CommitAlertIndex.class, null).getEntries(commitDescriptors);
        IncludeExcludeAntPatternSupport includeExcludePattern = new IncludeExcludeAntPatternSupport(true, alertFilterOptions.getIncludedPaths(), CollectionUtils.emptyIfNull(alertFilterOptions.getExcludedPaths()));
        ArrayList<CommitAlertWithCommit> result = new ArrayList<CommitAlertWithCommit>();
        for (CommitAlerts commitAlerts : alertsByCommit) {
            if (commitAlerts == null || commitAlerts.getAlertCount() <= 0) continue;
            HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commitAlerts.getCommit());
            MetricsToArchitectureMetricsMappingIndex mappingIndex = this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption);
            ContainerIndex containerIndex = this.openProjectIndex(ContainerIndex.class, "dir", historyAccessOption);
            Predicate pathContainmentChecker = ArchitectureMetricsUtils.createContainmentChecker((UniformPath)alertFilterOptions.getUniformPath(), (ContainerIndex)containerIndex, (MetricsToArchitectureMetricsMappingIndex)mappingIndex);
            result.addAll(CommitAlertsService.extractMatchingAlerts(commitAlerts, includeExcludePattern, pathContainmentChecker));
        }
        return result;
    }

    private static List<CommitAlertWithCommit> extractMatchingAlerts(CommitAlerts commitAlerts, IncludeExcludeAntPatternSupport includeExcludePattern, Predicate<String> pathContainmentChecker) {
        return commitAlerts.getCommitAlerts().stream().filter(commitAlert -> CommitAlertsService.isMatchingAlert(commitAlert, includeExcludePattern, pathContainmentChecker)).map(commitAlert -> new CommitAlertWithCommit(commitAlerts.getCommit(), commitAlert)).toList();
    }

    private static boolean isMatchingAlert(CommitAlert alert, IncludeExcludeAntPatternSupport includeExcludePattern, Predicate<String> pathContainmentChecker) {
        return CommitAlertsService.isIncluded(includeExcludePattern, alert.getContext().getExpectedCloneLocation(), pathContainmentChecker) || CommitAlertsService.isIncluded(includeExcludePattern, alert.getContext().getExpectedSiblingLocation(), pathContainmentChecker);
    }

    private static boolean isIncluded(IncludeExcludeAntPatternSupport includeExcludePattern, TextRegionLocation location, Predicate<String> pathContainmentChecker) {
        if (!pathContainmentChecker.test(location.getUniformPath())) {
            return false;
        }
        return includeExcludePattern.isIncluded(location.getUniformPath());
    }
}

