/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.commits.ECommitAttribute;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.commits.RepositoryLogFilterBase;
import com.teamscale.service.testgap.method_history.MethodHistoryEntry;
import com.teamscale.service.testgap.method_history.UserResolvedMethodHistoryEntry;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ResourceAndMethodHistoryFilter
extends RepositoryLogFilterBase {
    @Hidden
    protected CommitAlertIndex commitAlertIndex;

    private ResourceAndMethodHistoryFilter(RepositoryLogFilter repositoryLogFilterParam, CommitAlertIndex commitAlertIndex, String filteringBranchName) {
        super(repositoryLogFilterParam.commitTypes, repositoryLogFilterParam.commitAttribute, repositoryLogFilterParam.excludeOtherBranches, filteringBranchName);
        this.commitAlertIndex = commitAlertIndex;
    }

    public static ResourceAndMethodHistoryFilter createFromFilterParam(RepositoryLogFilter repositoryLogFilterParam, CommitAlertIndex commitAlertIndex, String filteringBranchName) {
        if (CollectionUtils.isNullOrEmpty((Collection)repositoryLogFilterParam.commitTypes) && !repositoryLogFilterParam.excludeOtherBranches) {
            return null;
        }
        return new ResourceAndMethodHistoryFilter(repositoryLogFilterParam, commitAlertIndex, filteringBranchName);
    }

    public SortedSet<UserResolvedMethodHistoryEntry> filterMethodHistoryEntries(SortedSet<UserResolvedMethodHistoryEntry> entries, RepositoryLogIndex repositoryLogIndex, RepositoryLogFileIndex repositoryLogFileIndex) throws StorageException {
        this.commitTypes.add(ECommitType.CODE_COMMIT);
        List commits = CollectionUtils.map(entries, MethodHistoryEntry::getCommit);
        Map<UserResolvedMethodHistoryEntry, LogEntryContainer> methodHistoryToLogEntries = this.buildEntriesToLogEntriesMap(commits, new ArrayList<UserResolvedMethodHistoryEntry>(entries), repositoryLogIndex, repositoryLogFileIndex);
        return new TreeSet<UserResolvedMethodHistoryEntry>(this.filter(methodHistoryToLogEntries));
    }

    private <T extends Comparable<? super T>> Map<T, LogEntryContainer> buildEntriesToLogEntriesMap(List<CommitDescriptor> commits, List<T> entries, RepositoryLogIndex repositoryLogIndex, RepositoryLogFileIndex repositoryLogFileIndex) throws StorageException {
        TreeMap<Comparable, LogEntryContainer> entriesToLogEntries = new TreeMap<Comparable, LogEntryContainer>();
        if (this.commitAttribute != null && this.commitAttribute == ECommitAttribute.HAS_ALERTS) {
            commits = this.filterCommitsByAlerts(commits);
        }
        List repoLogEntries = repositoryLogIndex.getEntries(commits);
        List repoLogFileEntries = repositoryLogFileIndex.getEntriesByCommits(commits);
        for (int i = 0; i < repoLogEntries.size(); ++i) {
            RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)repoLogEntries.get(i);
            if (logEntry == null) continue;
            Set<ECommitType> commitTypes = repoLogFileEntries.stream().filter((? super T entry) -> entry.getCommit().equals((Object)logEntry.getCommit())).map(RepositoryLogFileEntry::getCommitType).collect(Collectors.toSet());
            entriesToLogEntries.put((Comparable)entries.get(i), new LogEntryContainer(logEntry, commitTypes));
        }
        return entriesToLogEntries;
    }

    public List<RepositoryLogFileHistoryEntry> filterLogFileHistoryEntries(List<RepositoryLogFileHistoryEntry> entries, String branchName, RepositoryLogIndex repositoryLogIndex, RepositoryLogFileIndex repositoryLogFileIndex) throws StorageException {
        if (!this.canHaveAnyEffect(entries, branchName)) {
            return entries;
        }
        List commits = CollectionUtils.map(entries, CommitAssociatedObjectBase::getCommit);
        Map<RepositoryLogFileHistoryEntry, LogEntryContainer> fileHistoryToLogEntries = this.buildEntriesToLogEntriesMap(commits, entries, repositoryLogIndex, repositoryLogFileIndex);
        return this.filter(fileHistoryToLogEntries);
    }

    private <T> List<T> filter(Map<T, LogEntryContainer> fileHistoryToLogEntries) {
        fileHistoryToLogEntries.values().removeIf(logEntryAndLogFileEntry -> logEntryAndLogFileEntry.logEntry != null && !this.hasMatchingCommitTypes((LogEntryContainer)logEntryAndLogFileEntry));
        this.excludeCommitsOfOtherBranches(fileHistoryToLogEntries.values().stream().map(LogEntryContainer::logEntry).toList());
        return new ArrayList<T>(fileHistoryToLogEntries.keySet());
    }

    private boolean hasMatchingCommitTypes(LogEntryContainer logEntryAndLogFileEntry) {
        return !CollectionUtils.intersectionSet((Collection)this.commitTypes, (Collection[])new Collection[]{logEntryAndLogFileEntry.commitTypes}).isEmpty();
    }

    private List<CommitDescriptor> filterCommitsByAlerts(List<CommitDescriptor> commits) throws StorageException {
        ArrayList<CommitDescriptor> filteredCommits = new ArrayList<CommitDescriptor>();
        List commitAlerts = this.commitAlertIndex.getEntries(commits);
        for (int i = 0; i < commitAlerts.size(); ++i) {
            if (commitAlerts.get(i) == null || ((CommitAlerts)commitAlerts.get(i)).getAlertCount() <= 0) continue;
            filteredCommits.add(commits.get(i));
        }
        return filteredCommits;
    }

    private boolean canHaveAnyEffect(List<RepositoryLogFileHistoryEntry> entries, String originalBranchName) {
        return !this.allowsAnyCommitAttribute() || !this.allowsAnyCommitType() || this.excludeOtherBranches || this.hasActiveBranchFilter(entries, originalBranchName);
    }

    private boolean hasActiveBranchFilter(List<RepositoryLogFileHistoryEntry> entries, String originalBranchName) {
        return this.filteringBranchName != null && !entries.stream().allMatch(entry -> entry.getCommit().getBranchName().equals(originalBranchName));
    }

    private boolean allowsAnyCommitType() {
        return CollectionUtils.isNullOrEmpty((Collection)this.commitTypes) || this.commitTypes.stream().distinct().toList().size() == ECommitType.values().length;
    }

    private boolean allowsAnyCommitAttribute() {
        return this.commitAttribute == null || this.commitAttribute == ECommitAttribute.IS_ANY_COMMIT;
    }

    private record LogEntryContainer(RepositoryLogEntryAggregate logEntry, Set<ECommitType> commitTypes) {
    }
}

