/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.findings.DeltaAnalysisServiceBase;
import com.teamscale.service.findings.RepositoryChurnServiceUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/repository-churn")
public class RepositoryChurnService
extends DeltaAnalysisServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get repository churn", description="Retrieves the repository churn for a time range.", tags={"Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    public List<ExtendedRepositoryLogEntry> getRepositoryChurn(@BeanParam TimeRangeResourceServiceQueryOptions parameters, @BeanParam RepositoryLogFilter repositoryLogFilter) throws StorageException {
        TimeRange range = this.createTimeRange(parameters);
        ContainerIndex containerIndex = this.openProjectIndex(ContainerIndex.class, "dir", HistoryAccessOption.readCommit((CommitDescriptor)range.end()));
        String pathPrefix = ResourceServiceUtils.getUniformPathPrefixContainerAware((ContainerIndex)containerIndex, (String)parameters.getUniformPath().toString());
        List<CommitDescriptor> relevantCommits = this.getRelevantCommits(range.start(), range.end(), pathPrefix, repositoryLogFilter.isSpecItemEntriesOnly());
        GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)globalStorageSystem);
        repositoryLogFilter.setFilteringOptions(userAliasLookup);
        repositoryLogFilter.setPrivacyRelatedFilteringInfo(true, globalStorageSystem, this.getPermissions(), this.getUser());
        return RepositoryChurnServiceUtils.getRepositoryLogEntriesForCommits(repositoryLogFilter, relevantCommits, this.getProjectStorageSystem(), LogEntryResolver.of(this.serviceInfo, userAliasLookup), LOGGER);
    }
}

