/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.PathIssueIndex;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.treemap.RelatedIssuesTreeMapNode;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.issues.IssueTreemapBuilder;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.TreemapServiceBase;
import com.teamscale.service.metrics.treemap.TreemapSummaryQueryOptions;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.RelatedIssuesMetricTreemapBuilder;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/issues/treemap")
public class IssueTreemapService
extends TreemapServiceBase {
    private static final int RELATED_ISSUES_COLOR_METRIC = -1;

    @GET
    @Operation(summary="Get issue treemap", description="Builds an issue treemap for the given parameters. If the color metric is set to -1, it calculates how many issues reference the given nodes, while any other valid color metric value calculates the corresponding metric for the nodes.", tags={"Treemap"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.IssuesLastUpdatedContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public RelatedIssuesMetricTreemapWrapper getIssueTreemap(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to build an issue treemap for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Issue query to build a treemap for") @QueryParam(value="query") String query, @Parameter(description="Exclude files that are not referenced by issues") @QueryParam(value="exclude-non-referenced") boolean excludeNonReferencedFiles, @Parameter(description="Regular expression describing additional branches for which issue references should be loaded.") @QueryParam(value="additional-branches") Pattern additionalBranches, @BeanParam TreemapSummaryQueryOptions treemapSummaryParameters, @BeanParam TreemapQueryOptions treemapParameters) throws StorageException, TreeMapBuilderException {
        Object metricOverIssueReferenced;
        Object metricOverAll;
        RelatedIssuesTreeMapNode rootNode;
        this.adjustTreemapQueryOptions(treemapParameters, uniformPath.getType());
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        List<TeamscaleIssueId> issueIds = this.getIssueIds(query, historyAccessOption);
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), treemapParameters.getPartitions(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        Set<String> uniformPaths = metricRetrievalStrategy.getMetricDirectoryEntries(List.of(uniformPath.toString()), historyAccessOption).stream().map(MetricDirectoryEntry::getUniformPath).collect(Collectors.toSet());
        SetMap<String, TeamscaleIssueId> issuesByPath = this.getIssuesByPath(issueIds, uniformPaths, historyAccessOption, uniformPath.toString(), additionalBranches);
        if (treemapParameters.colorMetricIndex == -1) {
            IssueTreemapBuilder builder = IssueTreemapService.computeTreemapNodeForRelatedIssues(metricRetrievalStrategy, issuesByPath, uniformPaths, historyAccessOption, treemapParameters, excludeNonReferencedFiles, treemapSummaryParameters);
            rootNode = (RelatedIssuesTreeMapNode)builder.buildTreeMap(uniformPath);
            metricOverAll = builder.getMetricOverAll();
            metricOverIssueReferenced = builder.getMetricOverIssueReferenced();
        } else {
            RelatedIssuesMetricTreemapBuilder builder = IssueTreemapService.computeTreemapNodeForMetric(metricRetrievalStrategy, issuesByPath, historyAccessOption, treemapParameters, excludeNonReferencedFiles, treemapSummaryParameters);
            rootNode = (RelatedIssuesTreeMapNode)builder.buildTreeMap(uniformPath);
            metricOverAll = builder.getMetricOverAll();
            metricOverIssueReferenced = builder.getMetricOverIssueReferenced();
        }
        return new RelatedIssuesMetricTreemapWrapper(rootNode, metricOverAll, metricOverIssueReferenced);
    }

    private List<TeamscaleIssueId> getIssueIds(String query, HistoryAccessOption historyAccessOption) throws StorageException, TreeMapBuilderException {
        List issueIds;
        try {
            issueIds = QueryableEntityUtils.runIssueQuery((IKeyedObjectIndex)WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption), (String)query, (QueryableEntityUtils.QueryContext)QueryableEntityUtils.QueryContext.ofTimestamp((ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem(), (User)this.serviceInfo.getUser(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.ISSUE, (HistoryAccessOption)historyAccessOption));
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new TreeMapBuilderException("Error in issue query", e);
        }
        return issueIds;
    }

    private SetMap<String, TeamscaleIssueId> getIssuesByPath(List<TeamscaleIssueId> issueIds, Set<String> uniformPaths, HistoryAccessOption historyAccessOption, String basePath, Pattern additionalBranchesPattern) throws StorageException {
        SetMap<String, TeamscaleIssueId> result = this.getIssuesByPath(issueIds, uniformPaths, historyAccessOption, basePath);
        if (additionalBranchesPattern == null || additionalBranchesPattern.pattern().isEmpty()) {
            return result;
        }
        List<String> additionalBranches = this.openProjectIndex(ProjectRepositoryChangeIndex.class, null).getRepositoryStatus().getNonPrecommitBranchNames().stream().filter(additionalBranchesPattern.asMatchPredicate()).filter(Predicate.not(historyAccessOption.getBranchName()::equals)).toList();
        for (String additionalBranch : additionalBranches) {
            result.addAll(this.getIssuesByPath(issueIds, uniformPaths, historyAccessOption.cloneToBranchedAccessOption(additionalBranch), basePath));
        }
        return result;
    }

    private SetMap<String, TeamscaleIssueId> getIssuesByPath(List<TeamscaleIssueId> issueIds, Set<String> uniformPaths, HistoryAccessOption historyAccessOption, String basePath) throws StorageException {
        SetMap issuesByPath = new SetMap();
        for (String uniformPath : uniformPaths) {
            issuesByPath.addAll((Object)uniformPath, Collections.emptySet());
        }
        PathIssueIndex pathIssueIndex = this.openProjectIndex(PathIssueIndex.class, historyAccessOption);
        if (ArchitectureMetricsUtils.isArchitectureArtifactPath((String)basePath)) {
            return this.getIssuesByPathForArchitecturePath(issueIds, historyAccessOption, basePath, pathIssueIndex, (SetMap<String, TeamscaleIssueId>)issuesByPath);
        }
        return IssueTreemapService.getIssuesByPathForCodePath(issueIds, uniformPaths, pathIssueIndex, (SetMap<String, TeamscaleIssueId>)issuesByPath);
    }

    private static SetMap<String, TeamscaleIssueId> getIssuesByPathForCodePath(List<TeamscaleIssueId> issueIds, Set<String> uniformPaths, PathIssueIndex pathIssueIndex, SetMap<String, TeamscaleIssueId> issuesByPath) throws StorageException {
        SetMap issuesByPathAffected = pathIssueIndex.getPathToIssueMappingForAffectedIssues(uniformPaths, issueIds);
        issuesByPathAffected.forEach(entry -> issuesByPath.addAll((Object)((String)entry.getKey()), (Collection)entry.getValue()));
        for (Map.Entry issuesForPath : issuesByPathAffected) {
            Set issues = (Set)issuesForPath.getValue();
            String path = (String)issuesForPath.getKey();
            for (TeamscaleIssueId issue : issues) {
                IssueTreemapService.updateParentsWithIssueId(issuesByPath, path, issue);
            }
        }
        return issuesByPath;
    }

    private SetMap<String, TeamscaleIssueId> getIssuesByPathForArchitecturePath(List<TeamscaleIssueId> issueIds, HistoryAccessOption historyAccessOption, String basePath, PathIssueIndex pathIssueIndex, SetMap<String, TeamscaleIssueId> issuesByPath) throws StorageException {
        MetricsToArchitectureMetricsMappingIndex mappingIndex = this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption);
        Map pathToArchitecturePath = ArchitectureMetricsUtils.getRecursivePathMappings((MetricsToArchitectureMetricsMappingIndex)mappingIndex, (String)basePath);
        SetMap issuesByPathAffected = pathIssueIndex.getPathToIssueMappingForAffectedIssues(pathToArchitecturePath.keySet(), issueIds);
        issuesByPathAffected.forEach(entry -> issuesByPath.addAll((Object)((String)pathToArchitecturePath.get(entry.getKey())), (Collection)entry.getValue()));
        for (Map.Entry issuesForPath : issuesByPathAffected) {
            Set issues = (Set)issuesForPath.getValue();
            String path = (String)pathToArchitecturePath.get(issuesForPath.getKey());
            for (TeamscaleIssueId issue : issues) {
                IssueTreemapService.updateParentsWithIssueId(issuesByPath, path, issue);
            }
        }
        return issuesByPath;
    }

    private static void updateParentsWithIssueId(SetMap<String, TeamscaleIssueId> issuesByPath, String leafPath, TeamscaleIssueId issueId) {
        String path = UniformPathUtils.getParentPath((String)leafPath);
        while (!issuesByPath.contains((Object)path, (Object)issueId)) {
            issuesByPath.add((Object)path, (Object)issueId);
            path = UniformPathUtils.getParentPath((String)path);
        }
    }

    private static RelatedIssuesMetricTreemapBuilder computeTreemapNodeForMetric(IMetricRetrievalStrategy metricRetrievalStrategy, SetMap<String, TeamscaleIssueId> issuesByPath, HistoryAccessOption historyAccessOption, TreemapQueryOptions treemapParameters, boolean excludeNonReferencedFiles, TreemapSummaryQueryOptions treemapSummaryParameters) {
        MetricTreemapBuilderParameters parameters = new MetricTreemapBuilderParameters(treemapParameters.includePattern, treemapParameters.excludePattern, treemapParameters.colorMetricIndex, treemapParameters.colorMetricDefaultValue, treemapParameters.baseColor, treemapParameters.specifiedMinValue, treemapParameters.specifiedMaxValue, treemapParameters.isColorBlindModeEnabled());
        return new RelatedIssuesMetricTreemapBuilder(metricRetrievalStrategy, historyAccessOption, treemapParameters.areaMetricIndex, parameters, issuesByPath, excludeNonReferencedFiles, treemapSummaryParameters);
    }

    private static IssueTreemapBuilder computeTreemapNodeForRelatedIssues(IMetricRetrievalStrategy metricRetrievalStrategy, SetMap<String, TeamscaleIssueId> issuesByPath, Set<String> uniformPaths, HistoryAccessOption historyAccessOption, TreemapQueryOptions treemapParameters, boolean excludeNonReferencedFiles, TreemapSummaryQueryOptions treemapSummaryParameters) {
        return new IssueTreemapBuilder(treemapParameters.includePattern, treemapParameters.excludePattern, metricRetrievalStrategy, historyAccessOption, treemapParameters.areaMetricIndex, treemapParameters.colorMetricDefaultValue, treemapParameters.baseColor, issuesByPath, uniformPaths, excludeNonReferencedFiles, treemapSummaryParameters);
    }

    public record RelatedIssuesMetricTreemapWrapper(@JsonProperty(value="rootNode") @Schema(description="The treemap root node") RelatedIssuesTreeMapNode rootNode, @JsonProperty(value="metricOverAll") @Schema(description="The aggregated metric for all files (including the ones not referenced by any issues, unless explicitly excluded). `null` if the aggregation of the selected metric type is not supported by this service.", implementation=MetricDirectoryEntry.MetricValue.class) @Nullable Object metricOverAll, @JsonProperty(value="metricOverIssueReferenced") @Schema(description="The aggregated metric for files referenced by an issue. `null` if the aggregation of the selected metric type is not supported by this service.", implementation=MetricDirectoryEntry.MetricValue.class) @Nullable Object metricOverIssueReferenced) {
    }
}

