/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.hotspot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.collect.ImmutableSet;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.metrics.MetricServiceUtil;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@ReadCacheEnabled
@Path(value="api/projects/{project}/metrics/hotspots")
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.class, SpecItemContributor.class})
public class MetricHotspotService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean missingMetricValueLogged = false;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get metric hotspots", description="Retrieves the metric hotspots for the provided parameters. Hotspots are determined using the aggregation information of the metric. The result is determined by ranking all elements with regards to each individual metric and computing an overall ranking by equally weighting each metric rank.", responses={@ApiResponse(responseCode="400", description="Hotspots cannot be determined for non-numeric metrics.")}, tags={"Metrics"})
    public List<ScoredMetricDirectoryEntry> getMetricHotspots(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to compute metric hotspots for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Metric indexes to compute metric hotspots for", required=true) @QueryParam(value="metric-indexes") List<Integer> metricIndexes, @Parameter(description="Maximum result count to return", required=true) @QueryParam(value="num-results") @DefaultValue(value="-1") int numResults, @Parameter(description="The score at which to perform a cutoff (i.e., files with this score or higher will no longer be displayed)", required=true) @QueryParam(value="score-cutoff") double scoreCutoff) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        List metricDirectoryEntries = metricRetrievalStrategy.getMetricDirectoryEntries(Collections.singletonList(uniformPath.toString()), this.determineHistoryOption(commit));
        List<MetricDirectoryEntry> leafEntries = MetricServiceUtil.extractCompleteLeaves(metricDirectoryEntries, (Set<Integer>)ImmutableSet.copyOf(metricIndexes));
        if (leafEntries.isEmpty()) {
            return new ArrayList<ScoredMetricDirectoryEntry>();
        }
        return this.determineHotspots(metricIndexes, numResults, scoreCutoff, leafEntries, metricRetrievalStrategy.getMetricDirectorySchema());
    }

    private List<ScoredMetricDirectoryEntry> determineHotspots(List<Integer> metricIndexes, int numResults, double scoreCutoff, List<MetricDirectoryEntry> entries, MetricDirectorySchema schema) {
        double[] minima = new double[schema.size()];
        double[] maxima = new double[schema.size()];
        for (int index : metricIndexes) {
            minima[index] = Double.MAX_VALUE;
            maxima[index] = Double.MIN_NORMAL;
            for (MetricDirectoryEntry entry : entries) {
                Double doubleValue = this.getDoubleValue(entry, index);
                if (doubleValue == null) continue;
                minima[index] = Math.min(minima[index], doubleValue);
                maxima[index] = Math.max(maxima[index], doubleValue);
            }
        }
        ArrayList<ScoredMetricDirectoryEntry> scoredEntries = new ArrayList<ScoredMetricDirectoryEntry>();
        for (MetricDirectoryEntry entry : entries) {
            Optional<Double> score = this.getScore(metricIndexes, entry, minima, maxima, schema);
            if (!score.isPresent() || !(score.get() < scoreCutoff)) continue;
            scoredEntries.add(new ScoredMetricDirectoryEntry(entry, score.get()));
        }
        return MetricHotspotService.sortAndTruncateEntries(numResults, scoredEntries);
    }

    private Optional<Double> getScore(List<Integer> metricIndexes, MetricDirectoryEntry entry, double[] minima, double[] maxima, MetricDirectorySchema schema) {
        double score = 0.0;
        for (int index : metricIndexes) {
            MetricDirectorySchemaEntry schemaEntry = schema.getEntry(index);
            if (schemaEntry.getValueType() != EMetricValueType.NUMERIC) {
                throw new BadRequestException("Hotspots cannot be determined for non-numeric metric " + String.valueOf(schemaEntry));
            }
            Double doubleValue = this.getDoubleValue(entry, index);
            if (doubleValue == null) {
                return Optional.empty();
            }
            score += MetricHotspotService.computeScore(minima[index], maxima[index], doubleValue, schemaEntry);
        }
        return Optional.of(score);
    }

    private Double getDoubleValue(MetricDirectoryEntry entry, int metricIndex) {
        Object value = entry.getValueOrDefault(metricIndex, null);
        if (!(value instanceof Double)) {
            if (!this.missingMetricValueLogged) {
                LOGGER.error("Expected valid Double metric value at index " + metricIndex + " for " + String.valueOf(entry));
            }
            this.missingMetricValueLogged = true;
            return null;
        }
        return (Double)value;
    }

    private static double computeScore(double min, double max, Double value, MetricDirectorySchemaEntry schemaEntry) {
        double range = max - min;
        if (range == 0.0) {
            return 0.0;
        }
        if (schemaEntry.hasProperty(EMetricProperty.LOW_IS_BAD)) {
            return (value - min) / range;
        }
        return (max - value) / range;
    }

    private static ArrayList<ScoredMetricDirectoryEntry> sortAndTruncateEntries(int numResults, List<ScoredMetricDirectoryEntry> entries) {
        ArrayList sortedEntries = CollectionUtils.sort(entries);
        CollectionUtils.truncateEnd((List)sortedEntries, (int)numResults);
        return new ArrayList<ScoredMetricDirectoryEntry>(sortedEntries);
    }

    public static class ScoredMetricDirectoryEntry
    implements Comparable<ScoredMetricDirectoryEntry> {
        @JsonUnwrapped
        private final MetricDirectoryEntry entry;
        @JsonProperty(value="score")
        private final Double score;

        private ScoredMetricDirectoryEntry(MetricDirectoryEntry entry, Double score) {
            this.entry = entry;
            this.score = score;
        }

        public Double getScore() {
            return this.score;
        }

        @Override
        public int compareTo(ScoredMetricDirectoryEntry other) {
            int comparisonResult = this.getScore().compareTo(other.getScore());
            if (comparisonResult == 0) {
                return this.entry.getUniformPath().compareTo(other.entry.getUniformPath());
            }
            return comparisonResult;
        }
    }
}

