/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentOptionsBase;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.treemap.MethodTreeMapNodeBase;
import com.teamscale.index.testgap.treemap.TestGapTreeMapWrapper;
import com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode;
import com.teamscale.index.testgap.treemap.TreeMapNodeBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.metrics.treemap.AbapTreemapUtils;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/test-gaps/treemap")
public class TgaTreeMapService
extends CrossAnnotationServiceBase {
    public static final String EXCLUDE_UNCHANGED_METHODS_PARAMETER_NAME = "exclude-unchanged-methods";
    public static final String EXCLUDE_UNCHANGED_METHODS_DOC = "Parameter determining if only changed methods should be returned";

    @GET
    @Cache(maxAge=5, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.IssuesLastUpdatedContributor.class})
    @Operation(summary="Get test gap treemap", description="Retrieves the test get treemap. For each method in the project, the treemap shows whether it was tested after its last change within the reference time frame.", tags={"Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", description="Could not find actual commit for given branch at given timestamp."), @ApiResponse(responseCode="400", description="Attempt to use timespan to retrieve execution treemap of a single test run. Baseline timestamp and end timestamp have to be equal."), @ApiResponse(responseCode="404", description="Found no commits to be merged."), @ApiResponse(responseCode="400", description="Could not determine common merge base."), @ApiResponse(responseCode="404", description="Found no issue for the provided id."), @ApiResponse(responseCode="409", description="Found multiple issues for the provided id.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TestGapTreeMapWrapper getTestGapTreeMap(@BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentQueryOptions, @Parameter(description="Parameter determining if only changed methods should be returned") @QueryParam(value="exclude-unchanged-methods") boolean excludeUnchangedMethods) throws StorageException, RepositoryException {
        this.checkCrossAnnotationPermissions((CoverageSourceParameterBase)coverageSourceParameters);
        ITgaRequest request = this.createTgaRequest((CoverageSourceParameterBase)coverageSourceParameters, timeIntervalBasedParameters, tgaRequestParameters, issueTgaParameters, (TgaRequestAssessmentOptionsBase)assessmentQueryOptions);
        return TgaTreeMapService.getTestGapTreemapWrapperFromTreemapRequest(request, excludeUnchangedMethods, tgaRequestParameters.getUniformPath());
    }

    public static TestGapTreeMapWrapper getTestGapTreemapWrapperFromTreemapRequest(ITgaRequest request, boolean excludeUnchangedMethods, UniformPath rootUniformPath) throws StorageException {
        AssessedTgaData assessedTestGapData = request.fetchAndAssessData();
        List methods = assessedTestGapData.filterByGrayState(excludeUnchangedMethods);
        TgaMethodTreeMapNode treemap = TgaTreeMapService.createTreeMap(methods, rootUniformPath);
        CounterSet stateCounter = TgaAggregationUtils.countStates((List)methods);
        double ratio = TgaAggregationUtils.calculateRatio((ETgaAssessmentType)request.getTgaAssessmentType(), (CounterSet)stateCounter);
        return new TestGapTreeMapWrapper(treemap, stateCounter, ratio, request.getIndexAccessCommit(), request.getBaselineTimestamp(), request.getPartitions(), (Collection)request.getCrossAnnotationProjects(), request.getTgaAssessmentType());
    }

    public static TgaMethodTreeMapNode createTreeMap(List<AssessedTgaData.AssessedMethodData> methods, UniformPath rootUniformPath) {
        TgaMethodTreeMapNode rootNode = TgaTreeMapService.buildTreeMapNodes(methods, rootUniformPath);
        rootNode.recalculateAreaAggregates();
        AbapTreemapUtils.scaleAbapBwNodes((MethodTreeMapNodeBase)rootNode);
        return rootNode;
    }

    private static TgaMethodTreeMapNode buildTreeMapNodes(List<AssessedTgaData.AssessedMethodData> methods, UniformPath rootUniformPath) {
        TgaMethodTreeMapNode root = new TgaMethodTreeMapNode();
        List sortedMethods = CollectionUtils.sort(methods, Comparator.comparing(AssessedTgaData.AssessedMethodData::getLocation));
        for (AssessedTgaData.AssessedMethodData method : sortedMethods) {
            TgaMethodTreeMapNode fileNode = TgaMethodTreeMapNode.findOrCreateNode((TgaMethodTreeMapNode)root, (String)method.getLocation().getUniformPath());
            fileNode.addChild((TreeMapNodeBase)new TgaMethodTreeMapNode(method, method.getTestGapState()));
        }
        return TgaMethodTreeMapNode.findOrCreateNode((TgaMethodTreeMapNode)root, (String)rootUniformPath.toString());
    }
}

