/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.permissions.PermissionFilter;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.quality_report.QualityArtifactIndexBase;
import com.teamscale.index.quality_report.QualityReport;
import com.teamscale.index.quality_report.retrospective.Retrospective;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.persistence.store.StorageException;

public class PermissionFilterUtils {
    public static List<User> getVisibleUsers(ServicePermissions permissions, UserIndex userIndex) throws StorageException {
        PermissionFilter filter = new PermissionFilter(permissions.getPermissionLookup(EBasicPermissionScope.USERS), User::getUsername, (Object)EBasicPermission.VIEW);
        return filter.filter(userIndex.getAllUsers());
    }

    public static List<AnalysisProfile> getVisibleAnalysisProfiles(ServicePermissions permissions, AnalysisProfileIndex index) throws StorageException {
        PermissionFilter filter = new PermissionFilter(permissions.getPermissionLookup(EBasicPermissionScope.ANALYSIS_PROFILES), NamedConfigurableObjectBase::getName, (Object)EBasicPermission.VIEW);
        return filter.filter(index.getAllProfiles());
    }

    public static List<MetricThresholdConfiguration> getVisibleMetricThresholdConfigurations(ServicePermissions permissions, MetricThresholdConfigurationIndex index) throws StorageException {
        return PermissionFilterUtils.getFromValues(permissions, index.getAllThresholdConfigurations().extractSecondList(), EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, NamedConfigurableObjectBase::getName);
    }

    public static <T extends QualityReport> List<T> getVisibleQualityReports(ServicePermissions permissions, QualityArtifactIndexBase<T> index) throws StorageException {
        return PermissionFilterUtils.getFromValues(permissions, index.getAllQualityArtifacts().extractSecondList(), EBasicPermissionScope.REPORTS, artifact -> artifact.getMetaInfo().getId());
    }

    public static <T extends Retrospective> List<T> getVisibleRetrospectives(ServicePermissions permissions, QualityArtifactIndexBase<T> index) throws StorageException {
        return PermissionFilterUtils.getFromValues(permissions, index.getAllQualityArtifacts().extractSecondList(), EBasicPermissionScope.RETROSPECTIVES, artifact -> artifact.getMetaInfo().getId());
    }

    public static List<UserGroup> getVisibleGroups(ServicePermissions permissions, UserGroupIndex index) throws StorageException {
        return PermissionFilterUtils.getFromValues(permissions, index.getAllUserGroups().extractSecondList(), EBasicPermissionScope.GROUPS, UserGroup::getName);
    }

    public static List<ExternalCredentials> getVisibleExternalCredentials(ServicePermissions permissions, ExternalCredentialsIndex index) throws StorageException {
        return PermissionFilterUtils.getFromValues(permissions, index.getAllExternalCredentials(), EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, configuration -> configuration.credentialsName);
    }

    public static List<ExternalStorageBackend> getVisibleExternalStorageBackends(ServicePermissions permissions, ExternalStorageBackendIndex index) throws StorageException {
        return PermissionFilterUtils.getFromValues(permissions, index.getAllExternalStorageBackends(), EBasicPermissionScope.EXTERNAL_STORAGE_BACKENDS, ExternalStorageBackend::externalStorageBackendName);
    }

    private static <T extends Serializable> List<T> getFromValues(ServicePermissions permissions, List<T> values, EBasicPermissionScope permissionScope, Function<T, String> idExtractor) {
        PermissionFilter filter = new PermissionFilter(permissions.getPermissionLookup(permissionScope), idExtractor, (Object)EBasicPermission.VIEW);
        return filter.filter(values);
    }
}

