/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit;

import com.google.common.collect.ImmutableList;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.progress.RevisionAnalysisProgress;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.findings.calculation.BasicFindingFilterUtils;
import com.teamscale.index.findings.calculation.CodeFindingsRetriever;
import com.teamscale.index.findings.calculation.EBlacklistingOption;
import com.teamscale.index.findings.calculation.EPendingExclusionOption;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.precommit.PreCommitUploadChangeRetriever;
import com.teamscale.index.precommit.PreCommitUploadCommit;
import com.teamscale.index.precommit.PreCommitUploadStagingIndex;
import com.teamscale.index.precommit.PrecommitStatisticsIndex;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.element_details.PartOfTestCodeDetail;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.system_info.EHealthCheckStatus;
import com.teamscale.index.system_info.ESystemHealthCheck;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.precommit.IPreCommit3ServiceApi;
import com.teamscale.service.precommit.PreCommit3StandardErrors;
import com.teamscale.service.precommit.PreCommitLimitsChecker;
import com.teamscale.service.precommit.PreCommitUploadDataFilter;
import com.teamscale.service.precommit.RepositoryConnectorShallowConfig;
import eu.cqse.check.framework.scanner.ELanguage;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Path;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.PreCommit3Result;
import org.conqat.engine.index.shared.PreCommitUploadData;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/pre-commit3")
public class PreCommit3Service
extends ApiBase
implements IPreCommit3ServiceApi {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public PreCommit3Result requestPreCommitAnalysis(String commitId, String repositoryParentBranchName, Map<String, @Nullable String> uploadData, boolean handleFilePathsCaseInsensitive) throws StorageException {
        if (EFeatureToggle.PRECOMMIT3_DISABLED.isEnabled()) {
            return PreCommit3StandardErrors.createPreCommitDisabledErrorResult();
        }
        Optional<String> licenseViolation = this.checkForLicenseViolation();
        if (licenseViolation.isPresent()) {
            return PreCommit3StandardErrors.createLicenseViolationPreCommitAnalysisErrorResult(licenseViolation.get());
        }
        LOGGER.traceEntry(null, new Object[]{commitId, repositoryParentBranchName, uploadData});
        CommitDescriptorIndex commitDescriptorIndex = this.openCommitDescriptorIndex();
        String baseBranchName = this.determineBaseBranchName(repositoryParentBranchName, commitDescriptorIndex);
        String preCommitBranchName = this.determinePreCommitBranchName(commitId, repositoryParentBranchName, baseBranchName);
        LOGGER.trace("Pre-Commit branch: {}", (Object)preCommitBranchName);
        ArrayList<PreCommit3Result.PreCommit3ErrorDetail> detailedErrors = new ArrayList<PreCommit3Result.PreCommit3ErrorDetail>();
        PreCommitUploadData convertedUploadData = this.filterAndConvertUploadData(uploadData, preCommitBranchName, detailedErrors::add);
        detailedErrors.addAll(PreCommitLimitsChecker.getLimitViolations(this.getUser().getUsername(), this.serviceInfo.getPrimaryPublicId(), convertedUploadData, this.serviceInfo.getGlobalStorageSystem()));
        detailedErrors.addAll(this.calculatePossibleUserWarnings(repositoryParentBranchName, baseBranchName, preCommitBranchName));
        LOGGER.trace("Errors: {}", detailedErrors);
        try (SilentAutoClosable ignoredUnlockAction = PreCommitUploadStagingIndex.obtainLock((ILockProvider)this.serviceInfo.getLockProvider(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId());){
            CommitDescriptor baseCommitFromServiceInput = this.determineBaseCommitFromServiceInput(commitId, baseBranchName, commitDescriptorIndex);
            CommitDescriptor realParentCommit = PreCommit3Service.determineRealParentCommit(commitDescriptorIndex, preCommitBranchName, baseCommitFromServiceInput);
            String token = this.calculatePreCommitToken(detailedErrors, convertedUploadData, handleFilePathsCaseInsensitive, baseBranchName, preCommitBranchName, baseCommitFromServiceInput, realParentCommit);
            PreCommit3Result preCommit3Result = (PreCommit3Result)LOGGER.traceExit((Object)new PreCommit3Result(token, detailedErrors, this.determineCurrentFindings(convertedUploadData, realParentCommit)));
            return preCommit3Result;
        }
    }

    private List<PreCommit3Result.PreCommit3ErrorDetail> calculatePossibleUserWarnings(String repositoryParentBranchName, String baseBranchName, String preCommitBranchName) throws StorageException {
        ArrayList<PreCommit3Result.PreCommit3ErrorDetail> detailedErrors = new ArrayList<PreCommit3Result.PreCommit3ErrorDetail>();
        if (repositoryParentBranchName != null && !baseBranchName.equals(repositoryParentBranchName)) {
            detailedErrors.add(PreCommit3Result.PreCommit3ErrorDetail.createFileIndependentError((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.BRANCH_UNKNOWN, (String)("The branch '" + repositoryParentBranchName + "' is not known in Teamscale. The branch '" + baseBranchName + "' will be used as fallback"), (boolean)false));
        }
        if (!this.isBranchInLiveAnalysisState(preCommitBranchName, baseBranchName)) {
            detailedErrors.add(PreCommit3Result.PreCommit3ErrorDetail.createFileIndependentError((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.ANALYSIS_NOT_LIVE, (String)"Teamscale is currently analyzing older commits in your project and will analyse your pre-commits on the older project state.", (boolean)false));
        }
        return detailedErrors;
    }

    private boolean isBranchInLiveAnalysisState(String preCommitBranch, String baseBranch) throws StorageException {
        BranchAnalysisStateIndex branchAnalysisStateIndex = this.openProjectIndex(BranchAnalysisStateIndex.class, null);
        AnalysisState preCommitAnalysisState = branchAnalysisStateIndex.getAnalysisState(preCommitBranch);
        if (preCommitAnalysisState != null) {
            EAnalysisState state = preCommitAnalysisState.getState();
            return state == EAnalysisState.LIVE_ANALYSIS || state == EAnalysisState.CATCHUP_LIVE_ANALYSIS;
        }
        AnalysisState baseBranchAnalysisState = branchAnalysisStateIndex.getAnalysisState(baseBranch);
        if (baseBranchAnalysisState != null) {
            EAnalysisState state = baseBranchAnalysisState.getState();
            return state == EAnalysisState.LIVE_ANALYSIS || state == EAnalysisState.CATCHUP_LIVE_ANALYSIS;
        }
        return false;
    }

    private @Nullable String calculatePreCommitToken(List<PreCommit3Result.PreCommit3ErrorDetail> detailedErrors, PreCommitUploadData uploadData, boolean handleFilePathsCaseInsensitive, String baseBranchName, String preCommitBranchName, CommitDescriptor baseCommitFromServiceInput, CommitDescriptor realParentCommit) throws StorageException {
        if (detailedErrors.stream().anyMatch(PreCommit3Result.PreCommit3ErrorDetail::isFileIndependentAbortionError)) {
            return null;
        }
        PreCommitUploadData filteredUploadData = PreCommit3Service.filterOutErrors(uploadData, detailedErrors);
        if (filteredUploadData.isEmpty()) {
            return null;
        }
        CommitDescriptor parentCommit = this.determineParentCommit(preCommitBranchName, baseCommitFromServiceInput);
        String token = this.submitPreCommitAnalysis(preCommitBranchName, parentCommit, filteredUploadData, realParentCommit, handleFilePathsCaseInsensitive);
        this.openGlobalIndex(PrecommitStatisticsIndex.class).storeNewTask(this.serviceInfo.getInternalId(), this.serviceInfo.getPrimaryPublicId(), token, this.getUser(), uploadData, baseBranchName);
        return token;
    }

    private String determineBaseBranchName(String repositoryParentBranchName, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        String baseBranchName = repositoryParentBranchName;
        if (repositoryParentBranchName == null || !this.branchExists(repositoryParentBranchName) || commitDescriptorIndex.getLatestCommitForBranch(repositoryParentBranchName).isEmpty()) {
            baseBranchName = this.getDefaultBranchName();
        }
        return baseBranchName;
    }

    private static UnmodifiableList<RepositoryConnectorShallowConfig> toShallowConnectorConfigs(UnmodifiableList<ConnectorConfiguration> connectors) {
        return (UnmodifiableList)connectors.stream().filter(connector -> ERepositoryConnector.findByReadableName((String)connector.getType()) != null).map(RepositoryConnectorShallowConfig::new).collect(CollectionUtils.toUnmodifiableList());
    }

    private static CommitDescriptor determineRealParentCommit(CommitDescriptorIndex commitDescriptorIndex, String preCommitBranchName, CommitDescriptor baseCommitFromServiceInput) throws StorageException {
        List knownCommitOnPreCommitBranch = commitDescriptorIndex.getCommitsForBranch(preCommitBranchName);
        if (knownCommitOnPreCommitBranch.isEmpty()) {
            return baseCommitFromServiceInput;
        }
        return (CommitDescriptor)CollectionUtils.getLast((List)knownCommitOnPreCommitBranch);
    }

    private PreCommitUploadData filterAndConvertUploadData(Map<String, @Nullable String> uploadData, String preCommitBranchName, Consumer<PreCommit3Result.PreCommit3ErrorDetail> errorCallback) throws StorageException {
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)this.openProjectIndex(MetaIndex.class, null).getValue(ProjectConfiguration.class);
        UnmodifiableList connectors = projectConfiguration.getConnectors();
        Set configuredLanguages = projectConfiguration.getConfiguredLanguages();
        Map<String, @Nullable String> filteredUploadData = new PreCommitUploadDataFilter((List<RepositoryConnectorShallowConfig>)PreCommit3Service.toShallowConnectorConfigs((UnmodifiableList<ConnectorConfiguration>)connectors), this.openProjectIndex(RepositoryOriginalPathIndex.class, HistoryAccessOption.readHead((String)preCommitBranchName))).filterUploadData(uploadData, configuredLanguages, errorCallback);
        return PreCommit3Service.convertUploadData(filteredUploadData);
    }

    private static PreCommitUploadData convertUploadData(Map<String, String> uploadData) {
        HashMap<UniformPath, String> uniformPathToContentMap = new HashMap<UniformPath, String>();
        ArrayList<UniformPath> deletedUniformPaths = new ArrayList<UniformPath>();
        for (Map.Entry<String, String> entry : uploadData.entrySet()) {
            UniformPath path = UniformPathCompatibilityUtil.convert((String)entry.getKey());
            if (entry.getValue() == null) {
                deletedUniformPaths.add(path);
                continue;
            }
            uniformPathToContentMap.put(path, entry.getValue());
        }
        return new PreCommitUploadData(uniformPathToContentMap, deletedUniformPaths);
    }

    private static PreCommitUploadData filterOutErrors(PreCommitUploadData data, Collection<PreCommit3Result.PreCommit3ErrorDetail> errorDetails) {
        HashMap pathToContent = new HashMap(data.getUniformPathToContentMap());
        HashSet deletedPaths = new HashSet(data.getDeletedUniformPaths());
        for (PreCommit3Result.PreCommit3ErrorDetail error : errorDetails) {
            if (!error.resultsInvalid) continue;
            pathToContent.remove(error.affectedUniformPath);
            deletedPaths.remove(error.affectedUniformPath);
        }
        return PreCommitUploadData.from(pathToContent, deletedPaths);
    }

    private CommitDescriptor determineParentCommit(String preCommitBranchName, CommitDescriptor baseCommit) throws StorageException {
        IBranchingLayer preCommitStagingLayer = this.getProjectStorageSystem().openBranchingLayer(PreCommitUploadStagingIndex.class);
        IBranchCommitInfo existingCommit = preCommitStagingLayer.getNewestCommitBeforeOrAt(preCommitBranchName, Long.MAX_VALUE);
        if (existingCommit != null) {
            return new CommitDescriptor(existingCommit.getBranchName(), existingCommit.getTimestamp());
        }
        return baseCommit;
    }

    private String determinePreCommitBranchName(@Nullable String commitId, @Nullable String repositoryParentBranchName, String baseBranchName) {
        if (repositoryParentBranchName == null) {
            return this.determinePreCommitBranchName(commitId, baseBranchName);
        }
        return this.determinePreCommitBranchName(commitId, repositoryParentBranchName);
    }

    private String determinePreCommitBranchName(String commitId, String repositoryParentBranchName) {
        if (commitId != null) {
            return PreCommitUtils.createPrecommitBranchNameForCommitId((String)this.getUser().getUsername(), (String)commitId);
        }
        return PreCommitUtils.createPrecommitBranchNameForBranchName((String)this.getUser().getUsername(), (String)repositoryParentBranchName);
    }

    private boolean branchExists(String repositoryParentBranchName) throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = this.openProjectIndex(ProjectRepositoryChangeIndex.class, null);
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        return repositoryStatus.getBranchNames().contains(repositoryParentBranchName);
    }

    private String submitPreCommitAnalysis(String preCommitBranchName, CommitDescriptor parentCommitForPreCommitUpload, PreCommitUploadData uploadData, CommitDescriptor parentForChangeDetermination, boolean handleFilePathsCaseInsensitive) throws StorageException {
        PreCommitUploadCommit uploadCommit = this.determineChangedFilesAndBuildUploadCommit(uploadData, parentForChangeDetermination, preCommitBranchName, parentCommitForPreCommitUpload, handleFilePathsCaseInsensitive);
        if (uploadCommit.isEmpty()) {
            return null;
        }
        this.storePreCommitDataAndSchedulePreCommitUploadChangeRetriever(uploadCommit);
        return PreCommit3Service.encodeToken(uploadCommit.getCommit());
    }

    private PreCommitUploadCommit determineChangedFilesAndBuildUploadCommit(PreCommitUploadData uploadData, CommitDescriptor realParent, String preCommitBranchName, CommitDescriptor parentCommitForPreCommitUpload, boolean handleFilePathsCaseInsensitive) throws StorageException {
        Map<String, BasicTokenElementInfo> existingFiles = this.determineExistingFiles(uploadData, realParent, handleFilePathsCaseInsensitive);
        Set<ELanguage> supportedLanguages = this.getConfiguredLanguages();
        Set<String> deletedFiles = PreCommit3Service.determineDeletedFiles(uploadData, existingFiles, supportedLanguages);
        PairList newFiles = new PairList();
        PairList changedFiles = new PairList();
        HashSet<String> testCodeFiles = new HashSet<String>();
        for (Map.Entry entry : uploadData.getUniformPathToContentMap().entrySet()) {
            String path = (String)entry.getKey();
            String content = StringUtils.normalizeLineSeparatorsPlatformIndependent((String)((String)entry.getValue()));
            if (CollectionUtils.intersectionSet(supportedLanguages, (Collection[])new Collection[]{ELanguage.getAllLanguagesForPath((String)path)}).isEmpty()) continue;
            BasicTokenElementInfo existingContent = existingFiles.get(path);
            if (existingContent == null) {
                newFiles.add((Object)path, (Object)content);
                continue;
            }
            if (existingContent.getFirstDetailOfType(PartOfTestCodeDetail.class).isPresent()) {
                testCodeFiles.add(path);
            }
            if (!existingContent.getUniformPath().equals(path)) {
                newFiles.add((Object)path, (Object)content);
                deletedFiles.add(existingContent.getUniformPath());
                continue;
            }
            if (content.equals(existingContent.getText())) continue;
            changedFiles.add((Object)path, (Object)content);
        }
        return new PreCommitUploadCommit(preCommitBranchName, parentCommitForPreCommitUpload, newFiles, changedFiles, deletedFiles, testCodeFiles);
    }

    private Map<String, BasicTokenElementInfo> determineExistingFiles(PreCommitUploadData uploadData, CommitDescriptor realParent, boolean handleFilePathsCaseInsensitive) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)realParent.getBranchName(), (long)realParent.getTimestamp());
        BasicTokenElementIndex contentIndex = this.openProjectIndex(BasicTokenElementIndex.class, historyAccessOption);
        ArrayList allPaths = new ArrayList(CollectionUtils.unionSet((Collection)uploadData.getDeletedUniformPaths(), (Collection[])new Collection[]{uploadData.getUniformPathToContentMap().keySet()}));
        Map existingFiles = PairList.zip(allPaths, (List)contentIndex.getTokenElements(allPaths)).toMap();
        if (handleFilePathsCaseInsensitive) {
            this.performCaseInsensitivePathLookup(existingFiles, contentIndex, historyAccessOption);
        }
        return existingFiles;
    }

    private void performCaseInsensitivePathLookup(Map<String, BasicTokenElementInfo> existingFiles, BasicTokenElementIndex contentIndex, HistoryAccessOption historyAccessOption) throws StorageException {
        PathLookupIndex pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccessOption);
        for (Map.Entry<String, BasicTokenElementInfo> mapping : existingFiles.entrySet()) {
            ImmutableList possiblePaths;
            if (mapping.getValue() != null || (possiblePaths = pathLookupIndex.lookupSuffix(mapping.getKey())).size() != 1) continue;
            mapping.setValue(contentIndex.getTokenElement((String)possiblePaths.get(0)));
        }
    }

    private Set<ELanguage> getConfiguredLanguages() throws StorageException {
        return AnalysisProfileUtils.getConfiguredLanguages((MetaIndex)this.openProjectIndex(MetaIndex.class, null));
    }

    private static Set<String> determineDeletedFiles(PreCommitUploadData uploadData, Map<String, BasicTokenElementInfo> existingFiles, Set<ELanguage> supportedLanguages) {
        HashSet<String> deletedFiles = new HashSet<String>();
        for (String deletedPath : uploadData.getDeletedUniformPaths()) {
            if (CollectionUtils.intersectionSet(supportedLanguages, (Collection[])new Collection[]{ELanguage.getAllLanguagesForPath((String)deletedPath)}).isEmpty() || existingFiles.get(deletedPath) == null) continue;
            deletedFiles.add(deletedPath);
        }
        return deletedFiles;
    }

    private void storePreCommitDataAndSchedulePreCommitUploadChangeRetriever(PreCommitUploadCommit uploadCommit) throws StorageException {
        PreCommitUploadStagingIndex stagingIndex = this.openProjectIndex(PreCommitUploadStagingIndex.class, HistoryAccessOption.readHeadWriteTimestamp((String)uploadCommit.getCommit().getBranchName(), (long)uploadCommit.getTimestamp()));
        stagingIndex.setCommitInfo((Serializable)uploadCommit);
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.getIndexLayer(), this.serviceInfo.getInternalId(), PreCommitUploadChangeRetriever.class);
    }

    private static String encodeToken(CommitDescriptor commit) {
        return Base64.getEncoder().encodeToString(commit.toServiceCallFormat().getBytes(StandardCharsets.UTF_8));
    }

    private List<TrackedFinding> determineCurrentFindings(PreCommitUploadData uploadData, CommitDescriptor realParent) throws StorageException {
        HistoryAccessOption historyAccess = HistoryAccessOption.readCommit((CommitDescriptor)realParent);
        BasicTokenElementIndex contentIndex = this.openProjectIndex(BasicTokenElementIndex.class, historyAccess);
        TrackedFindingsIndex findingsIndex = this.openProjectIndex(TrackedFindingsIndex.class, historyAccess);
        ArrayList paths = new ArrayList(uploadData.getUniformPathToContentMap().keySet());
        List currentContent = contentIndex.getTokenElements(paths);
        List currentFindings = findingsIndex.getFindings(UniformPathCompatibilityUtil.convertCollection(paths));
        ArrayList<TrackedFinding> findings = new ArrayList<TrackedFinding>();
        for (int i = 0; i < paths.size(); ++i) {
            if (CollectionUtils.isNullOrEmpty((Collection)((Collection)currentFindings.get(i))) || currentContent.get(i) == null) continue;
            LocationAdjuster adjuster = new LocationAdjuster(((BasicTokenElementInfo)currentContent.get(i)).getText(), (String)uploadData.getUniformPathToContentMap().get(paths.get(i)));
            findings.addAll(IndexFindingUtils.adjustFindingLocations((LocationAdjuster)adjuster, (Collection)((Collection)currentFindings.get(i))));
        }
        return this.applyBlacklistFilter(findings, realParent);
    }

    private CommitDescriptor determineBaseCommitFromServiceInput(String commitId, String repositoryParentBranchName, CommitDescriptorIndex commitDescriptorIndex) throws BadRequestException, StorageException {
        RepositoryRevisionIndex repositoryRevisionIndex;
        Optional commit;
        if (commitId != null && (commit = (repositoryRevisionIndex = (RepositoryRevisionIndex)this.getProjectStorageSystem().openProjectIndex(RepositoryRevisionIndex.class, null)).getFirstProcessedCommit(commitId)).isPresent()) {
            return (CommitDescriptor)commit.get();
        }
        return this.pickFirstFinishedCommit((ParentedCommitDescriptor)commitDescriptorIndex.getLatestCommitForBranch(repositoryParentBranchName).orElseThrow(() -> new BadRequestException("Could not find any commits on branch " + repositoryParentBranchName)), commitDescriptorIndex);
    }

    private ParentedCommitDescriptor pickFirstFinishedCommit(ParentedCommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        Set commitsInProgress = CollectionUtils.mapToSet((Collection)this.openProjectIndex(ProjectAnalysisProgressIndex.class, null).getProgress(), RevisionAnalysisProgress::commit);
        while (commitsInProgress.contains(commit) && commit.getFirstParentCommit() != null && commit.getFirstParentCommit().getBranchName().equals(commit.getBranchName())) {
            commit = commitDescriptorIndex.getCommit(commit.getFirstParentCommit());
        }
        return commit;
    }

    @Override
    public PreCommit3Result pollPreCommitResults(String token) throws StorageException {
        CommitDescriptor commit = PreCommit3Service.decodeToken(token);
        HistoryAccessOption historyAccess = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        PreCommitUploadStagingIndex stagingIndex = this.openProjectIndex(PreCommitUploadStagingIndex.class, historyAccess);
        PreCommitUploadCommit commitInfo = (PreCommitUploadCommit)stagingIndex.getCommitInfo();
        if (commitInfo == null || !commitInfo.getCommit().equals((Object)commit)) {
            this.openGlobalIndex(PrecommitStatisticsIndex.class).terminateTask(this.serviceInfo.getInternalId(), token, this.getUser(), PrecommitStatisticsIndex.EPrecommitTaskTerminationReason.PRECOMMIT_BRANCH_PURGED);
            return PreCommit3StandardErrors.createResultForPreCommit3BranchMissingDuringPoll();
        }
        if (!this.preCommitResultsReady(commit)) {
            this.openGlobalIndex(PrecommitStatisticsIndex.class).logPollingEvent(this.serviceInfo.getInternalId(), token, this.getUser());
            return new PreCommit3Result(token, Collections.emptyList(), null);
        }
        ArrayList paths = new ArrayList();
        paths.addAll(commitInfo.getNewFiles().extractFirstList());
        paths.addAll(commitInfo.getChangedFiles().extractFirstList());
        TrackedFindingsIndex findingsIndex = (TrackedFindingsIndex)this.getProjectStorageSystem().openProjectIndex(TrackedFindingsIndex.class, historyAccess);
        List<TrackedFinding> allFindings = new ArrayList<TrackedFinding>();
        for (List findings : findingsIndex.getFindings(UniformPathCompatibilityUtil.convertCollection(paths))) {
            if (findings == null) continue;
            allFindings.addAll(findings);
        }
        allFindings = this.applyBlacklistFilter(allFindings, commit);
        this.openGlobalIndex(PrecommitStatisticsIndex.class).terminateTask(this.serviceInfo.getInternalId(), token, this.getUser(), PrecommitStatisticsIndex.EPrecommitTaskTerminationReason.SUCCESSFUL_TERMINATION);
        return new PreCommit3Result(null, Collections.emptyList(), allFindings);
    }

    @VisibleForTesting
    static CommitDescriptor decodeToken(String token) {
        return CommitDescriptor.fromServiceCallFormat((String)new String(Base64.getDecoder().decode(token), StandardCharsets.UTF_8));
    }

    private boolean preCommitResultsReady(CommitDescriptor commit) throws StorageException {
        RepositoryLogIndex logIndex = (RepositoryLogIndex)this.getProjectStorageSystem().openProjectIndex(RepositoryLogIndex.class, null);
        if (logIndex.getEntry(commit) == null) {
            return false;
        }
        Set commitsInProgress = CollectionUtils.mapToSet((Collection)this.openProjectIndex(ProjectAnalysisProgressIndex.class, null).getProgress(), RevisionAnalysisProgress::commit);
        return !commitsInProgress.contains(commit);
    }

    @Override
    public void clearPreCommitBranch(String commitId, String repositoryParentBranchName) throws StorageException {
        if (commitId != null) {
            this.deletePreCommitBranch(PreCommitUtils.createPrecommitBranchNameForCommitId((String)this.getUser().getUsername(), (String)commitId));
        } else if (repositoryParentBranchName != null) {
            this.deletePreCommitBranch(PreCommitUtils.createPrecommitBranchNameForBranchName((String)this.getUser().getUsername(), (String)repositoryParentBranchName));
        } else {
            try (SilentAutoClosable ignoredUnlockAction = PreCommitUploadStagingIndex.obtainLock((ILockProvider)this.serviceInfo.getLockProvider(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId());){
                IBranchingLayer preCommitStagingLayer = this.getProjectStorageSystem().openBranchingLayer(PreCommitUploadStagingIndex.class);
                Set branchesToDelete = preCommitStagingLayer.getCommitInfos().stream().map(IBranchCommitInfo::getBranchName).filter(PreCommitUtils::isPrecommitBranchName).filter(branch -> this.getUser().getUsername().equals(PreCommitUtils.extractPrecommitUserName((String)branch))).collect(Collectors.toSet());
                for (String preCommitBranch : branchesToDelete) {
                    this.deletePreCommitBranch(preCommitBranch);
                }
            }
        }
    }

    private void deletePreCommitBranch(String preCommitBranch) throws StorageException {
        try (SilentAutoClosable ignoredUnlockAction = PreCommitUploadStagingIndex.obtainLock((ILockProvider)this.serviceInfo.getLockProvider(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId());){
            IBranchingLayer branchingLayer = this.openBranchingLayerInProject("pre-commit-staging", PreCommitUploadStagingIndex.class);
            PreCommitUtils.deletePrecommitBranches((IBranchingLayer)branchingLayer, List.of(preCommitBranch), (InternalProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer(), (String)"Scheduled due to pre-commit upload.");
        }
    }

    private Optional<String> checkForLicenseViolation() throws StorageException {
        ESystemHealthCheck.CheckResult licenseStatus = ESystemHealthCheck.LICENSE.performCheck(this.serviceInfo.getIndexLayer());
        if (licenseStatus.status() == EHealthCheckStatus.CRITICAL) {
            return Optional.of(licenseStatus.message());
        }
        return Optional.empty();
    }

    private List<TrackedFinding> applyBlacklistFilter(List<TrackedFinding> findings, CommitDescriptor commit) throws StorageException {
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(this.serviceInfo.getPrimaryPublicId(), (ProjectStorageSystem)this.getProjectStorageSystem(), this.getIndexLayer());
        Map flaggedFindings = new CodeFindingsRetriever((ProjectStorageSystem)this.getProjectStorageSystem()).getFlaggedFindings(findings, commit);
        List extendedFindings = ExtendedTrackedFindingUtils.fromTrackedFindings(findings, (FindingsCalculationInfo)calculationInfo, (Map)flaggedFindings);
        List allExtendedFindings = BasicFindingFilterUtils.filterByFindingExclusionType((List)extendedFindings, (EBlacklistingOption)EBlacklistingOption.EXCLUDED, (EPendingExclusionOption)EPendingExclusionOption.ALL);
        return CollectionUtils.map((Collection)allExtendedFindings, TrackedFinding::new);
    }
}

