/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.git.common.EVotingConnectorOption;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@Path(value="api/projects/{project}/connectors")
public class ProjectConnectorsService
extends ApiBase {
    @GET
    @Path(value="statuses")
    @Operation(summary="Get connector status details", description="Returns detailed status information for each connector in a project", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<ProjectConnectorStatus> getProjectConnectorStatusDetails() throws StorageException {
        ProjectConnectorStatusIndex connectorStatusIndex = this.openProjectIndex(ProjectConnectorStatusIndex.class, null);
        return connectorStatusIndex.getAllStatuses();
    }

    @PUT
    @Path(value="voting-options/{votingOption}")
    @Operation(summary="Enable or disable voting option", description="Enable or disable the given kind of voting for all connectors of the project which support it.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public void enableVotingOption(@PathParam(value="project") PublicProjectId projectId, @PathParam(value="votingOption") EVotingConnectorOption votingOption, @Parameter(description="Whether to enable the given voting type for this project") @DefaultValue(value="true") @QueryParam(value="enable") boolean enable) throws StorageException {
        this.updateOptionInAllConnectors(projectId, votingOption.getOptionName(), Boolean.toString(enable));
    }

    private void updateOptionInAllConnectors(PublicProjectId projectId, String optionName, String value) throws StorageException {
        IndexLayer indexLayer = this.getIndexLayer();
        GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(this.getUser().getUsername(), indexLayer, (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION);
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        ArrayList<ProjectConfigurationException> configurationExceptions = new ArrayList<ProjectConfigurationException>();
        UnmodifiableList connectors = projectConfiguration.getConnectors();
        for (int i = 0; i < connectors.size(); ++i) {
            ConnectorConfiguration connector = (ConnectorConfiguration)connectors.get(i);
            try {
                this.setConnectorOptionIfExists(context, projectId, connector, optionName, value, i);
                continue;
            }
            catch (ProjectConfigurationException e) {
                LogManager.getLogger().warn("Connector validation failed: " + e.getMessage(), (Throwable)e);
                configurationExceptions.add(e);
            }
        }
        projectMetaIndex.setValue((Serializable)projectConfiguration, ProjectConfiguration.class);
        if (!configurationExceptions.isEmpty()) {
            List<String> errorMessages = configurationExceptions.stream().map(Throwable::getMessage).collect(Collectors.toList());
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ConnectorValidationErrorResponseEntity("Some connectors could not be updated.", errorMessages)).build());
        }
    }

    private void setConnectorOptionIfExists(ConfigurationInitializationContext context, PublicProjectId projectId, ConnectorConfiguration connector, String optionName, String value, int connectorIndex) throws ProjectConfigurationException {
        if (connector.getOptionValue(optionName) != null) {
            ConnectorConfiguration connectorCopy = (ConnectorConfiguration)SerializationUtils.cloneBySerialization((Serializable)connector);
            connectorCopy.setOptionValue(optionName, value);
            try {
                ConnectorUtils.loadAndValidateConnector((ConnectorConfiguration)connectorCopy, (ConfigurationInitializationContext)context, (InternalProjectId)this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId), (Integer)connectorIndex);
            }
            catch (StorageException e) {
                throw new ProjectConfigurationException((Throwable)e);
            }
            connector.setOptionValue(optionName, value);
        }
    }

    @ExportToTypeScript
    public static class ConnectorValidationErrorResponseEntity {
        private static final String MESSAGE_PROPERTY = "message";
        private static final String ERROR_LIST_PROPERTY = "errorList";
        @JsonProperty(value="message")
        private final String message;
        @JsonProperty(value="errorList")
        private final List<String> errorMessages;

        @JsonCreator
        public ConnectorValidationErrorResponseEntity(@JsonProperty(value="message") String message, @JsonProperty(value="errorList") List<String> errorMessages) {
            this.message = message;
            this.errorMessages = errorMessages;
        }
    }
}

