/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.service.AnalysisProfileUsageInfoWithProjects;
import com.teamscale.index.configuration.service.AnalysisProfileWithProjects;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/analysis-profiles")
public class AnalysisProfileInfoService
extends ApiBase {
    @GET
    @Operation(summary="Get analysis profile usage", description="Returns a list of AnalysisProfileUsageInfoWithProjects indicating the list of referenced projects for each analysis profile")
    @RequiresNoPermission(description="No permissions needed, as the service will only return names of analysis profiles visible to current user.")
    @Path(value="with-referenced-projects")
    public List<AnalysisProfileUsageInfoWithProjects> getAnalysisProfileUsageInfo() throws StorageException {
        Map<String, AnalysisProfileUsageInfoWithProjects> projectsByProfile = AnalysisProfileInfoService.getProjectsByProfile(this.getIndexLayer().openProjectIndex(), this.getPermissions(), false, this.serviceInfo.getIndexLayer());
        List<AnalysisProfile> visibleAnalysisProfiles = PermissionFilterUtils.getVisibleAnalysisProfiles(this.getPermissions(), this.openGlobalIndex(AnalysisProfileIndex.class));
        ArrayList<AnalysisProfileUsageInfoWithProjects> result = new ArrayList<AnalysisProfileUsageInfoWithProjects>();
        AnalysisProfileVersionedIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        for (AnalysisProfile analysisProfile : visibleAnalysisProfiles) {
            String profileName = analysisProfile.getName();
            if (projectsByProfile.containsKey(profileName)) {
                result.add(projectsByProfile.get(profileName));
                continue;
            }
            AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory analysisProfileVersionHistory = analysisProfileIndex.getAnalysisProfileVersionHistory(profileName);
            if (analysisProfileVersionHistory == null) continue;
            result.add(new AnalysisProfileUsageInfoWithProjects(profileName, new ListMap(), false, analysisProfileVersionHistory, (Set)analysisProfile.getLanguages()));
        }
        return result;
    }

    @GET
    @Operation(summary="Get analysis profile with referencing projects", description="Returns an analysis profile annotated with the list of projects using the profile")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    @Path(value="{analysisProfileName}/with-referenced-projects")
    public AnalysisProfileWithProjects getAnalysisProfileWithProjects(@PathParam(value="analysisProfileName") String analysisProfileName) throws StorageException {
        IndexLayer indexLayer = this.getIndexLayer();
        AnalysisProfile analysisProfile = ((AnalysisProfileIndex)indexLayer.openGlobalIndex(AnalysisProfileIndex.class)).getProfile(analysisProfileName);
        if (analysisProfile == null) {
            throw new NotFoundException("Profile '" + analysisProfileName + "' not found.");
        }
        Map<String, AnalysisProfileUsageInfoWithProjects> projectsByProfile = AnalysisProfileInfoService.getProjectsByProfile(this.getIndexLayer().openProjectIndex(), this.getPermissions(), true, this.serviceInfo.getIndexLayer());
        String profileName = analysisProfile.getName();
        ListMap codeScopesByReferencedProjects = new ListMap();
        boolean projectsMissingBecauseOfPermissions = false;
        if (projectsByProfile.containsKey(profileName)) {
            AnalysisProfileUsageInfoWithProjects analysisProfileUsageInfoWithProjects = projectsByProfile.get(profileName);
            codeScopesByReferencedProjects = analysisProfileUsageInfoWithProjects.getCodeScopesByReferencedProjectIds();
            projectsMissingBecauseOfPermissions = analysisProfileUsageInfoWithProjects.areProjectsMissingBecauseOfPermissions();
        }
        return new AnalysisProfileWithProjects(analysisProfile, codeScopesByReferencedProjects, projectsMissingBecauseOfPermissions);
    }

    public static Map<String, AnalysisProfileUsageInfoWithProjects> getProjectsByProfile(ProjectIndex projectIndex, ServicePermissions permissions, boolean includeReanalyzing, IndexLayer indexLayer) throws StorageException {
        HashMap<String, AnalysisProfileUsageInfoWithProjects> projectsUsingProfile = new HashMap<String, AnalysisProfileUsageInfoWithProjects>();
        List projectInfos = projectIndex.getAllProjectInfos();
        List projectIds = CollectionUtils.map((Collection)projectInfos, ProjectInfo::getPrimaryPublicId);
        for (int i = 0; i < projectIds.size(); ++i) {
            AnalysisProfileInfoService.determineProfileInfoForProject((PublicProjectId)projectIds.get(i), (ProjectInfo)projectInfos.get(i), projectsUsingProfile, permissions, includeReanalyzing, indexLayer);
        }
        return projectsUsingProfile;
    }

    private static void determineProfileInfoForProject(PublicProjectId projectId, ProjectInfo projectInfo, Map<String, AnalysisProfileUsageInfoWithProjects> projectsUsingProfile, ServicePermissions permissions, boolean includeReanalyzing, IndexLayer indexLayer) throws StorageException {
        if (projectInfo.isDeleting()) {
            return;
        }
        if (projectInfo.isReanalyzing() && !includeReanalyzing) {
            return;
        }
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class);
        if (projectConfiguration == null) {
            return;
        }
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = (AnalysisProfileVersionedIndex)indexLayer.openGlobalStorageSystem().openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)indexLayer.openGlobalIndex(AnalysisProfileIndex.class);
        for (CodeScopeName codeScope : projectConfiguration.getCodeScopeNames()) {
            AnalysisProfileUsageInfoWithProjects analysisProfileUsageInfoWithProjects = projectsUsingProfile.computeIfAbsent(projectConfiguration.getAnalysisProfileName(codeScope), analysisProfileName -> AnalysisProfileInfoService.getAnalysisProfileUsageInfoWithProjects(analysisProfileVersionedIndex, analysisProfileIndex, analysisProfileName));
            if (!permissions.userHasProjectPermission((IProjectId)projectInfo.getInternalId(), EProjectPermission.VIEW)) {
                analysisProfileUsageInfoWithProjects.setProjectsMissingBecauseOfPermissions(true);
                continue;
            }
            analysisProfileUsageInfoWithProjects.getCodeScopesByReferencedProjectIds().add((Object)projectInfo.getPrimaryPublicId(), (Object)codeScope);
        }
    }

    private static @NonNull AnalysisProfileUsageInfoWithProjects getAnalysisProfileUsageInfoWithProjects(AnalysisProfileVersionedIndex analysisProfileVersionedIndex, AnalysisProfileIndex analysisProfileIndex, String analysisProfileName) {
        try {
            AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory history = analysisProfileVersionedIndex.getAnalysisProfileVersionHistory(analysisProfileName);
            if (history != null) {
                AnalysisProfile profile = analysisProfileIndex.getProfile(analysisProfileName);
                UnmodifiableSet languages = profile.getLanguages();
                return new AnalysisProfileUsageInfoWithProjects(analysisProfileName, new ListMap(), false, Long.valueOf(history.getLatestVersion().lastEdited()), history.getLatestVersion().versionNumber(), (Set)languages);
            }
        }
        catch (StorageException storageException) {
            // empty catch block
        }
        return new AnalysisProfileUsageInfoWithProjects(analysisProfileName, new ListMap(), false, Long.valueOf(DateTimeUtils.millisNow()), 0);
    }
}

