/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.gitlab_creation_wizard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.data.GitLabProject;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/gitlab/{credentialsName}")
public class GitlabRepositoriesService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Gets GitLab repositories for an account", description="Get all GitLab repositories that the current user has maintainer access to.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public List<GitLabProject> fetchGitlabProjects(@Parameter(description="Name of the external accounts") @PathParam(value="credentialsName") String credentialsName) throws StorageException, ServiceCallException {
        return this.getGitLabClient(credentialsName).listProjectsUserHasMaintainerAccessTo();
    }

    @GET
    @Path(value="languages")
    @Operation(summary="Get GitLab repository languages", description="Gets all languages associated with a GitLab repository, including their usage percentages in the project codebase.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public List<ProjectLanguage> getLanguagesForGitlabProject(@Parameter(description="Name of the external account") @PathParam(value="credentialsName") String credentialsName, @Parameter(description="ID of the GitLab repository") @QueryParam(value="repoId") String projectId) throws StorageException, ServiceCallException {
        GitLabClient client = this.getGitLabClient(credentialsName);
        Map languagesMapFromGitLab = client.getLanguagesForProject(projectId).getLanguages();
        return this.createResult(languagesMapFromGitLab);
    }

    private GitLabClient getGitLabClient(String credentialsName) throws StorageException {
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)this.getIndexLayer().openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials externalCredentials = externalCredentialsIndex.getExternalCredentials(credentialsName);
        if (externalCredentials == null) {
            throw new StorageException("User not found.");
        }
        return new GitLabClient(externalCredentials.uri, externalCredentials.password, LOGGER);
    }

    private List<ProjectLanguage> createResult(Map<String, Double> languagesMapFromGitLab) throws StorageException {
        return languagesMapFromGitLab.entrySet().stream().map(entry -> ProjectLanguage.createInstance((String)entry.getKey(), (Double)entry.getValue())).collect(Collectors.toMap(ProjectLanguage::language, projectLanguage -> projectLanguage, (v1, v2) -> new ProjectLanguage(v1.language, v1.usagePercentage + v2.usagePercentage, v1.isSupported))).values().stream().toList();
    }

    public record ProjectLanguage(@JsonProperty String language, @JsonProperty double usagePercentage, @JsonProperty boolean isSupported) {
        private static ProjectLanguage createInstance(String languageName, double usage) {
            List supportedLanguages = AnalysisProfileUtils.getSupportedLanguages();
            for (ELanguage supportedLanguage : supportedLanguages) {
                if (!ProjectLanguage.isSupported(languageName, supportedLanguage)) continue;
                return new ProjectLanguage(supportedLanguage.name(), usage, true);
            }
            return new ProjectLanguage(languageName, usage, false);
        }

        private static boolean isSupported(String languageName, ELanguage supportedLanguage) {
            return supportedLanguage.name().equalsIgnoreCase(languageName) || Arrays.stream(supportedLanguage.getReadableName().split("/")).anyMatch(readableName -> readableName.equalsIgnoreCase(languageName)) || Arrays.stream(supportedLanguage.getFileExtensions()).anyMatch(extension -> languageName.equalsIgnoreCase((String)extension));
        }
    }
}

