/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.resource.TokenElementServiceUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class ReportUtils {
    public static @NonNull UniformPath determineUniformPath(ProjectBranchPath projectBranchPath) {
        if (!StringUtils.isEmpty((String)projectBranchPath.getPath())) {
            return UniformPathCompatibilityUtil.convert((String)projectBranchPath.getPath());
        }
        return UniformPath.codeRoot();
    }

    public static UnresolvedCommitDescriptor buildCommit(String branch, long timestamp) {
        if (branch == null || branch.isEmpty()) {
            branch = null;
        }
        return new UnresolvedCommitDescriptor(branch, timestamp);
    }

    public static String determineBranch(IStorageInfo projectStorageInfo, ProjectBranchPath projectBranchPath) throws StorageException {
        if (projectBranchPath.getBranch() != null) {
            return projectBranchPath.getBranch();
        }
        return ((MetaIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
    }

    public static @Nullable FormattedTokenElementInfo loadSourceCodeForPath(String uniformPath, IStorageInfo projectStorageInfo, HistoryAccessOption historyAccessOption) throws StorageException {
        TokenElementIndex index = (TokenElementIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        TokenElementInfo content = index.getTokenElement(uniformPath);
        if (content == null) {
            content = ReportUtils.getContentFromParentCommit(uniformPath, historyAccessOption, projectStorageInfo);
        }
        if (content == null) {
            return null;
        }
        ExtendedResourceTypeIndex extendedResourceTypeIndex = (ExtendedResourceTypeIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(ExtendedResourceTypeIndex.class, historyAccessOption);
        EnumSet extendedResourceTypes = extendedResourceTypeIndex.getResourceTypes(uniformPath);
        return TokenElementServiceUtils.createFormattedElementInfo(content, historyAccessOption, projectStorageInfo.getProjectStorageSystem(), extendedResourceTypes);
    }

    private static @Nullable TokenElementInfo getContentFromParentCommit(String uniformPath, HistoryAccessOption historyAccessOption, IStorageInfo projectStorageInfo) throws StorageException {
        UnresolvedCommitDescriptor unresolvedParentCommitDescriptor = new UnresolvedCommitDescriptor(historyAccessOption.getBranchName(), historyAccessOption.getTimestamp(), 1);
        CommitDescriptor parentCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedParentCommitDescriptor, () -> ((IStorageInfo)projectStorageInfo).getProjectStorageSystem());
        TokenElementIndex index = (TokenElementIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(TokenElementIndex.class, "content", HistoryAccessOption.readCommit((CommitDescriptor)parentCommit));
        return index.getTokenElement(uniformPath);
    }

    public static String getMetricSchemaAssertionErrorMessage(MetricDirectorySchema schema, List<String> metricNames) {
        return "The following metrics are missing to rerender the report slides: " + metricNames.stream().filter(name -> schema.getAllEntries().stream().noneMatch(schemaEntry -> schemaEntry.getName().equals(name))).collect(Collectors.joining(", ")) + ". To fix this issue, please check that these metrics are enabled in the corresponding analysis profile. If they were disabled intentionally, then delete the report slides that use the affected metrics and try again.";
    }
}

