/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.merge_request.MetricAssessmentComputation;
import com.teamscale.index.metrics.assessment.GroupAssessment;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.quality_report.QualityArtifactProfile;
import com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ReportUtils;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class SystemQualityOverviewSlideRenderer
extends SlideRendererBase<SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters> {
    public SystemQualityOverviewSlideRenderer(SlideRenderContext<SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public SystemQualityOverviewSlide.SystemQualityOverviewSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException, MetricThresholdConfigurationException {
        List<GroupAssessment> assessments = this.computeAssessmentsBasedOnThresholdProfile();
        ArrayList resultAssessments = new ArrayList();
        assessments.forEach(group -> {
            List resultMetrics = group.getMetrics().stream().filter(metric -> ((SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters)this.getParameters()).getMetricNames().contains(metric.getMetricName())).collect(Collectors.toList());
            resultAssessments.add(new GroupAssessment(group.getName(), group.getRating(), resultMetrics));
        });
        return new SystemQualityOverviewSlide.SystemQualityOverviewSlideResult(resultAssessments, this.getSlideCommentRenderData(((SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters)this.getParameters()).getProjectBranchPath(), ((SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters)this.getParameters()).getComments()));
    }

    private List<GroupAssessment> computeAssessmentsBasedOnThresholdProfile() throws StorageException, MetricThresholdConfigurationException {
        IStorageInfo projectAwareStorageInfo = this.renderContext.resolveProjectAndReturnLocalStorageInfo(((SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters)this.getParameters()).getProjectBranchPath());
        QualityArtifactProfile qualityArtifactProfile = this.getReportProfile();
        UniformPath uniformPath = ReportUtils.determineUniformPath(((SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters)this.getParameters()).getProjectBranchPath());
        String branch = ReportUtils.determineBranch(projectAwareStorageInfo, ((SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters)this.getParameters()).getProjectBranchPath());
        UnresolvedCommitDescriptor endCommitString = ReportUtils.buildCommit(branch, qualityArtifactProfile.getEndWithType().getTimestamp());
        UnresolvedCommitDescriptor baselineCommitString = ReportUtils.buildCommit(branch, qualityArtifactProfile.getBaselineWithType().getTimestamp());
        MetricAssessmentComputation assessmentComputation = this.buildMetricAssessmentComputer(projectAwareStorageInfo, qualityArtifactProfile);
        return assessmentComputation.computeAssessment(uniformPath.toString(), this.determineHistoryOption(endCommitString, projectAwareStorageInfo.getInternalId()), this.determineHistoryOption(baselineCommitString, projectAwareStorageInfo.getInternalId()), false);
    }

    private MetricAssessmentComputation buildMetricAssessmentComputer(IStorageInfo projectAwareStorageInfo, QualityArtifactProfile qualityArtifactProfile) throws StorageException {
        ProjectStorageSystem projectStorageSystem = projectAwareStorageInfo.getProjectStorageSystem();
        MetricSchemaRetrieverFactory schemaRetrieverFactory = new MetricSchemaRetrieverFactory(projectStorageSystem);
        MetricThresholdEvaluator configurationInterval = ProjectThresholdConfigurationUtils.getThresholdEvaluator((String)qualityArtifactProfile.getThresholdProfileName(), (IStorageInfo)projectAwareStorageInfo, (MetricSchemaRetrieverFactory)schemaRetrieverFactory);
        MetricDataRetrieverFactory metricDataRetrieverFactory = new MetricDataRetrieverFactory(projectStorageSystem, projectAwareStorageInfo.getGlobalStorageSystem(), this.renderContext.getUser(), schemaRetrieverFactory);
        return new MetricAssessmentComputation(configurationInterval, metricDataRetrieverFactory, projectStorageSystem, IParallelTaskExecutor.sameThread());
    }

    private HistoryAccessOption determineHistoryOption(UnresolvedCommitDescriptor unresolvedCommitDescriptor, InternalProjectId internalId) throws StorageException {
        return HistoryAccessOption.readCommit((CommitDescriptor)UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedCommitDescriptor, () -> this.renderContext.getIndexLayer().openProjectStorageSystem((IProjectId)internalId)));
    }
}

