/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.NumbersAwareStringComparator;

public class BranchesInfo {
    private static final Logger LOGGER = LogManager.getLogger(BranchesInfo.class);
    @JsonProperty(value="liveBranches")
    private final List<String> liveBranches = new ArrayList<String>();
    @JsonProperty(value="deletedBranches")
    private final List<String> deletedBranches = new ArrayList<String>();
    @JsonProperty(value="anonymousBranches")
    private final List<String> anonymousBranches = new ArrayList<String>();
    @JsonProperty(value="virtualBranches")
    private final List<String> virtualBranches = new ArrayList<String>();
    @JsonProperty(value="currentBranchesCount")
    private int currentBranchesCount = 0;

    public void addLiveBranches(Collection<String> liveBranches) {
        this.liveBranches.addAll(liveBranches);
        this.currentBranchesCount += liveBranches.size();
        this.verifyNoOverlaps();
    }

    public void addDeletedBranches(Collection<String> deletedBranches) {
        this.deletedBranches.addAll(deletedBranches);
        this.currentBranchesCount += deletedBranches.size();
        this.verifyNoOverlaps();
    }

    public void addAnonymousBranches(Collection<String> anonymousBranches) {
        this.anonymousBranches.addAll(anonymousBranches);
        this.currentBranchesCount += anonymousBranches.size();
        this.verifyNoOverlaps();
    }

    public void addVirtualBranches(Collection<String> virtualBranches) {
        this.virtualBranches.addAll(virtualBranches);
        this.currentBranchesCount += virtualBranches.size();
        this.verifyNoOverlaps();
    }

    private void verifyNoOverlaps() {
        if (!CollectionUtils.intersectionSet(this.deletedBranches, (Collection[])new Collection[]{this.liveBranches}).isEmpty()) {
            LOGGER.error("Deleted branches has an overlap with live branches");
        }
        if (!CollectionUtils.intersectionSet(this.anonymousBranches, (Collection[])new Collection[]{this.liveBranches}).isEmpty()) {
            LOGGER.error("Anonymous branches has an overlap with live branches");
        }
        if (!CollectionUtils.intersectionSet(this.anonymousBranches, (Collection[])new Collection[]{this.deletedBranches}).isEmpty()) {
            LOGGER.error("Anonymous branches has an overlap with deleted branches");
        }
        if (!CollectionUtils.intersectionSet(this.virtualBranches, (Collection[])new Collection[]{this.liveBranches}).isEmpty()) {
            LOGGER.error("Virtual branches has an overlap with live branches");
        }
        if (!CollectionUtils.intersectionSet(this.virtualBranches, (Collection[])new Collection[]{this.deletedBranches}).isEmpty()) {
            LOGGER.error("Virtual branches has an overlap with deleted branches");
        }
        if (!CollectionUtils.intersectionSet(this.virtualBranches, (Collection[])new Collection[]{this.anonymousBranches}).isEmpty()) {
            LOGGER.error("Virtual branches has an overlap with anonymous branches");
        }
    }

    public List<String> getLiveBranches() {
        return ImmutableList.copyOf(this.liveBranches);
    }

    public List<String> getDeletedBranches() {
        return ImmutableList.copyOf(this.deletedBranches);
    }

    public List<String> getAnonymousBranches() {
        return ImmutableList.copyOf(this.anonymousBranches);
    }

    public List<String> getVirtualBranches() {
        return ImmutableList.copyOf(this.virtualBranches);
    }

    public int getCurrentBranchesCount() {
        return this.currentBranchesCount;
    }

    public void sortBranches() {
        this.liveBranches.sort((Comparator<String>)NumbersAwareStringComparator.INSTANCE);
        this.deletedBranches.sort((Comparator<String>)NumbersAwareStringComparator.INSTANCE);
        this.anonymousBranches.sort((Comparator<String>)NumbersAwareStringComparator.INSTANCE);
        this.virtualBranches.sort((Comparator<String>)NumbersAwareStringComparator.INSTANCE);
    }
}

