/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository.github.debug;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.index.repository.git.github.GitHubCheckRunMaintenanceTrigger;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/github/debug/check-runs")
public class GitHubCheckRunDebugService
extends ApiBase {
    @POST
    @Operation(summary="Clean up pending check runs", description="Runs the GitHub check run cleanup maintenance trigger to skip all pending check runs which have been open for more than a day.", tags={"Voting Connectors", "Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Path(value="cleanup")
    public void runGitHubCheckRunCleanup() throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleMaintenanceTrigger(GitHubCheckRunMaintenanceTrigger.class, "GitHub check run cleanup requested via debug service.", this.getIndexLayer());
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Cancels all in-progress check runs for all projects", description="Cancels all check runs for all projects which were posted by Teamscale and are still in progress. This does *not* cancel any ongoing pull request analyses but only concludes the preliminary check run. Teamscale will open new check runs if required.", tags={"Debugging", "Merge Requests", "Voting Connectors"})
    @Path(value="cancel-all")
    public Response cancelAllTeamscaleInProgressCheckRuns() throws StorageException, ProjectConfigurationException, InterruptedException {
        for (InternalProjectId projectId : ((ProjectIndex)this.getIndexLayer().openGlobalIndex(ProjectIndex.class)).getAllInternalProjectIds()) {
            GitHubCheckRunMaintenanceTrigger.closeCheckRunsInProject((IndexLayer)this.getIndexLayer(), (InternalProjectId)projectId, checkRun -> false, () -> false);
        }
        return Response.ok().build();
    }
}

