/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.google.common.collect.Lists;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.search.AdvancedCodeSearchService;
import com.teamscale.service.search.CodeSearchTreemapBuilderBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class AdvancedCodeSearchTreeMapBuilder
extends CodeSearchTreemapBuilderBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TokenElementIndex tokenIndex;
    private final List<AdvancedCodeSearchService.CodeSearchMatchResult> results;

    protected AdvancedCodeSearchTreeMapBuilder(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, int colorMetricIndex, Object colorMetricDefault, Color baseColor, String searchPattern, TokenElementIndex tokenIndex, boolean isColorGradationActive, List<AdvancedCodeSearchService.CodeSearchMatchResult> results) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, new MetricTreemapBuilderParameters(includePattern, excludePattern, colorMetricIndex, colorMetricDefault, baseColor), searchPattern, isColorGradationActive);
        this.tokenIndex = tokenIndex;
        this.results = results;
    }

    @Override
    protected FilteredTreeMapWrapper computeSearchCountValues(List<MetricDirectoryEntry> entries) throws StorageException {
        int filesIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Files");
        int locIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Lines of Code");
        int overallFiles = (int)entries.get(0).getDoubleValue(filesIndex);
        CodeSearchTreemapBuilderBase.SearchHitData searchHitData = new CodeSearchTreemapBuilderBase.SearchHitData();
        List batchedEntries = Lists.partition(entries, (int)500);
        for (List entriesInBatch : batchedEntries) {
            List<String> cleanPaths = entriesInBatch.stream().map(entry -> UniformPathCompatibilityUtil.resolveToCodePath((String)entry.getUniformPath())).toList();
            List tokenElementInfos = this.tokenIndex.getTokenElements(cleanPaths);
            for (int i = 0; i < entriesInBatch.size(); ++i) {
                MetricDirectoryEntry entry2 = (MetricDirectoryEntry)entriesInBatch.get(i);
                TokenElementInfo tokenElementInfo = (TokenElementInfo)tokenElementInfos.get(i);
                if (tokenElementInfo == null) continue;
                int matchesCount = this.results.stream().filter(r -> r.getUniformPath().equals(UniformPathCompatibilityUtil.resolveToCodePath((String)entry2.getUniformPath()))).toList().size();
                searchHitData.updateDataForPath(matchesCount, entry2, locIndex);
            }
        }
        return new FilteredTreeMapWrapper(searchHitData.affectedPaths, this.treemap, overallFiles, searchHitData.affectedLoc, searchHitData.affectedFiles, searchHitData.overallHits);
    }

    protected static String getFilteredTokenString(String uniformPath, String text, List<IToken> tokens, Set<ETokenType.ETokenClass> tokenClasses) {
        if (tokens.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int nextTokenOffset = tokens.get(0).getOffset();
        for (IToken token : tokens) {
            if (tokenClasses.contains(token.getType().getTokenClass())) {
                if (tokenClasses.contains(ETokenType.ETokenClass.WHITESPACE) && AdvancedCodeSearchTreeMapBuilder.isValidRange(uniformPath, text, nextTokenOffset, token.getOffset())) {
                    builder.append(text, nextTokenOffset, token.getOffset());
                }
                builder.append(token.getText());
            }
            nextTokenOffset = token.getEndOffset() + 1;
        }
        return builder.toString();
    }

    private static boolean isValidRange(String uniformPath, String text, int start, int end) {
        if (start < 0 || start > end || end > text.length()) {
            LOGGER.warn("Found invalid range while processing " + uniformPath + ": " + start + " - " + end);
            return false;
        }
        return true;
    }
}

