/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.parse_log;

import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.RepositoryLastChangeUtils;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/parse-log")
public class ParseLogService
extends ApiBase {
    @GET
    @Path(value="element")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="List parse log of single element", description="Lists all parse log entries for the element with given uniform path.", tags={"Logging"})
    public List<ParseLogEntry> getParseLogElement(@QueryParam(value="uniform-path") @Parameter(description="The uniform path for which parse log entries should be retrieved.") String uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.", allowEmptyValue=true) UnresolvedCommitDescriptor commit) throws StorageException {
        Optional lastChange = RepositoryLastChangeUtils.findLastChangeForElement((String)uniformPath, (CommitDescriptor)this.resolve(commit), (boolean)true, (ProjectStorageSystem)this.getProjectStorageSystem(), (Logger)LogManager.getLogger());
        if (!lastChange.isPresent()) {
            return Collections.emptyList();
        }
        ParseLogIndex index = this.openProjectIndex(ParseLogIndex.class, null);
        List logs = index.getParseLogEntries(uniformPath, ((RepositoryLogEntryAggregate)lastChange.get()).getCommit());
        return CollectionUtils.sort((Collection)logs);
    }

    @GET
    @Path(value="all")
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @Operation(summary="List parse log of project", description="Lists all parse log entries for the project.", tags={"Logging"})
    public List<ParseLogEntry> listAllParseLogEntries(@Parameter(description="The logs will start at this given index.", allowEmptyValue=true) @QueryParam(value="start") @DefaultValue(value="0") int startIndex, @Parameter(description="Limits the number of returned logs to the given number.", allowEmptyValue=true) @QueryParam(value="max") @DefaultValue(value="50") int maxResults) throws StorageException {
        ParseLogIndex parseLogIndex = this.openProjectIndex(ParseLogIndex.class, null);
        List parseLogEntries = parseLogIndex.getAllParseLogEntries();
        Collections.sort(parseLogEntries);
        int start = Math.min(startIndex, parseLogEntries.size());
        int end = Math.min(start + maxResults, parseLogEntries.size());
        return parseLogEntries.subList(start, end);
    }
}

