/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.task.TaskUtils;
import com.teamscale.service.base.ESortOrder;
import com.teamscale.service.tasks.TaskServiceQueryOptions;
import jakarta.ws.rs.NotFoundException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;

public class TaskServiceFilterUtils {
    protected static List<Task> applyFiltersAndSort(TaskServiceQueryOptions params, List<Task> tasks) {
        tasks = TaskServiceFilterUtils.filterByStatus(params, tasks);
        tasks = TaskServiceFilterUtils.applyNonStatusFilters(params, tasks);
        TaskServiceFilterUtils.sortTasks(params, tasks);
        return tasks;
    }

    protected static List<Task> applyNonStatusFilters(TaskServiceQueryOptions params, List<Task> tasks) {
        tasks = TaskServiceFilterUtils.filterByTag(params, tasks);
        tasks = TaskServiceFilterUtils.filterByAssignee(params, tasks);
        tasks = TaskServiceFilterUtils.filterByAuthor(params, tasks);
        return tasks;
    }

    private static void sortTasks(TaskServiceQueryOptions params, List<Task> tasks) {
        Comparator<Task> comparator = params.getSortBy().createComparator();
        if (params.getSortOrder() == ESortOrder.DESCENDING) {
            comparator = comparator.reversed();
        }
        tasks.sort(comparator);
    }

    protected static List<Task> filterByIds(TaskServiceQueryOptions params, List<Task> tasks) {
        List<Integer> ids = params.getIds();
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return tasks;
        }
        return CollectionUtils.filter(tasks, task -> ids.contains(task.getId()));
    }

    private static List<Task> filterByTag(TaskServiceQueryOptions params, List<Task> tasks) {
        List<String> tags = params.getTags();
        if (CollectionUtils.isNullOrEmpty(tags)) {
            return tasks;
        }
        CaseInsensitiveStringSet caseInsensitiveTags = new CaseInsensitiveStringSet(tags);
        Predicate<Task> isContained = task -> {
            CaseInsensitiveStringSet taskSet = new CaseInsensitiveStringSet((Collection)task.getTags());
            return taskSet.containsAll((Collection)caseInsensitiveTags);
        };
        return CollectionUtils.filter(tasks, isContained);
    }

    protected static List<Task> filterByStatus(TaskServiceQueryOptions params, List<Task> tasks) {
        List<ETaskStatus> statuses = params.getStatuses();
        if (CollectionUtils.isNullOrEmpty(statuses)) {
            return tasks;
        }
        HashSet<ETaskStatus> statusSet = new HashSet<ETaskStatus>(statuses);
        return TaskUtils.filterTasksByStatus(tasks, statusSet);
    }

    private static List<Task> filterByAssignee(TaskServiceQueryOptions params, List<Task> tasks) {
        return CollectionUtils.filter(tasks, (Predicate)new UserTaskFilterPredicate("assignee", params, (assignees, task) -> assignees.contains(task.getAssignee())));
    }

    private static List<Task> filterByAuthor(TaskServiceQueryOptions params, List<Task> tasks) {
        return CollectionUtils.filter(tasks, (Predicate)new UserTaskFilterPredicate("author", params, (authors, task) -> authors.contains(task.getAuthor())));
    }

    protected static Task retrieveTask(TaskIndex taskIndex, int taskId) throws StorageException {
        Task task = taskIndex.getTask(taskId);
        if (task == null) {
            throw new NotFoundException("Task with provided ID " + taskId + " could not be found.");
        }
        return task;
    }

    private static class UserTaskFilterPredicate
    implements Predicate<Task> {
        private final Set<String> userSet;
        private BiPredicate<Set<String>, Task> isContained;

        private UserTaskFilterPredicate(String userFilterParameter, TaskServiceQueryOptions params, BiPredicate<Set<String>, Task> isContained) {
            this.isContained = isContained;
            List<String> users = null;
            if (userFilterParameter.equals("assignee")) {
                users = params.getAssignees();
            } else if (userFilterParameter.equals("author")) {
                users = params.getAuthors();
            }
            this.userSet = CollectionUtils.isNullOrEmpty(users) ? null : new HashSet<String>(users);
        }

        @Override
        public boolean test(Task task) {
            return this.userSet == null || this.isContained.test(this.userSet, task);
        }
    }
}

