/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.testgap.UnlinkedChangesTgaService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/unlinked-changes")
public class UnlinkedChangesService {
    @Context
    private ResourceContext resourceContext;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Checks if unlinked changes exist", description="Checks if methods have unlinked changes since a given baseline.", tags={"Test Gap Analysis", "Issues"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public boolean getHasUnlinkedChangesExist(@BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalParameters, @BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentQueryOptions) throws StorageException {
        UnlinkedChangesTgaService.UnlinkedChangesWrapper treemap = ((UnlinkedChangesTgaService)this.resourceContext.getResource(UnlinkedChangesTgaService.class)).getNonIssueTgaCommitsAndTreemap(timeIntervalParameters, coverageSourceParameters, assessmentQueryOptions);
        return !treemap.isEmpty();
    }
}

