/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.bitbucket.BitbucketInstallationRepositories;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerChangeRetriever;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerCodeInsightReportInProgressReporter;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryIdentifier;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerWebhookEventIndex;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/bitbucket-server/web-hook")
public class BitbucketServerWebHookService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String BITBUCKET_EVENT_HEADER_NAME = "X-Event-Key";

    public BitbucketServerWebHookService() {
        super(BitbucketServerChangeRetriever.class);
    }

    @POST
    @Operation(summary="Handles the incoming requests from the Bitbucket on-premise server.", description="Handles the incoming requests from the Bitbucket on-premise server and processes the request body depending on the event. The events which are handled by the service are 'repo:refs_changed', 'pr:opened', 'pr:modified', 'pr:merged', 'pr:declined' and 'pr:deleted'.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebHooks(@HeaderParam(value="X-Event-Key") String event, @RequestBody byte[] requestBody) throws StorageException, ServiceCallException, ProjectConfigurationException {
        return this.processWebHooks(event, requestBody, null);
    }

    public Response processWebHooks(String event, byte[] requestBody, @Nullable Consumer<PlatformRepositoryIdentifier> repositoryIdentifierConsumer) throws StorageException, ServiceCallException, ProjectConfigurationException {
        BitbucketServerRepositoryIdentifier repositoryIdentifier;
        String queryContent = StringUtils.bytesToString((byte[])requestBody);
        LOGGER.debug("Received a web hook request from Bitbucket Server with event \"{}\" and payload: {}", (Object)event, (Object)queryContent);
        if (event == null) {
            throw new BadRequestException("Missing X-Event-Key header!");
        }
        switch (event) {
            case "repo:refs_changed": {
                BitbucketServerRepositoryIdentifier bitbucketServerRepositoryIdentifier = this.handleRepoPushEvent(queryContent, event);
                break;
            }
            case "pr:opened": 
            case "pr:modified": 
            case "pr:merged": 
            case "pr:from_ref_updated": 
            case "pr:declined": {
                BitbucketServerRepositoryIdentifier bitbucketServerRepositoryIdentifier = this.handlePullRequestEvent(event, queryContent);
                break;
            }
            case "pr:deleted": {
                BitbucketServerRepositoryIdentifier bitbucketServerRepositoryIdentifier = this.handleDeletePullRequestEvent(queryContent, event);
                break;
            }
            default: {
                BitbucketServerRepositoryIdentifier bitbucketServerRepositoryIdentifier = repositoryIdentifier = null;
            }
        }
        if (repositoryIdentifierConsumer != null) {
            repositoryIdentifierConsumer.accept((PlatformRepositoryIdentifier)repositoryIdentifier);
        }
        return Response.ok().build();
    }

    private BitbucketServerRepositoryIdentifier handlePullRequestEvent(String event, String payload) throws BadRequestException, StorageException {
        BitbucketPullRequestEvent pullRequestPayload = BitbucketServerWebHookService.parsePullRequestPayload(payload);
        String actorName = null;
        if (pullRequestPayload.actor != null) {
            actorName = pullRequestPayload.actor.name;
        }
        BitbucketInstallationRepositories.InstallationRepository targetRepository = pullRequestPayload.pullRequest.targetBranch().repository();
        BitbucketServerRepositoryIdentifier repositoryIdentifier = new BitbucketServerRepositoryIdentifier(targetRepository.getProjectKey(), targetRepository.getSlug());
        this.updateBitbucketServerWebhookIndex(repositoryIdentifier, event);
        Optional cloneUrl = pullRequestPayload.pullRequest.targetBranch().repository().getHttpCloneUrl();
        if (event.equalsIgnoreCase("pr:from_ref_updated")) {
            this.postAnalysisInProgressReport(cloneUrl.orElse(null), pullRequestPayload.pullRequest, repositoryIdentifier);
        }
        this.scheduleMergeRequestUpdateTriggers(cloneUrl.orElse(repositoryIdentifier.asRepositoryName()), repositoryIdentifier.asRepositoryName(), pullRequestPayload.pullRequest.id(), BitbucketServerMergeRequestUpdateTrigger.class, actorName);
        return repositoryIdentifier;
    }

    private void postAnalysisInProgressReport(String cloneUrl, BitbucketServerPullRequest pullRequest, BitbucketServerRepositoryIdentifier repositoryIdentifier) throws StorageException {
        BitbucketServerCodeInsightReportInProgressReporter inProgressReporter = this.createInProgressReporter(cloneUrl, repositoryIdentifier);
        if (inProgressReporter != null) {
            BitbucketServerWebHookService.postAnalysisInProgress(inProgressReporter, pullRequest, (PlatformRepositoryIdentifier)repositoryIdentifier);
        }
    }

    private @Nullable BitbucketServerCodeInsightReportInProgressReporter createInProgressReporter(@Nullable String cloneUrl, BitbucketServerRepositoryIdentifier repositoryIdentifier) throws StorageException {
        try {
            return new BitbucketServerCodeInsightReportInProgressReporter(this.getIndexLayer(), repositoryIdentifier);
        }
        catch (ServiceCallException | ProjectConfigurationException e) {
            LOGGER.atError().withThrowable(e).log("Failed to create \"In Progress\" reporter for repository {} with clone URL '{}'. Pull requests will not have a pending report signalling that Teamscale analysis is in progress. Concluded reports will still be sent later regardless of this error.", (Object)repositoryIdentifier, (Object)cloneUrl);
            return null;
        }
    }

    private static void postAnalysisInProgress(BitbucketServerCodeInsightReportInProgressReporter reporter, BitbucketServerPullRequest pullRequest, PlatformRepositoryIdentifier repositoryIdentifier) {
        try {
            MergeRequestIdentifier mergeRequestIdentifier = new MergeRequestIdentifier(repositoryIdentifier.asRepositoryName(), pullRequest.id());
            String headRevision = pullRequest.sourceBranch().latestCommit();
            if (headRevision == null) {
                LOGGER.warn("No head revision provided for pull request {} of repository '{}'. \"In Progress\" report will not be posted.", (Object)pullRequest.id(), (Object)repositoryIdentifier.asRepositoryName());
                return;
            }
            reporter.reportAnalysisInProgress(headRevision, mergeRequestIdentifier);
        }
        catch (ServiceCallException | ProjectConfigurationException | StorageException e) {
            LOGGER.atError().withThrowable(e).log("Failed to post \"In Progress\" report to pull request {} of repository '{}': {}", (Object)pullRequest.id(), (Object)repositoryIdentifier.asRepositoryName(), (Object)e.getMessage());
        }
    }

    private BitbucketServerRepositoryIdentifier handleDeletePullRequestEvent(String payload, String event) throws BadRequestException, StorageException {
        BitbucketPullRequestEvent pullRequestPayload = BitbucketServerWebHookService.parsePullRequestPayload(payload);
        BitbucketServerRepositoryIdentifier repositoryIdentifier = new BitbucketServerRepositoryIdentifier(pullRequestPayload.pullRequest.targetBranch().repository().getProjectKey(), pullRequestPayload.pullRequest.targetBranch().repository().getSlug());
        this.updateBitbucketServerWebhookIndex(repositoryIdentifier, event);
        MergeRequestIdentifier identifier = new MergeRequestIdentifier(repositoryIdentifier.asRepositoryName(), pullRequestPayload.pullRequest.id());
        this.deleteMergeRequestsFromIndex(identifier);
        return repositoryIdentifier;
    }

    private static BitbucketPullRequestEvent parsePullRequestPayload(String payload) {
        try {
            return (BitbucketPullRequestEvent)JsonUtils.deserializeFromJson((String)payload, BitbucketPullRequestEvent.class);
        }
        catch (ConQATException e) {
            throw new BadRequestException("Invalid payload: " + e.getMessage(), (Throwable)e);
        }
    }

    private BitbucketServerRepositoryIdentifier handleRepoPushEvent(String payload, String event) throws BadRequestException, StorageException {
        BitbucketPushEvent pushPayload;
        try {
            pushPayload = (BitbucketPushEvent)JsonUtils.deserializeFromJson((String)payload, BitbucketPushEvent.class);
        }
        catch (ConQATException e) {
            throw new BadRequestException("Invalid payload: " + e.getMessage(), (Throwable)e);
        }
        BitbucketServerRepositoryIdentifier repositoryIdentifier = new BitbucketServerRepositoryIdentifier(pushPayload.repository.getProjectKey(), pushPayload.repository.getSlug());
        this.updateBitbucketServerWebhookIndex(repositoryIdentifier, event);
        String actorName = null;
        if (pushPayload.actor != null) {
            actorName = pushPayload.actor.name;
        }
        Optional cloneUrl = pushPayload.repository.getHttpCloneUrl();
        for (PushChangeDetails change : pushPayload.changes) {
            this.scheduleMergeRequestUpdateTriggersForAllPullRequests(cloneUrl.orElse(repositoryIdentifier.asRepositoryName()), repositoryIdentifier, change.refId, actorName);
        }
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)cloneUrl.orElse(repositoryIdentifier.asRepositoryName()), (IndexLayer)this.getIndexLayer(), null);
        return repositoryIdentifier;
    }

    private void scheduleMergeRequestUpdateTriggersForAllPullRequests(@Nullable String repositoryHttpUrl, BitbucketServerRepositoryIdentifier repositoryIdentifier, String extraJobParameter, @Nullable String webhookActor) throws StorageException {
        this.scheduleMergeRequestUpdateTriggers(Objects.requireNonNullElseGet(repositoryHttpUrl, () -> ((BitbucketServerRepositoryIdentifier)repositoryIdentifier).asRepositoryName()), repositoryIdentifier.asRepositoryName(), Long.MIN_VALUE, extraJobParameter, BitbucketServerMergeRequestUpdateTrigger.class, webhookActor);
    }

    private void updateBitbucketServerWebhookIndex(BitbucketServerRepositoryIdentifier repositoryIdentifier, String event) throws StorageException {
        boolean run = this.runForEachProjectWithRepository(repositoryIdentifier.asRepositoryName(), (projectInfo, projectStorageSystem) -> {
            try {
                BitbucketServerWebhookEventIndex index = (BitbucketServerWebhookEventIndex)projectStorageSystem.openProjectIndex(BitbucketServerWebhookEventIndex.class, null);
                index.addWebhookEvent(repositoryIdentifier.asRepositoryName(), event);
            }
            catch (StorageException e) {
                LOGGER.error("Failed to store webhook event '{}' for repository '{}'", new Supplier[]{() -> event, () -> repositoryIdentifier});
            }
        }, null);
        if (!run) {
            LOGGER.debug("Could not find any projects matching the received webhook event: {} for repository {}", new Supplier[]{() -> event, () -> repositoryIdentifier});
        }
    }

    @Override
    protected ERepositoryConnector getRepositoryConnectorType() {
        return ERepositoryConnector.BITBUCKET_SERVER;
    }

    private static class BitbucketPullRequestEvent {
        @JsonProperty(value="pullRequest")
        private BitbucketServerPullRequest pullRequest;
        @JsonProperty(value="actor")
        private BitBucketActor actor;

        private BitbucketPullRequestEvent() {
        }
    }

    private static class BitBucketActor {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="emailAddress")
        private String emailAddress;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="slug")
        private String slug;

        private BitBucketActor() {
        }
    }

    private static class BitbucketPushEvent {
        @JsonProperty(value="repository")
        private BitbucketInstallationRepositories.InstallationRepository repository;
        @JsonProperty(value="changes")
        private PushChangeDetails[] changes;
        @JsonProperty(value="actor")
        private BitBucketActor actor;

        private BitbucketPushEvent() {
        }
    }

    private static class PushChangeDetails {
        @JsonProperty(value="refId")
        private String refId;

        private PushChangeDetails() {
        }
    }
}

