/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.EncodingType;
import org.rocksdb.TableFormatConfig;

public class PlainTableConfig
extends TableFormatConfig {
    public static final int VARIABLE_LENGTH = 0;
    public static final int DEFAULT_BLOOM_BITS_PER_KEY = 10;
    public static final double DEFAULT_HASH_TABLE_RATIO = 0.75;
    public static final int DEFAULT_INDEX_SPARSENESS = 16;
    public static final int DEFAULT_HUGE_TLB_SIZE = 0;
    public static final EncodingType DEFAULT_ENCODING_TYPE = EncodingType.kPlain;
    public static final boolean DEFAULT_FULL_SCAN_MODE = false;
    public static final boolean DEFAULT_STORE_INDEX_IN_FILE = false;
    private int keySize_ = 0;
    private int bloomBitsPerKey_ = 10;
    private double hashTableRatio_ = 0.75;
    private int indexSparseness_ = 16;
    private int hugePageTlbSize_ = 0;
    private EncodingType encodingType_ = DEFAULT_ENCODING_TYPE;
    private boolean fullScanMode_ = false;
    private boolean storeIndexInFile_ = false;

    public PlainTableConfig setKeySize(int keySize) {
        this.keySize_ = keySize;
        return this;
    }

    public int keySize() {
        return this.keySize_;
    }

    public PlainTableConfig setBloomBitsPerKey(int bitsPerKey) {
        this.bloomBitsPerKey_ = bitsPerKey;
        return this;
    }

    public int bloomBitsPerKey() {
        return this.bloomBitsPerKey_;
    }

    public PlainTableConfig setHashTableRatio(double ratio) {
        this.hashTableRatio_ = ratio;
        return this;
    }

    public double hashTableRatio() {
        return this.hashTableRatio_;
    }

    public PlainTableConfig setIndexSparseness(int sparseness) {
        this.indexSparseness_ = sparseness;
        return this;
    }

    public long indexSparseness() {
        return this.indexSparseness_;
    }

    public PlainTableConfig setHugePageTlbSize(int hugePageTlbSize) {
        this.hugePageTlbSize_ = hugePageTlbSize;
        return this;
    }

    public int hugePageTlbSize() {
        return this.hugePageTlbSize_;
    }

    public PlainTableConfig setEncodingType(EncodingType encodingType) {
        this.encodingType_ = encodingType;
        return this;
    }

    public EncodingType encodingType() {
        return this.encodingType_;
    }

    public PlainTableConfig setFullScanMode(boolean fullScanMode) {
        this.fullScanMode_ = fullScanMode;
        return this;
    }

    public boolean fullScanMode() {
        return this.fullScanMode_;
    }

    public PlainTableConfig setStoreIndexInFile(boolean storeIndexInFile) {
        this.storeIndexInFile_ = storeIndexInFile;
        return this;
    }

    public boolean storeIndexInFile() {
        return this.storeIndexInFile_;
    }

    @Override
    protected long newTableFactoryHandle() {
        return this.newTableFactoryHandle(this.keySize_, this.bloomBitsPerKey_, this.hashTableRatio_, this.indexSparseness_, this.hugePageTlbSize_, this.encodingType_.getValue(), this.fullScanMode_, this.storeIndexInFile_);
    }

    private native long newTableFactoryHandle(int var1, int var2, double var3, int var5, int var6, byte var7, boolean var8, boolean var9);
}

